package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import com.intellij.openapi.ui.DialogBuilder;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JComboBox;
import jetbrains.mps.project.MPSProject;
import java.awt.Dimension;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JScrollPane;
import com.intellij.ui.ScrollPaneFactory;
import java.util.List;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;

public class SchemaExportDialog extends DialogBuilder {
  private JComponent myComponent;
  public JTextArea textArea;
  public JComboBox selectedOptions;
  private boolean isOkayButton = false;

  public SchemaExportDialog(MPSProject project, String title, String nodeName) {
    super(project.getProject());


    selectedOptions = new JComboBox<String>();
    selectedOptions.addItem("Oracle schema for " + nodeName);
    selectedOptions.addItem("Oracle alters for " + nodeName);
    selectedOptions.addItem("MySql schema for " + nodeName);
    selectedOptions.addItem("MySql alters for " + nodeName);
    textArea = new JTextArea("");

    this.myComponent = this.createPanel();
    this.setCenterPanel(this.myComponent);
    this.myComponent.setMinimumSize(new Dimension(600, 400));

    this.setTitle(title);
  }

  protected JComponent getMainComponent() {
    return this.myComponent;
  }

  public JComponent createPanel() {
    JPanel panel = new JPanel(new BorderLayout());
    panel.add(selectedOptions, BorderLayout.NORTH);
    panel.add(textArea, BorderLayout.CENTER);

    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(panel);
    scrollPane.getVerticalScrollBar().setBlockIncrement(40);
    scrollPane.getVerticalScrollBar().setUnitIncrement(20);
    scrollPane.getHorizontalScrollBar().setBlockIncrement(40);

    return scrollPane;
  }
  public void setDescriptionsText(List<SNode> allPds) {
    final Wrappers._T<String> text = new Wrappers._T<String>("");
    ListSequence.fromList(allPds).visitAll((it) -> text.value += INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(it) + "\n");
    textArea.setText(text.value);
  }
  public boolean isOkay() {
    return isOkayButton;
  }
  public boolean isResultSelected(ResultSelection sel) {
    switch (selectedOptions.getSelectedIndex()) {
      case 0:
        return sel.equals(ResultSelection.ORACLE_SCHEMA);
      case 1:
        return sel.equals(ResultSelection.ORACLE_ALTER);
      case 2:
        return sel.equals(ResultSelection.MYSQL_SCHEMA);
      case 3:
        return sel.equals(ResultSelection.MYSQL_ALTER);
      default:
        throw new RuntimeException("This can not happen");
    }
  }

  public void showDialog() {
    isOkayButton = super.showAndGet();
  }

  public enum ResultSelection {
    ORACLE_SCHEMA(),
    ORACLE_ALTER(),
    MYSQL_SCHEMA(),
    MYSQL_ALTER()
  }
}
