package org.modellwerkstatt.objectflow.typesystem;

/*Generated by MPS */

import jetbrains.mps.lang.typesystem.runtime.AbstractNonTypesystemRule_Runtime;
import jetbrains.mps.lang.typesystem.runtime.NonTypesystemRule_Runtime;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.typesystem.inference.TypeCheckingContext;
import jetbrains.mps.lang.typesystem.runtime.IsApplicableStatus;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.errors.messageTargets.MessageTarget;
import jetbrains.mps.errors.messageTargets.NodeMessageTarget;
import jetbrains.mps.errors.IErrorReporter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.baseLanguage.behavior.ClassConcept__BehaviorDescriptor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.modellwerkstatt.objectflow.util.OFXLegacyHelper;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.baseLanguage.behavior.Property__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.behavior.BusinessProperty__BehaviorDescriptor;
import jetbrains.mps.baseLanguage.behavior.Classifier__BehaviorDescriptor;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SConcept;

public class check_ValueObject_NonTypesystemRule extends AbstractNonTypesystemRule_Runtime implements NonTypesystemRule_Runtime {
  public check_ValueObject_NonTypesystemRule() {
  }
  public void applyRule(final SNode vo, final TypeCheckingContext typeCheckingContext, IsApplicableStatus status) {
    if ((SLinkOperations.getTarget(vo, LINKS.superclass$Mp9$) == null)) {
      // ok ..
    } else {
      {
        final MessageTarget errorTarget = new NodeMessageTarget();
        IErrorReporter _reporter_2309309498 = typeCheckingContext.reportTypeError(vo, "Value Objects can not be extended right now. They are sealed per default.", "r:150c60e9-5317-48ed-9b80-619f4d069584(org.modellwerkstatt.objectflow.typesystem)", "6002442305760188613", null, errorTarget);
      }

    }


    if (Sequence.fromIterable(ClassConcept__BehaviorDescriptor.constructors_id4_LVZ3pCvsd.invoke(vo)).findFirst((it) -> ListSequence.fromList(SLinkOperations.getChildren(it, LINKS.parameter$5xBj)).count() == 0) == null) {
      {
        final MessageTarget errorTarget = new NodeMessageTarget();
        IErrorReporter _reporter_2309309498 = typeCheckingContext.reportTypeError(vo, "A default constructor with 0 parameters is necessary for a ValueObject.", "r:150c60e9-5317-48ed-9b80-619f4d069584(org.modellwerkstatt.objectflow.typesystem)", "2873275764290573142", null, errorTarget);
      }
    }

    if (ListSequence.fromList(SLinkOperations.getChildren(vo, LINKS.equalProperties$$lik)).count() == 0) {
      {
        final MessageTarget errorTarget = new NodeMessageTarget();
        IErrorReporter _reporter_2309309498 = typeCheckingContext.reportTypeError(vo, "It is crucial to implement equals() in ValueObjects correctly! At least one property for equality is necessary.", "r:150c60e9-5317-48ed-9b80-619f4d069584(org.modellwerkstatt.objectflow.typesystem)", "8176034806578142929", null, errorTarget);
      }
    }

    ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(vo)).where((it) -> (SLinkOperations.getTarget(it, LINKS.type$56v0) != null) && isNotEmptyString(SPropertyOperations.getString(it, PROPS.propertyName$DLW4))).visitAll((final SNode thisProp) -> {
      if (!(OFXLegacyHelper.isInt(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)) || OFXLegacyHelper.isString(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)) || OFXLegacyHelper.isDecimal(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)) || OFXLegacyHelper.isStatus(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)) || OFXLegacyHelper.isDateTime(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)) || OFXLegacyHelper.isLocalDate(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)) || OFXLegacyHelper.isValueObject(SLinkOperations.getTarget(thisProp, LINKS.type$56v0)))) {
        {
          final MessageTarget errorTarget = new NodeMessageTarget();
          IErrorReporter _reporter_2309309498 = typeCheckingContext.reportTypeError(thisProp, "Property in a ValueObject can only be of int/string/BigDecimal/status/DateTime/LocalDate type.", "r:150c60e9-5317-48ed-9b80-619f4d069584(org.modellwerkstatt.objectflow.typesystem)", "8443700925917712818", null, errorTarget);
        }
      } else {
        // okay, do we have a with func?
        boolean found = false;

        // is it a virtual property without a set -> then we do not need a with
        if (SNodeOperations.isInstanceOf(thisProp, CONCEPTS.BusinessProperty$U) && (boolean) Property__BehaviorDescriptor.isCustomImplementation_idhEwIIZC.invoke(SNodeOperations.cast(thisProp, CONCEPTS.BusinessProperty$U))) {
          if ((boolean) BusinessProperty__BehaviorDescriptor.isCustomPropertyGetterOnly_id50keBnNZ1U0.invoke(SNodeOperations.cast(thisProp, CONCEPTS.BusinessProperty$U))) {
            found = true;
          } else {
            {
              final MessageTarget errorTarget = new NodeMessageTarget();
              IErrorReporter _reporter_2309309498 = typeCheckingContext.reportTypeError(thisProp, "Custom set accessor's for virtual properties are not allowed for ValueObjects.", "r:150c60e9-5317-48ed-9b80-619f4d069584(org.modellwerkstatt.objectflow.typesystem)", "87598597435529839", null, errorTarget);
            }
          }

        }


        found = found | Sequence.fromIterable(Classifier__BehaviorDescriptor.methods_id4_LVZ3pBKCn.invoke(vo)).any((m) -> OFXLegacyHelper.isValueObjectMethod(thisProp, m, INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(vo)));
        if (!(found)) {
          {
            final MessageTarget errorTarget = new NodeMessageTarget();
            IErrorReporter _reporter_2309309498 = typeCheckingContext.reportTypeError(vo, "This ValueObject has to provide a function '" + SPropertyOperations.getString(vo, PROPS.name$MnvL) + " " + OFXLegacyHelper.getValueObjFuncName(thisProp) + "(" + SLinkOperations.getTarget(thisProp, LINKS.type$56v0) + " " + SPropertyOperations.getString(thisProp, PROPS.propertyName$DLW4) + ")'.", "r:150c60e9-5317-48ed-9b80-619f4d069584(org.modellwerkstatt.objectflow.typesystem)", "8072308248939966735", null, errorTarget);
          }
        }
      }
    });
  }
  public SAbstractConcept getApplicableConcept() {
    return CONCEPTS.ValueObject$bz;
  }
  public IsApplicableStatus isApplicableAndPattern(SNode argument) {
    return new IsApplicableStatus(argument.getConcept().isSubConceptOf(getApplicableConcept()), null);
  }
  public boolean overrides() {
    return false;
  }
  private static boolean isNotEmptyString(String str) {
    return str != null && str.length() > 0;
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink superclass$Mp9$ = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c108ca66L, 0x10f6353296dL, "superclass");
    /*package*/ static final SContainmentLink parameter$5xBj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1feL, "parameter");
    /*package*/ static final SContainmentLink equalProperties$$lik = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6f25d9824ef9bfaaL, 0x6f25d9824ef9c01fL, "equalProperties");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
  }

  private static final class PROPS {
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept BusinessProperty$U = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, "org.modellwerkstatt.objectflow.structure.BusinessProperty");
    /*package*/ static final SConcept ValueObject$bz = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6f25d9824ef9bfaaL, "org.modellwerkstatt.objectflow.structure.ValueObject");
  }
}
