package org.modellwerkstatt.objectflow.util;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.smodel.builder.SNodeBuilder;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;

public class SQLCreateTableParser {
  private String text;
  private SNode bo = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity"));
  public SQLCreateTableParser(String text) {
    this.text = ((text == null ? null : text.trim()));
    SPropertyOperations.assign(this.bo, PROPS.name$MnvL, "");
  }
  public String skipComment(String input) {
    String ret = input.trim();
    if (ret.startsWith("/*")) {
      return ret.substring(ret.indexOf("*/") + 2, ret.length()).trim();
    }
    return ret;
  }
  public String getComment(String input) {
    String ret = input.trim();
    if (ret.startsWith("/*")) {
      return ret.substring(2, ret.indexOf("*/")).trim();
    }
    return null;
  }
  public String nextWord() {
    int j = text.indexOf("\t");
    int i = text.indexOf(" ");
    if (i == -1) {
      i = j;
    } else if (j != -1 && j < i) {
      i = j;
    }

    if (i == -1) {
      i = text.length();
    }
    String word = StringUtils.substring(text, 0, i).trim();
    text = text.substring(i).trim();
    if (word.endsWith(",")) {
      word = word.substring(0, word.length() - 1);
      if (word.equals("")) {
        return nextWord();
      }
      return word;
    }
    if ((word == null || word.length() == 0)) {
      return null;
    }
    return word;
  }
  public SNode getType(String typeString) {
    boolean decimalSuspicious = false;

    if (typeString.indexOf("(") >= 0) {
      if (typeString.indexOf(",") > typeString.indexOf("(")) {
        decimalSuspicious = true;
      }
      typeString = typeString.substring(0, typeString.indexOf("("));
    }
    typeString = typeString.toLowerCase().trim();
    if (typeString.equals("number")) {
      if (decimalSuspicious) {
        return _quotation_createNode_ngnrzl_a0a0a4a6();
      }
      return _quotation_createNode_ngnrzl_a1a4a6();
    } else if (typeString.equals("varchar2") || typeString.equals("varchar")) {
      return _quotation_createNode_ngnrzl_a0a0e0g();
    } else if (typeString.equals("date")) {
      return _quotation_createNode_ngnrzl_a0a1e0g();
    }
    // default ??
    return null;
  }
  public SNode getBusinessObject() {
    return this.bo;
  }
  public String parse() {
    text = text.replace("NOT NULL", "NOT_NULL");

    System.out.println("\n\n\n ---- starting to parse ---------------------- \n");

    // description has to start with desc keyword
    if (!(StringUtils.substring(text, 0, 12).toLowerCase().equals("create table"))) {
      return "Description does not start with >>create table<< keyWord";
    }

    String tableName = StringUtils.substring(text, 12, text.indexOf("(")).trim();
    //  in case there is a ; in the line ...
    tableName = tableName.replaceAll(";", "");
    System.out.println("TableName: " + tableName);
    text = text.substring(text.indexOf("(") + 1, text.length());

    if ((tableName == null || tableName.length() == 0)) {
      return "Did not find table name in description ";
    }
    if (isEmptyString(SPropertyOperations.getString(this.bo, PROPS.name$MnvL))) {
      SPropertyOperations.assign(this.bo, PROPS.name$MnvL, tableName);
    }


    // start here ...
    text = skipComment(text);

    String word = nextWord();
    String fieldName;
    boolean notNull;

    while (word != null && !(word.equals(");"))) {
      fieldName = word;
      notNull = false;
      System.out.print("starting with fieldname " + fieldName);

      word = nextWord();
      if (word == null) {
        return "no type given for field " + fieldName;
      }
      if (word.equals("NOT_NULL")) {
        notNull = true;
        System.out.print(" is NOT NULL ");
        word = nextWord();
        if (word == null) {
          return "no type given for field " + fieldName + " (NOT NULL)";
        }
      }

      System.out.print(" type: " + word + "\n");

      SNode p = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, "org.modellwerkstatt.objectflow.structure.BusinessProperty"));
      SPropertyOperations.assign(p, PROPS.propertyName$DLW4, fieldName);
      SLinkOperations.setTarget(p, LINKS.type$56v0, getType(word));
      text = skipComment(text);
      text = skipComment(text);
      ListSequence.fromList(SLinkOperations.getChildren(this.bo, LINKS.member$L_2d)).addElement(p);

      word = nextWord();
    }

    return null;
  }
  private static SNode _quotation_createNode_ngnrzl_a0a0a4a6() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_ngnrzl_a1a4a6() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0xf940d22479L, "IntegerType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_ngnrzl_a0a0e0g() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x11d47da71ecL, "StringType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_ngnrzl_a0a1e0g() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~DateTime");
    return quotedNode_1;
  }
  private static boolean isEmptyString(String str) {
    return str == null || str.isEmpty();
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, 0x4a9a46de59132803L, "member");
  }
}
