package org.modellwerkstatt.h2forms.core;

/*Generated by MPS */

import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.springframework.context.support.AbstractApplicationContext;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import javax.servlet.ServletException;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.LocalTime;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.servlet.http.Cookie;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.joda.time.DateTime;
import java.util.Enumeration;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;

@MultipartConfig(fileSizeThreshold = 1024 * 1024, maxFileSize = 1024 * 1024 * 10, maxRequestSize = 1024 * 1024 * 5 * 5)
public class H2ApplicationLoader extends HttpServlet {
  public static final boolean H2_INTERNAL_DEBUG = false;
  public static final String DEFAULT_STATIC_DIR = "static";
  private static final String CHARSET = "UTF-8";
  private static final String frameworkVersion = "H2Forms PRO";
  private static final boolean KILL_AND_RELOAD_SESSION_ON_CHANGING_NETWORK = true;

  public static final String URL_PARAM_RT = "rt";
  public static final String URL_PICUPLOAD = "/picupload/";


  private IGenAppUiModule genApplication;
  private AbstractApplicationContext springAppContext;
  private String appBehaviourFqName;

  private IH2UiFactory uiFactory;
  private AppJmxRegistration jmxRegistration;
  private boolean templatesInitializedWihtoutEx;

  private String deployedAsVersion;

  public H2ApplicationLoader() {
    appBehaviourFqName = "?";
  }

  @Override
  public void init() throws ServletException {
    super.init();
    try {
      Dux.init("/Users/danielstieger/h2hardlog.log");

      // okay, wire up everything
      String xmlConfigFile = getInitParameter("xmlConfigFile");
      springAppContext = new ClassPathXmlApplicationContext(xmlConfigFile);
      uiFactory = ((IH2UiFactory) springAppContext.getBean(IH2UiFactory.class));

      String realPath = this.getServletContext().getRealPath("/");
      int startOfVersion = realPath.indexOf("##");
      if (startOfVersion > 0 && realPath.length() > startOfVersion + 2) {
        deployedAsVersion = realPath.substring(startOfVersion + 2);
        deployedAsVersion = deployedAsVersion.substring(0, deployedAsVersion.length() - 1);
      }

      // check statics
      ContextStatics statics = uiFactory.getContextStatics();
      statics.setMowarePlatform(IOFXCoreReporter.MoWarePlatform.MOWARE_H2);

      statics.setServletPath(this.getServletContext().getContextPath());

      statics.setStaticContentUrlPrefix(getInitParameter("staticContentUrlPrefix"));
      if (statics.getStaticContentUrlPrefix() == null) {
        statics.setStaticContentUrlPrefix(statics.getServletPath() + "/" + DEFAULT_STATIC_DIR + "/" + statics.getTemplateName());

      } else if (statics.getStaticContentUrlPrefix().endsWith("/")) {
        statics.setStaticContentUrlPrefix(statics.getStaticContentUrlPrefix().substring(0, statics.getStaticContentUrlPrefix().length() - 1));
      }

      // according to moware spec, server.instancename is the name of the srv.
      statics.setGuessedServerName(System.getProperty("server.instancename"));

      // main app behavior class will be given via servlet confg
      appBehaviourFqName = getInitParameter("applicationFqName");

      jmxRegistration = new AppJmxRegistration(appBehaviourFqName, deployedAsVersion, realPath, statics.getServletPath());

      ClassLoader classLoader = this.getClass().getClassLoader();
      Class appBehaviorClass = classLoader.loadClass(appBehaviourFqName);

      genApplication = ((IGenAppUiModule) springAppContext.getAutowireCapableBeanFactory().createBean(appBehaviorClass));
      appBehaviourFqName = genApplication.getClass().getName();

      springAppContext.getBean(IM3DatabaseDescription.class).setSessionInfo(genApplication.getShortAppName() + " " + genApplication.getApplicationVersion() + " " + statics.getGuessedServerName());

      uiFactory.initCmdUrlDefaults();
      uiFactory.initExtAuthProviders();

      statics.setApplicationName(genApplication.getShortAppName());
      statics.setAppVersionInfo(genApplication.getShortAppName() + " " + genApplication.getApplicationVersion());

      if (uiFactory.getUploadLocationStore() == null) {
        Dux.hl("NO uploadLocationStore set. setting it to  " + statics.getServletPath() + URL_PICUPLOAD);
        uiFactory.setUploadLocationStore(statics.getServletPath() + URL_PICUPLOAD);
      }

      if (uiFactory.isCheckDeployedVersion() && !(genApplication.getApplicationVersion().equals(deployedAsVersion))) {

        CoreReporterInfo info = createCoreReporterInfo(0, "", "", "", "", IOFXCoreReporter.LogPriority.ERROR, "Application deployed as '" + deployedAsVersion + "' does not match app version '" + genApplication.getApplicationVersion() + "'");
        uiFactory.report(info);
      }

      uiFactory.getEventBus().setSysInfo("" + IOFXCoreReporter.MoWarePlatform.MOWARE_H2 + " " + statics.getGuessedServerName() + ": " + statics.getApplicationName() + " " + genApplication.getApplicationVersion());

      templatesInitializedWihtoutEx = false;
      uiFactory.initRenderer(this.getServletContext());
      templatesInitializedWihtoutEx = true;

      jmxRegistration.registerAppTelemetrics(uiFactory, appBehaviourFqName, genApplication.getShortAppName(), deployedAsVersion, uiFactory.getSystemLabel(-1, MoWareTranslations.Key.MOWARE_VERSION) + " / " + frameworkVersion, statics.getGuessedServerName());

      // full startup - we are ready!
      if (uiFactory.isAutoParDeploymentForwardGracefully()) {
        jmxRegistration.enableAutoForwardGracefully();
      }


      // okay, guess that s it..

    } catch (Exception e) {
      log("Exception in servlet init, setting service as unavailable.", e);
      throw new UnavailableException("Servlet unavailable due to " + e.getClass().getSimpleName() + " " + e.getMessage());
    }
  }



  public HttpSession loginUserCreateApplication(HttpServletRequest request) {
    HttpSession session;

    session = request.getSession(true);
    // logoff parameter is username= etc.
    String username = request.getParameter("username");
    if (username == null) {
      username = uiFactory.getRemoteAddr(request);
    }

    session.setAttribute("userName", username);
    String remoteAddr = uiFactory.getRemoteAddr(request);
    session.setAttribute("remoteAddr", remoteAddr);


    String requestHostname = getCurrentRequestHostName(request);
    ContextClient client = new ContextClient();
    client.setRemoteAddr(remoteAddr);
    client.setRequestHostName(requestHostname);
    session.setAttribute("client", client);

    IH2Controller crtl = uiFactory.createLoginController(genApplication, jmxRegistration, client);
    session.setAttribute("h2controller", crtl);

    setShortSession(session);
    return session;
  }

  public void setShortSession(HttpSession session) {
    // calc timeout to 1h = 60 * 60 in secs
    session.setMaxInactiveInterval(3600);
  }
  public void setLongSession(HttpSession session) {
    // calc timeout to 24:00
    int secondsOfDay = new LocalTime().getMillisOfDay() / 1000;
    session.setMaxInactiveInterval(86400 - secondsOfDay);
  }


  public String getCurrentRequestHostName(HttpServletRequest request) {
    String hostField = request.getHeader("host");
    String hostName = "?";
    if (hostField != null) {
      if (hostField.contains(":")) {
        hostField = hostField.substring(0, hostField.lastIndexOf(":"));
      }
      if (hostField.contains(".")) {
        hostField = hostField.substring(0, hostField.indexOf("."));
      }
      hostName = hostField;
    }
    return hostName;
  }


  public HttpSession shutdownSession(HttpSession session) {
    // do not wait for valueUnbound. call it immediately
    IH2Controller app = ((IH2Controller) session.getAttribute("h2controller"));
    if (app != null) {
      app.externalCloseApplicationWithSessionId(session.getId());
    }

    session.invalidate();
    return null;
  }

  public CoreReporterInfo createCoreReporterInfo(int uId, String uName, String devNameAndSw, String devId, String devRemoteAdr, IOFXCoreReporter.LogPriority prio, String desc) {
    CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_PROBLEM, appBehaviourFqName, genApplication.getApplicationVersion(), IOFXCoreReporter.RT, "", "", prio, uId, uName, devNameAndSw, devId, devRemoteAdr, MoVersion.MOWARE_PLUGIN_VERSION, uiFactory.getContextStatics().getMowarePlatform(), uiFactory.getContextStatics().getGuessedServerName(), desc);
    return info;
  }

  @Override
  protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    // do not serve files ..
    if (request.getRequestURI().contains("/" + DEFAULT_STATIC_DIR + "/")) {
      response.sendError(HttpServletResponse.SC_NOT_FOUND);
      return;
    }

    if (H2_INTERNAL_DEBUG) {
      if (!(templatesInitializedWihtoutEx) || request.getParameter(URL_PARAM_RT) != null) {
        // try again ..
        uiFactory.initRenderer(request.getServletContext());
      }
    }

    String cookieInfos = "";
    Cookie[] allCookies = request.getCookies();
    if (allCookies != null) {
      for (Cookie co : allCookies) {
        cookieInfos += co.getName() + ": " + co.getValue() + " ," + co.getDomain() + "," + co.getVersion() + "," + co.getComment() + "," + co.getMaxAge() + "," + co.getPath() + ";  ";



      }
    }

    HttpSession session = request.getSession(false);

    try {
      long thisServedStartOfRequest = System.currentTimeMillis();
      String thisServedUsername = "?";
      String thisSessionInfo = "?";
      String thisRequestInfo = "?";

      // ISO-8859-1 as response encoding is working quite well. But for others?
      response.setCharacterEncoding(CHARSET);
      request.setCharacterEncoding(CHARSET);

      // someone moved around in our network ---------------------------
      if (session != null && KILL_AND_RELOAD_SESSION_ON_CHANGING_NETWORK) {
        // someone moving with an app from location to location?
        String storedIP = ((String) session.getAttribute("remoteAddr"));
        String currentIP = uiFactory.getRemoteAddr(request);
        String currentUserName = (String) session.getAttribute("userName");

        String deviceAndDeviceSW = "?";
        String clientId = "?";
        int userId = 0;
        String userName = currentUserName;
        ContextClient client = ((ContextClient) session.getAttribute("client"));
        if (client != null) {
          deviceAndDeviceSW = client.getDevice() + " " + client.getDeviceSw();
          clientId = client.getDeviceId();
          userId = client.getUserid();
          userName = client.getUsername();
        }

        if (!(sameNetwork(storedIP, currentIP))) {
          // can we get some infos? 
          session = shutdownSession(session);
          uiFactory.execLocationRedirect(response, uiFactory.getContextStatics().getServletPath());
          jmxRegistration.getAppTelemetrics().servedRequest("-", "-", "ip address changed from " + storedIP + " to " + currentIP + ": shutdown and redirect", -1);

          String msg = " $ $ $ $ " + currentUserName + " $ IPCHANGE $ ";
          log(msg + dumpSessionAndRequestInfo(session, request));

          CoreReporterInfo info = createCoreReporterInfo(userId, userName, deviceAndDeviceSW, clientId, storedIP, IOFXCoreReporter.LogPriority.INFO, "ip adr changed to " + currentIP);
          info.addParameter(CoreReporterInfo.PARAM, "changed from " + storedIP + " to " + currentIP);
          uiFactory.report(info);

          return;
        }
      }

      // username changed  ---------------------------
      if (session != null && request.getParameter("username") != null) {
        // username provided. same as in session
        String storedUsername = ((String) session.getAttribute("userName"));
        String requestedUsername = ((String) request.getParameter("username"));
        if (!(requestedUsername.equals(storedUsername))) {
          session = shutdownSession(session);
          uiFactory.execLocationRedirect(response, uiFactory.getContextStatics().getServletPath() + "?username=" + requestedUsername);

          jmxRegistration.getAppTelemetrics().servedRequest("-", "-", "username changed from " + storedUsername + " to " + requestedUsername + ": shutdown and redirect", -1);
          return;
        }
      }

      // no command parameter, the url was reseted, e.g.broswer restart although a command was running.
      if (session != null && request.getMethod().equals("GET")) {
        // log this as restart ..
        ContextClient client = ((ContextClient) session.getAttribute("client"));
        if (request.getParameter(H2Application.APPSTART_CODE) != null) {

          CoreReporterInfo info = createCoreReporterInfo(client.getUserid(), client.getUsername(), client.getDevice() + " " + client.getDeviceSw(), client.getDeviceId(), client.getRemoteAddr(), IOFXCoreReporter.LogPriority.INFO, "browser start");
          info.addParameter(CoreReporterInfo.PARAM, H2Application.APPSTART_CODE + "=" + request.getParameter(H2Application.APPSTART_CODE) + " / " + cookieInfos);
          uiFactory.report(info);
        }

      }

      jmxRegistration.checkMarkAsForwardGracyFully();

      if (session == null) {
        if (jmxRegistration.markedAsOld()) {
          uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, uiFactory.getContextStatics(), new ContextClient(), new ContextPage(0, false, DeprecatedServerDateProvider.getSqlServerDateTime().getMillis()), new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, uiFactory.getSystemLabel(-1, MoWareTranslations.Key.INFORMATION), uiFactory.getSystemLabel(-1, MoWareTranslations.Key.APPLICATION_REPLACED), null).withReload());
          return;
        }

        session = loginUserCreateApplication(request);
      }



      synchronized (session) {
        IH2Controller crtl = ((IH2Controller) session.getAttribute("h2controller"));
        ContextClient client = ((ContextClient) session.getAttribute("client"));

        if (crtl == null) {
          session = shutdownSession(session);

          if (jmxRegistration.markedAsOld()) {
            uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, uiFactory.getContextStatics(), new ContextClient(), new ContextPage(0, false, DeprecatedServerDateProvider.getSqlServerDateTime().getMillis()), new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, uiFactory.getSystemLabel(-1, MoWareTranslations.Key.INFORMATION), uiFactory.getSystemLabel(-1, MoWareTranslations.Key.APPLICATION_REPLACED), null).withReload());
            return;
          }

          session = loginUserCreateApplication(request);
        }

        thisSessionInfo = ((String) session.getAttribute("remoteAddr")) + " / " + ((String) session.getAttribute("userName"));

        crtl = ((IH2Controller) session.getAttribute("h2controller"));
        thisServedUsername = crtl.getShortUserInfo();

        try {
          thisRequestInfo = "" + crtl;
          crtl.handleRequest(request, cookieInfos);

          IH2Controller newCrtl = crtl.swapToNextController();
          if (newCrtl != null) {
            crtl.externalCloseApplicationWithSessionId(session.getId());
            // initialize new one.
            crtl = newCrtl;
            session.setAttribute("h2controller", crtl);
            // allow to handle request also

            thisRequestInfo = "" + crtl;
            crtl.handleRequest(request, cookieInfos);
            crtl.createResponse(response, "POST".equals(request.getMethod()) && request.getParameter("XMLHttpRequest") != null);

          } else {
            crtl.createResponse(response, "POST".equals(request.getMethod()) && request.getParameter("XMLHttpRequest") != null);

          }

          if (crtl.isRemoveFromSessionAndClose()) {
            Dux.hl("doing a shutdownSession(session) now");
            shutdownSession(session);
          } else if (crtl.hasCommitableSessionRunning()) {
            setLongSession(session);
          } else {
            setShortSession(session);

          }

        } catch (Exception e) {
          // typically ex in tempalte? possbile to reset written data?
          resetWrittenData(response);
          String sessionDump = dumpSessionAndRequestInfo(session, request);

          CoreReporterInfo info = createCoreReporterInfo(client.getUserid(), client.getUsername(), client.getDevice() + " " + client.getDeviceSw(), client.getDeviceId(), client.getRemoteAddr(), IOFXCoreReporter.LogPriority.ERROR, "H2Application crashed with ex while request/response handling by controller");
          info.addParameter(CoreReporterInfo.PARAM, sessionDump);
          info.setException(e);

          uiFactory.report(info);

          String msg = "H2Application crashed with ex while request/response handling by controller: \n\n " + dumpSessionAndRequestInfo(session, request);

          msg += sessionDump + "\n\n\n" + OFXConsoleHelper.stackTrace2String(e);
          response.getWriter().write(msg);
          shutdownSession(session);

        }
        // end of serveH2App()
      }

      //  Check for the early returns above. There are early returns present! 
      jmxRegistration.getAppTelemetrics().servedRequest("request" + thisSessionInfo, thisServedUsername, thisRequestInfo, thisServedStartOfRequest);

    } catch (Exception ex) {
      // try to retrieve more information on this full crash
      String sessionInfo = "(session null)";

      if (session != null) {
        try {
          sessionInfo = dumpSessionAndRequestInfo(session, request);
        } catch (Throwable e) {
          // ignore problems when retrieving info. 
          sessionInfo = "(ex " + e.getClass().getSimpleName() + " " + e.getMessage() + " while retrieving session info)";
        } finally {
          session = shutdownSession(session);
        }
      }

      CoreReporterInfo info = createCoreReporterInfo(0, "", "", "", uiFactory.getRemoteAddr(request), IOFXCoreReporter.LogPriority.FATAL, "H2ApplicationLoader framework " + ex.getClass().getSimpleName() + " " + ex.getMessage());
      info.addParameter(CoreReporterInfo.PARAM, sessionInfo);
      info.setException(ex);
      uiFactory.report(info);


      OFXLogger.log(H2ApplicationLoader.class, IOFXCoreReporter.LogPriority.FATAL, "H2ApplicationLoader framework " + ex.getClass().getSimpleName() + " " + ex.getMessage() + "\n" + sessionInfo, ex);
      jmxRegistration.getAppTelemetrics().incException();

      String msg = ex.getClass().getSimpleName() + ":" + ex.getMessage();
      response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, msg);
    }

  }

  @Override
  protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    String uri = request.getRequestURI();

    if (uri.endsWith(URL_PICUPLOAD) && uiFactory.getUploadFsLocationStore() != null) {
      // no access to jsessionid, no access to client info :(
      Dux.hl("Upload at url '" + URL_PICUPLOAD + "' with UploadFsLocationStore " + uiFactory.getUploadFsLocationStore());

      try {
        Dux.hl(Dux.requestToString(request));

        String fileName = LoadMeUp.handleUpload(uiFactory.getUploadFsLocationStore(), request, response);

      } catch (Exception ex) {
        String ip = uiFactory.getRemoteAddr(request);
        super.log("Problem while uploading a file for " + ip, ex);
        String msg = "Problem while uploading a file for " + ip + ".\n\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage();
        response.getWriter().write(msg);
      }

    } else {
      // handle application
      this.doGet(request, response);
    }
  }

  public void resetWrittenData(HttpServletResponse response) {
    try {
      if (!(response.isCommitted())) {
        response.reset();
      }
    } catch (Exception ex) {
      // ignore
    }
  }
  public String dumpSessionAndRequestInfo(HttpSession session, HttpServletRequest request) {
    String info = "";
    // Requerst parameters
    String tmpInfo = "[REQUEST " + request.getMethod() + " " + request.getRequestURI();


    info += tmpInfo + " ] ";



    if (session == null) {
      tmpInfo = " [ SESSION null ";

    } else {
      tmpInfo = " [ SESSION cT: " + new DateTime(session.getCreationTime()) + ", lAT:" + new DateTime(session.getLastAccessedTime()) + ", mIT " + session.getMaxInactiveInterval() + ", ";

      // Session Values ...
      Enumeration<String> attributes = session.getAttributeNames();
      while (attributes.hasMoreElements()) {
        String atrName = attributes.nextElement();
        tmpInfo += atrName + ": " + session.getAttribute(atrName) + ", ";
      }
    }
    info += tmpInfo + "]  ";

    return info;
  }


  @Override
  public void destroy() {
    uiFactory.getEventBus().close();

    jmxRegistration.gcClean();

    String msg = OFXConsoleHelper.closeConnectionPoolExplicitly(springAppContext);
    if (msg != null) {
      super.log(msg);
    }
    springAppContext.close();
    springAppContext = null;

    DeprecatedServerDateProvider.shutdownAndGcClean();
    MMStaticAccessHelper.shutdownAndGcClean();
    OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG = null;

    super.destroy();
  }

  public static boolean sameNetwork(String ip1, String ip2) {
    if (ip1 != null && ip2 != null && ip1.contains(".") && ip2.contains(".")) {
      String[] net1 = ip1.split("\\.");
      String[] net2 = ip2.split("\\.");
      for (int i = 0; i < 3; i++) {
        if (!(net1[i].equals(net2[i]))) {
          return false;
        }
      }
    }
    return true;
  }

}
