package org.modellwerkstatt.h2forms.mdeauth;

/*Generated by MPS */

import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.h2forms.core.H2Application;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.ContextPage;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.auth.CredentialReporter;
import javax.servlet.http.HttpSessionBindingEvent;

public class H2MpreisLoginOAuth implements IH2Controller {

  protected IH2UiFactory uiFactory;
  protected IGenAppUiModule appMod;
  protected AppJmxRegistration jmxHelper;

  protected H2Application application;
  protected ContextClient client;
  protected LoginController loginController;
  protected IExtAuthProvider provider;

  protected String errorMessage;
  protected String urlToRedirect;
  protected LoginState state;
  protected String thisOAuthState;
  protected OFXUrlParams params;



  public H2MpreisLoginOAuth(IH2UiFactory factory, IGenAppUiModule app, AppJmxRegistration jmx, ContextClient cli) {
    uiFactory = factory;
    appMod = app;
    jmxHelper = jmx;
    client = cli;

    application = null;
    state = LoginState.FIRST_ATTEMPT;
    thisOAuthState = "" + this.hashCode();
    params = new OFXUrlParams();
  }


  public void handleRequest(HttpServletRequest request, String cookieInfo) {
    if (state == LoginState.FIRST_ATTEMPT) {
      params.parse(request.getPathInfo());

      Dux.hl("");
      Dux.hl("state is " + state + " and we are trying direct login (params " + params.asUrl() + ")");

      H2MpreisNoLoginAuth.detectAndSetClient(request, client);
      loginController = new LoginController(uiFactory, uiFactory.getContextStatics().getMowarePlatform(), uiFactory.getContextStatics().getGuessedServerName(), client.getRemoteAddr());

      loginController.logOnCoreReporter("", "", "org.modellwerkstatt.h2forms.mdeauth.H2Login", IOFXCoreReporter.LogPriority.INFO, "While login: [" + client + "] from '" + request.getHeader("user-agent") + "'", null);

      // Exceptions handled internally
      UserEnvironmentInformation env = new UserEnvironmentInformation();
      env.setDevice(client.getDevice(), "" + client.getDeviceSw(), client.getDeviceId());

      String loginUserParamName = request.getParameter("username");
      if (loginUserParamName == null) {
        loginUserParamName = client.getRemoteAddr();
      }

      errorMessage = loginController.checkLoginPrepareUserEnv(loginUserParamName, "", env, appMod);
      Dux.hl("");
      Dux.hl("- - - - - - - - - checkLoginPrepareUserEnv for " + loginUserParamName + " -> " + errorMessage);

      if (errorMessage == null) {
        H2MpreisNoLoginAuth.setSessionUserName(uiFactory, request, env);

        // successfully logged in
        application = new H2Application(uiFactory, appMod, jmxHelper, client);
        application.initializeAndLogin(request, env, cookieInfo);

      } else if (loginController.notAuthenticatedButNoProblems()) {
        errorMessage = null;
        state = LoginState.INITIAL_REQUEST;

      } else {
        // do nothing. first attempt and errormsg set

      }

    }

    if (state == LoginState.INITIAL_REQUEST) {
      provider = prepareProvider(uiFactory, loginController);
      urlToRedirect = provider.initialRedirect(thisOAuthState);
      Dux.hl("state now is " + state + " set redirecting to " + urlToRedirect);


    } else if (state == LoginState.CHECK_TOKEN_RETRIEV_UID) {
      String recState = request.getParameter("state");
      String code = request.getParameter("code");
      Dux.hl("received " + recState + " with code " + code);

      if (!(thisOAuthState.equals(recState))) {
        errorMessage = "Login not possible - oauth states do not match.";
        loginController.logOnCoreReporter("", "", H2MpreisLoginOAuth.class.getName(), IOFXCoreReporter.LogPriority.ERROR, "Login not possible, internal oauth state '" + thisOAuthState + "' does not match received state '" + recState + "'", null);
      } else {
        try {
          String user = provider.retrieveUserWithAccessToken(code);

          UserEnvironmentInformation env = new UserEnvironmentInformation();
          env.setDevice(client.getDevice(), "" + client.getDeviceSw(), client.getDeviceId());

          errorMessage = loginController.checkLoginPrepareUserEnv(user, "", env, appMod);
          if (errorMessage == null) {
            H2MpreisNoLoginAuth.setSessionUserName(uiFactory, request, env);

            // successfully logged in
            application = new H2Application(uiFactory, appMod, jmxHelper, client);
            application.initializeAndLogin(request, env, cookieInfo);
          }

        } catch (IOException e) {
          errorMessage = "Login with oauth not possible or login denied.";
          loginController.logExOnCoreReporter("", "", H2MpreisLoginOAuth.class.getName(), IOFXCoreReporter.LogPriority.ERROR, "Exception while using provider " + provider.getAuthProviderName(), e);
        }


      }


    } else if (state == LoginState.REDIRECT) {
      // noting to do, swap crtl. :) 
    }


  }
  public String getShortUserInfo() {
    return client.getRemoteAddr();
  }

  public IH2Controller swapToNextController() {
    if (state == LoginState.FIRST_ATTEMPT && application != null) {
      return application;

    } else if (state == LoginState.REDIRECT) {
      return application;
    }

    return null;
  }
  public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
    Dux.hl("state is " + state);

    if (state == LoginState.FIRST_ATTEMPT && errorMessage == null) {
      throw new RuntimeException("This can not happen.");

    } else if (state == LoginState.INITIAL_REQUEST && errorMessage == null) {
      if (urlToRedirect == null) {
        throw new RuntimeException("This can not happen.");
      }
      state = LoginState.CHECK_TOKEN_RETRIEV_UID;
      uiFactory.execLocationRedirect(response, urlToRedirect);

      Dux.hl("state now is " + state + " actually redirect now to " + urlToRedirect);
      urlToRedirect = null;

    } else if (state == LoginState.CHECK_TOKEN_RETRIEV_UID && errorMessage == null) {
      state = LoginState.REDIRECT;
      uiFactory.execLocationRedirect(response, uiFactory.getContextStatics().getServletPath() + params.asUrl());

    }

    if (errorMessage != null) {
      Dux.hl("Message to show is " + errorMessage);
      H2Dialog h2msg = new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, uiFactory.getSystemLabel(-1, MoWareTranslations.Key.ERROR), errorMessage, null);
      long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();

      // just display error msg, no login, no app tiles
      uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, uiFactory.getContextStatics(), client, new ContextPage(0, xmlHttpReq, millis), h2msg);

      // shutdownsession will be exec, since errorMsg != null
    }
  }

  public static IExtAuthProvider prepareProvider(IH2UiFactory factory, LoginController crtl) {
    List<IExtAuthProvider> allProviders = factory.getAllExtAuthProviders();
    IExtAuthProvider provider = null;

    if (allProviders.size() != 1) {
      throw new RuntimeException("H2MpreisLoginOAuth() supports just one provider, but we have " + allProviders.size() + " here.");
    } else {
      provider = allProviders.get(0);
    }

    // check expiration if necessary
    LocalDate expDate = provider.getNullOrCredentialExpirationDate();
    if (expDate != null) {
      DateTime now = DeprecatedServerDateProvider.getSqlServerDateTime();
      if (CredentialReporter.checkExpirationDateOnceInWindow(now, expDate)) {
        crtl.logOnCoreReporter("", "", H2MpreisLoginOAuth.class.getName(), IOFXCoreReporter.LogPriority.ERROR, "Credentials for " + provider + " will expire at " + expDate + "!", null);
      }
    }
    return provider;
  }

  public boolean isRemoveFromSessionAndClose() {
    return errorMessage != null;
  }
  public boolean hasCommitableSessionRunning() {
    return false;
  }
  public void valueBound(HttpSessionBindingEvent event) {
  }
  public void valueUnbound(HttpSessionBindingEvent event) {
    // we are stateless anyway
    externalCloseApplicationWithSessionId("null");
  }
  public void externalCloseApplicationWithSessionId(String sessionId) {
    uiFactory = null;
    appMod = null;
    jmxHelper = null;
    loginController = null;
    provider = null;
  }

  public enum LoginState {
    FIRST_ATTEMPT(),
    INITIAL_REQUEST(),
    CHECK_TOKEN_RETRIEV_UID(),
    REDIRECT()
  }
}
