package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import java.io.Writer;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public abstract class AbstractEditor {
  public static final String EDITOR_ID = "editorId";
  public static final String EDITOR_INDEX = "editorIndex";
  public static final String LABEL_TEXT = "labelText";
  public static final String ENABLED = "enabled";
  public static final String FOLDED = "folded";
  public static final String WIDE = "wide";
  public static final String TEXT = "text";
  public static final String VALUE = "value";
  public static final String SELECTEDINDEX = "selectedIndex";
  public static final String ITEMS = "items";
  public static final String REQUEST_FOCUS = "requestFocus";
  public static final String ERROR_TEXT = "errorText";
  public static final String USE_NUMERIC_KEYBOARD = "useNumericKeyboard";
  public static final String IS_DATE_DELEGATE = "isDateDelegate";
  public static final String IS_DATE_DELEGATE_WITH_PICKER = "isDateDelegateWithPicker";
  public static final String SCANABLE = "scanable";
  public static final String MULTILINE = "multiline";
  public static final String MULTILINE_LABELS = "multilineLabels";
  public static final String MULTILINE_VALUES = "multilineValues";
  public static final String UPLOADLOCATIONRETRIEVE = "uploadLocationRetrieve";
  public static final String UPLOADLOCATIONSTORE = "uploadLocationStore";
  public static final String MAX_WIDTH = "maxWidth";
  public static final String MAX_HEIGHT = "maxHeight";
  public static final String ALTER = "alter";

  public static final String NUM_OF_LINES = "numOfLines";

  protected String editorId;
  protected int editorIndex;
  protected String labelText;
  protected boolean enabled;
  protected boolean requestFocus;
  protected String errorText;
  protected boolean folded;
  protected boolean wide;
  protected boolean scanable;


  private boolean initBeforeRenderDone;

  protected Writer writerToUse;
  protected PebbleTemplate compiledTextEditorTemplate;


  public AbstractEditor(String id, PebbleTemplate renderer) {
    editorId = id + "_" + this.hashCode();
    compiledTextEditorTemplate = renderer;
    initBeforeRenderDone = false;

    labelText = "";
    enabled = true;
    requestFocus = false;
    folded = false;
    scanable = false;
    errorText = null;
  }

  public void initBeforeRender(Writer writer, int editIndex) {
    writerToUse = writer;
    editorIndex = editIndex;
    initBeforeRenderDone = true;
  }
  public void newObjectBound() {
    // not used in h2forms
  }
  public Map<String, Object> initAndGetRenderMap() {
    if (!(initBeforeRenderDone)) {
      throw new IllegalStateException("Programming error - initBeforeRender() not called.");
    }

    // initial size is 16, can hold 12 elements before resize
    Map<String, Object> renderMap = MapSequence.fromMap(new HashMap<String, Object>());
    MapSequence.fromMap(renderMap).put(TextEditor.EDITOR_ID, editorId);
    MapSequence.fromMap(renderMap).put(TextEditor.EDITOR_INDEX, editorIndex);
    MapSequence.fromMap(renderMap).put(TextEditor.ENABLED, enabled);
    MapSequence.fromMap(renderMap).put(TextEditor.FOLDED, folded);
    MapSequence.fromMap(renderMap).put(TextEditor.WIDE, wide);
    MapSequence.fromMap(renderMap).put(TextEditor.SCANABLE, scanable);

    MapSequence.fromMap(renderMap).put(TextEditor.LABEL_TEXT, labelText);
    MapSequence.fromMap(renderMap).put(TextEditor.REQUEST_FOCUS, requestFocus);
    MapSequence.fromMap(renderMap).put(TextEditor.ERROR_TEXT, errorText);


    initBeforeRenderDone = false;
    return renderMap;
  }
  public void setValidationErrorText(String text) {
    if ("".equals(text)) {
      text = null;
    }
    errorText = text;
  }
  public boolean isValidationErrorText() {
    return errorText != null;
  }

  public void setLabel(String text) {
    labelText = text;
  }
  public void setEnabled(boolean enbl) {
    enabled = enbl;
  }
  public void requestFocus(boolean doit) {
    requestFocus = doit;
  }

  public abstract void toHtml() throws IOException;
  public abstract void handleRequest(HttpServletRequest req);







  public void enableKeyReleaseEvents() {
  }
  public void setForcedNumericalEditor() {
  }
  public void setIssuesUpdateConclusion() {
    // generally disabled :/
  }
  public void setPreviousIssuesUpadetConclusion() {
  }
  public void setReadOnlyModeNotDisabled() {
  }
  public void setEditorPrompt(String promptText) {
  }
  public void gcClear() {
  }
  public void setLabelTooltip(String text) {
  }
  public Object getEditor() {
    return this;
  }
  public Object getLabel() {
    return this;
  }
  public Object getRightPartComponent() {
    return getEditor();
  }

  public void setOption(IToolkit_TextEditor.Option... option) {
    if (IToolkit_TextEditor.has(IToolkit_TextEditor.Option.FOLDED, option)) {
      folded = true;
    }
    if (IToolkit_TextEditor.has(IToolkit_TextEditor.Option.WIDE, option)) {
      wide = true;
    }
  }

  public static class PebItem {
    public String label;
    public boolean enabled;
    public int itemId;
    public boolean selected;

    public PebItem(String label, boolean enbld, int code, boolean sel) {
      this.label = label;
      this.itemId = code;
      this.enabled = enbld;
      this.selected = sel;
    }


    @Override
    public String toString() {
      return String.format("[%s %d]", label, itemId);
    }
  }

}
