package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.joda.time.format.DateTimeFormatter;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import org.joda.time.LocalDate;
import javax.servlet.http.HttpServletRequest;

public class DateOrTimeEditor extends TextEditor implements IToolkit_DateOrTimeEditor {
  private IH2UiFactory uiFactory;
  private DateTimeFormatter formatter;

  public DateOrTimeEditor(IH2UiFactory factory, PebbleTemplate tmpl, boolean withPicker) {
    super("datEditor", tmpl);
    if (withPicker) {
      isDateDelegateWithPicker = true;
      uiFactory = factory;
    }
    // two editors are suppored - the texteditor date enhancement (js replacement)
    // the date picker, later is handled in this class.

  }



  @Override
  public void setFormatter(String format, String locale, int langIdx) {
    if (isDateDelegateWithPicker) {
      formatter = uiFactory.getTransProvider().getLocalDateFormatter(langIdx, format);
    }
  }


  @Override
  public void toHtml() throws IOException {
    if (isDateDelegateWithPicker && !("".equals(text))) {
      String origText = text;

      LocalDate date = formatter.parseLocalDate(text);
      text = String.format("%d-%02d-%02d", date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
      super.toHtml();

      text = origText;

    } else {
      super.toHtml();

    }
  }

  @Override
  public void handleRequest(HttpServletRequest req) {
    super.handleRequest(req);

    if (enabled && isDateDelegateWithPicker && !("".equals(text))) {
      // format is yyyy-mm-dd
      String[] splt = text.split("-");
      int year = Integer.valueOf(splt[0]);
      int month = Integer.valueOf(splt[1]);
      int day = Integer.valueOf(splt[2]);
      text = formatter.print(new LocalDate(year, month, day));
    }
  }

  @Override
  public void gcClear() {
    super.gcClear();
    uiFactory = null;
    formatter = null;
  }

  public static void main(String[] args) {
    String st = "2022-01-15";
    String[] splt = st.split("-");
    System.err.println(splt[0].substring(2));
    System.err.println(splt[1]);
    System.err.println(splt[2]);

  }


}
