package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import java.io.Writer;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.dataux.runtime.delegates.StatusDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.ReferenceDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.UploadDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.ImageDelegate;

public class DelegateForm<T> extends AbstractForm implements IToolkit_DelegateForm<T> {

  private List<AbstractEditor> editors;
  private List<IDataUxDelegate> formDelegates;


  public DelegateForm(PebbleTemplate template) {
    super(template);
    formDelegates = ListSequence.fromList(new ArrayList<IDataUxDelegate>());
    editors = ListSequence.fromList(new ArrayList<AbstractEditor>());
  }
  public String checkDelegatesValidAndFocus() {
    int focussedOnError = -1;
    String errText;
    String firstErr = null;


    for (int i = 0; i < ListSequence.fromList(this.formDelegates).count(); i++) {
      errText = ListSequence.fromList(this.formDelegates).getElement(i).isInputValid();

      if (errText != null && focussedOnError == -1) {
        focussedOnError = i;
        firstErr = errText;
      }
    }

    // set focus on error.
    if (focussedOnError != -1) {
      // clear others ...
      for (int i = 0; i < ListSequence.fromList(this.formDelegates).count(); i++) {
        ListSequence.fromList(editors).getElement(i).requestFocus(false);
      }
      ListSequence.fromList(editors).getElement(focussedOnError).requestFocus(true);
    }

    return firstErr;
  }


  public void setColLayoutConstraints(List<String> constraints) {
  }
  public void addDelegate(IDataUxDelegate delegate) {
    ListSequence.fromList(formDelegates).addElement(delegate);
    ListSequence.fromList(editors).addElement(((AbstractEditor) delegate.getDelegateUiImpl().getEditor()));
  }
  public boolean selectionChanged(IOFXSelection<T> selection) {
    return true;
  }
  public void loadList(List<T> objects, IOFXSelection<T> selection) {
  }
  public void gcClear() {
    // gcClear on Delegates is called by IGenControlled
  }
  public Object myRequestFocus() {
    // check for readOnly?
    Object focussed = null;
    int focussedOn = -10;

    // serialization base system has to clear focus first...
    for (int i = 0; i < ListSequence.fromList(this.formDelegates).count(); i++) {
      ListSequence.fromList(editors).getElement(i).requestFocus(false);
    }

    for (int i = 0; i < ListSequence.fromList(this.formDelegates).count(); i++) {
      if (ListSequence.fromList(formDelegates).getElement(i).isRequestFocus()) {
        focussed = ListSequence.fromList(formDelegates).getElement(i);
        ListSequence.fromList(editors).getElement(i).requestFocus(true);
        focussedOn = i;

        break;
      }
    }

    if (focussed == null) {
      for (int i = 0; i < ListSequence.fromList(this.formDelegates).count(); i++) {
        if (ListSequence.fromList(formDelegates).getElement(i).isEnabled()) {
          focussed = ListSequence.fromList(formDelegates).getElement(i);
          ListSequence.fromList(editors).getElement(i).requestFocus(true);
          focussedOn = i;
          break;
        }
      }
    }

    return focussed;
  }


  @Override
  public AbstractEditor firstEditorFocused() {
    for (int i = 0; i < ListSequence.fromList(this.editors).count(); i++) {
      AbstractEditor dlgt = ListSequence.fromList(this.editors).getElement(i);
      if (dlgt.requestFocus) {
        return dlgt;
      }
    }
    return null;
  }
  @Override
  public void initBeforeRender(int id, Writer writer, ContextStatics stat, ContextClient clnt, ContextPage pg) {
    super.initBeforeRender(id, writer, stat, clnt, pg);
    for (int i = 0; i < ListSequence.fromList(formDelegates).count(); i++) {
      ListSequence.fromList(editors).getElement(i).initBeforeRender(writer, i);
    }

  }
  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();
    MapSequence.fromMap(renderMap).put(DELEGATES, editors);

    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
  }


  public void delegateDataInForm(final HttpServletRequest request) {
    ListSequence.fromList(editors).visitAll((it) -> it.handleRequest(request));
  }

  public boolean delegatesNeedKeyboard() {
    for (IDataUxDelegate delegate : formDelegates) {
      if (delegate.isEnabled() && !(delegate instanceof StatusDelegate || delegate instanceof ReferenceDelegate || delegate instanceof UploadDelegate || delegate instanceof ImageDelegate)) {
        return true;
      }
    }
    return false;
  }

  public boolean actionInForm(int formId, int selectionNum, int actionId) {
    // only implemented for TableForm and FormContainer
    // just would n extend the object hierarchy further by divisions
    return false;
  }

  public String debugInfo() {
    return "DelegateForm (no info)";
  }
}
