package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import javax.servlet.ServletContext;
import com.mitchellbosecke.pebble.loader.ServletLoader;
import org.modellwerkstatt.h2forms.core.H2ApplicationLoader;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;

/**
 * The Themplate Renderer itself is stateless regarding the application,
 * however, it is not stateless regarding windows or message boxes. 
 * 
 * Since user can press reload multiple times, we have to restore 
 * window/screen state ... 
 * 
 * and also check for appSequence, since one can no execute same 
 * request multiple times! 
 * 
 * 
 * 
 */
public class PebbleTemplateRenderer implements IH2FormsTemplateRenderer {
  public static final String TEMPLATE_ENDING = "peb";

  private PebbleEngine engine;
  private PebbleTemplate compiledHomeTemplate;
  private PebbleTemplate compiledLoginTemplate;



  public PebbleTemplateRenderer() {
  }

  public void initTemplates(ServletContext context, String templateName, String homeTemplate, String loginTemplate) {
    engine = new PebbleEngine.Builder().loader(new ServletLoader(context)).strictVariables(true).build();
    compiledHomeTemplate = compileTemplateFor(templateName, homeTemplate);
    compiledLoginTemplate = compileTemplateFor(templateName, loginTemplate);
  }

  public PebbleTemplate compileTemplateFor(String templateName, String template) {
    return engine.getTemplate("/" + H2ApplicationLoader.DEFAULT_STATIC_DIR + "/" + templateName + "/" + template + "." + TEMPLATE_ENDING);
  }

  public void handleRequest(HttpServletRequest request, String naviCrtl, IToolkit_CommandContainerUi currentContainerUI) {
    // do nothing ?
    if (currentContainerUI != null) {
      ((CommandContainerUi) currentContainerUI).handleRequest(request, naviCrtl);
    }
  }

  public void handleResponse(HttpServletResponse response, ContextStatics statics, ContextClient client, ContextPage page, H2Dialog infoMessage, IToolkit_CommandContainerUi currentContainerUI) throws IOException {

    // handle message box here. In case of messages, template can decide, if
    // form of page / menu is also rendered or not!

    if (currentContainerUI == null) {
      throw new RuntimeException("This can not happen - internal H2Forms error.");
    }
    ((CommandContainerUi) currentContainerUI).handleResponse(response, statics, client, page, infoMessage);
  }

  public void handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage typeOfPage, HttpServletResponse response, ContextStatics statics, ContextClient client, ContextPage page, H2Dialog infoMessage) throws IOException {

    page.setScrollPosition(-1);
    Map<String, Object> renderMap = CommandContainerUi.createDefaultMapForCommandUI(statics, client, page, infoMessage);

    if (typeOfPage == IH2FormsTemplateRenderer.SpecialPage.LOGIN_PAGE) {
      AbstractForm.PebAction someAction = new AbstractForm.PebAction("Ok", false, null, null, 0, 0, null);
      someAction.adjustEnabled(true);

      // need keyboard to log in?
      MapSequence.fromMap(renderMap).put(AbstractForm.KEYBOARD, true);

      compiledLoginTemplate.evaluate(response.getWriter(), renderMap);

    } else if (typeOfPage == IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE) {
      compiledHomeTemplate.evaluate(response.getWriter(), renderMap);

    } else {
      throw new IllegalStateException("Unknonwn page type to render: " + typeOfPage);
    }
  }

}
