package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import java.util.List;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.ReferenceDelegate;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import javax.servlet.http.HttpServletRequest;

public class ReferenceEditor extends AbstractEditor implements IToolkit_ReferenceEditor {
  protected String value;
  protected String promptText;
  protected String propertyName;
  protected String optionalLabelText;

  protected List<AbstractEditor.PebItem> items;
  protected int selectedIndex;
  protected boolean optional;
  protected boolean alternativEditor;

  public ReferenceEditor(PebbleTemplate tmpl, boolean alter) {
    super("refEditor", tmpl);
    items = ListSequence.fromList(new ArrayList<AbstractEditor.PebItem>());
    selectedIndex = -1;
    value = null;
    optional = false;
    alternativEditor = alter;
  }

  public ReferenceEditor(String id, PebbleTemplate tmpl, boolean alter) {
    super(id, tmpl);
    items = ListSequence.fromList(new ArrayList<AbstractEditor.PebItem>());
    selectedIndex = -1;
    alternativEditor = alter;
  }

  public void setOption(IToolkit_TextEditor.Option... option) {
    super.setOption(option);
  }

  public void setItems(List<String> stringItems) {
    ListSequence.fromList(items).clear();
    selectedIndex = -1;

    for (int i = 0; i < ListSequence.fromList(stringItems).count(); i++) {
      String itemLabel = ListSequence.fromList(stringItems).getElement(i);
      if (itemLabel == null) {
        throw new IllegalStateException("Do not uses null labels in reference/status delegates! item " + i + "is null: " + stringItems);
      }
      AbstractEditor.PebItem itm = new AbstractEditor.PebItem(itemLabel, true, i, false);
      ListSequence.fromList(items).addElement(itm);
    }
  }
  public void setPromptText(String text) {
    promptText = text;
  }
  public void setDelegate(IDataUxDelegate dlgt) {
    propertyName = dlgt.getPropertyName();
  }
  public void setText(String txt) {
    value = txt;
    selectedIndex = -1;
  }
  public String getText() {
    return value;
  }
  public void setOptionalAfterLoad(boolean opt) {
    optional = opt;

    // Not called for StatusEditor ...
    if (this instanceof StatusEditor) {
      throw new RuntimeException("This can not happen");
    }

    // add optional ony if not in items, since we can not rely on having
    // setItems always called before this "AfterLoad" -> ReferenceDelegate
    if (opt && !(ListSequence.fromList(items).count() > 0 && ReferenceDelegate.GENERAL_OPTIONAL_ITEM_TEXT.equals(ListSequence.fromList(items).first().label))) {
      int optionalIndex = ListSequence.fromList(items).count();

      ListSequence.fromList(items).insertElement(0, new AbstractEditor.PebItem(ReferenceDelegate.GENERAL_OPTIONAL_ITEM_TEXT, true, optionalIndex, false));
    }
  }
  @Override
  public void setIssuesUpdateConclusion() {
    scanable = true;
  }

  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();

    MapSequence.fromMap(renderMap).put(ITEMS, items);
    MapSequence.fromMap(renderMap).put(VALUE, value);
    MapSequence.fromMap(renderMap).put(ALTER, alternativEditor);

    // recalc slected elem ...
    boolean selected = false;
    selectedIndex = -1;
    for (int i = 0; i < ListSequence.fromList(items).count(); i++) {
      selected = ListSequence.fromList(items).getElement(i).label.equals(value);
      if (optional && value == null) {
        selected = ListSequence.fromList(items).getElement(i).label.equals(ReferenceDelegate.GENERAL_OPTIONAL_ITEM_TEXT);
      }

      if (selected && selectedIndex != -1) {
        String msg = "This should not happen, we already selected item " + selectedIndex + " / " + ListSequence.fromList(items).getElement(selectedIndex) + " vs. " + i + " / " + ListSequence.fromList(items).getElement(i) + "\n";
        msg += "(all items are " + items + ")";
        throw new IllegalStateException(msg);
      }
      if (selected) {
        selectedIndex = i;
      }
      ListSequence.fromList(items).getElement(i).selected = selected;
    }
    MapSequence.fromMap(renderMap).put(SELECTEDINDEX, selectedIndex);

    if (ListSequence.fromList(items).count() > 0) {
      //  okay,

    } else if (ListSequence.fromList(items).count() == 0 && !(enabled)) {
      MapSequence.fromMap(renderMap).put(ITEMS, ListSequence.fromListAndArray(new ArrayList<AbstractEditor.PebItem>(), new AbstractEditor.PebItem(value, true, 0, true)));

      // this is the case, if no scope is set
      // but a value and the delegate was setEnabled false

    } else {

    }

    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
    requestFocus = false;
  }

  public void handleRequest(HttpServletRequest req) {
    if (!(enabled)) {
      return;
    }

    String val = req.getParameter(editorId);
    if (val == null || "".equals(val)) {
      // Can happen, if <option selected disabled> is used the first page load
      value = null;

    } else {
      selectedIndex = Integer.valueOf(val);
      AbstractEditor.PebItem selectedItem = ListSequence.fromList(items).findFirst((it) -> it.itemId == selectedIndex);
      if (selectedItem == null) {
        value = null;

      } else {
        value = selectedItem.label;

      }

      if (optional && ReferenceDelegate.GENERAL_OPTIONAL_ITEM_TEXT.equals(value)) {
        value = null;
      }
    }
  }
}
