package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TableForm;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.objectflow.runtime.Selection;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import javax.servlet.http.HttpServletRequest;

public class TableForm<T> extends AbstractForm implements IToolkit_TableForm<T> {

  private List<T> currentlyBoundObjects;
  private List<Column> columns;
  private IOFXSelection currentSelection;
  private List<CmdAction> dataUxMenuItems;
  private List<AbstractForm.PebAction> actions;

  private boolean hasActions;
  private IGenSelControlled formController;
  private String footer;

  private AbstractColumnDivider colDivider;

  public TableForm(PebbleTemplate template, AbstractColumnDivider div) {
    super(template);
    hasActions = false;
    footer = null;
    colDivider = div;
    columns = new ArrayList<Column>();
  }

  public void endOfInitializationForElementClass(Class cls) {
    colDivider.init(columns);
  }
  public void setFormController(IGenSelControlled crtl) {
    formController = crtl;
  }
  public void addColumn(String property, String label, ITableCellStringConverter converter, int width, boolean editable, boolean folded, boolean important) {
    // folded ignored
    columns.add(new Column(property, label, converter, width, important));
  }
  public void setSelectionSummaryLineText(String text) {
  }
  public void setTableSummaryLineText(String text) {
    if (text != null && !(text.trim().equals(""))) {
      footer = text;
    } else {
      footer = null;
    }
  }
  public void addMenuAndSetButtons(Menu folder) {
    dataUxMenuItems = new ArrayList<CmdAction>();
    actions = new ArrayList<AbstractForm.PebAction>();

    for (CmdAction item : folder.getAllCmdActionsOfMenu()) {
      String convertedImgName = MaterialIconsConverter.codeFor(item.image);
      AbstractForm.PebAction action = new AbstractForm.PebAction(item.labelText, item.hideWhenDisabled, item.image, convertedImgName, this.hashCode(), item.hashCode(), item.hotKey);
      dataUxMenuItems.add(item);
      actions.add(action);
    }

    hasActions = true;
  }
  public boolean selectionChanged(IOFXSelection<T> selection) {

    currentSelection = selection;
    return true;
  }
  public void loadList(List<T> objects, IOFXSelection<T> selection) {

    currentlyBoundObjects = objects;
    currentSelection = selection;
  }
  public Object myRequestFocus() {
    return null;
  }
  public void forceNotEditable() {
  }
  public void setEditPreview() {
  }
  public boolean actionInForm(int formId, int selectionNum, int actionId) {

    if (hasActions && formId == this.hashCode()) {
      // okay, this is for us..
      formController.pushSelection(new Selection(currentlyBoundObjects.get(selectionNum)));
      // start trigger ? triggedId should be the hashCode of respective trigger
      for (CmdAction t : dataUxMenuItems) {
        if (t.hashCode() == actionId) {
          if (t.reevalEnabled()) {
            t.startCommand();

          } else {
            // set error text
            throw new H2FormRequestStateException("This can not be true: " + t.labelText + " is disabled for selection " + selectionNum);
          }
        }
      }
      return true;
    }
    return false;
  }

  public void addTableItemColor(String property, ITableCellStringConverter converter) {
  }

  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();

    MapSequence.fromMap(renderMap).put(ACTIONS, null);
    MapSequence.fromMap(renderMap).put(FOOTER, footer);
    MapSequence.fromMap(renderMap).put(TABLE_COLUMNS, columns);
    MapSequence.fromMap(renderMap).put(CURRENT_SELECTION, currentSelection);
    // since it will be cleared by pushSelection() temporarily store it here..

    List<Row> tableRows = ListSequence.fromList(new ArrayList<Row>());
    IOFXSelection originalSelection = currentSelection;

    for (int line = 0; line < currentlyBoundObjects.size(); line++) {
      Object curObj = currentlyBoundObjects.get(line);
      Row row = new Row(line, originalSelection.getObjectOrNull() == curObj, actions);

      if (hasActions) {
        dataUxMenuItems.get(0).getLocalSelController().pushSelectionAbsolute(new Selection(curObj));
        for (int j = 0; j < dataUxMenuItems.size(); j++) {
          CmdAction mae = dataUxMenuItems.get(j);
          row.setActionEnabled(actions.get(j), mae.reevalEnabled());
        }
      }

      for (int cell = 0; cell < columns.size(); cell++) {
        Column currentColumn = columns.get(cell);
        Object currentPropData = MoJSON.get(curObj, currentColumn.property);
        String itemColor = currentColumn.converter.getBgColor(currentPropData);
        String dataAsString = currentColumn.converter.convert(currentPropData);

        // convert to string and go on
        row.addCell(dataAsString, itemColor, colDivider.needsOpenRow(cell), colDivider.getSizeS(cell), colDivider.getSizeM(cell), colDivider.needsCloseRow(cell), currentColumn.important);
      }

      int emptyCellsToAdd = colDivider.numOfEmptyCellToAdd();
      for (int e = 0; e < emptyCellsToAdd; e++) {
        row.addCell("", null, colDivider.needsOpenRow(e), colDivider.getSizeS(e), colDivider.getSizeM(e), colDivider.needsCloseRow(e), false);
      }

      ListSequence.fromList(tableRows).addElement(row);
    }

    if (hasActions) {
      dataUxMenuItems.get(0).getLocalSelController().pushSelectionAbsolute(originalSelection);
    }

    MapSequence.fromMap(renderMap).put(TABLE_ROWS, tableRows);


    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
  }


  public void delegateDataInForm(HttpServletRequest request) {
  }

  public boolean delegatesNeedKeyboard() {
    return false;
  }

  @Override
  public AbstractEditor firstEditorFocused() {
    return null;
  }
  public String debugInfo() {
    String s = "TableForm.debugInfo()\n";
    for (CmdAction gl : dataUxMenuItems) {
      s += gl.commandFqName + " : " + gl.hashCode() + "\n";

    }
    return s;
  }
  public void gcClear() {
  }

  public static class Column {
    public ITableCellStringConverter converter;
    public String property;
    public String label;
    public int width;
    public boolean important;

    public Column(String prop, String lab, ITableCellStringConverter conv, int wid, boolean imp) {
      this.property = prop;
      this.label = lab;
      this.converter = conv;
      this.width = wid;
      this.important = imp;
    }
  }

  public static class Row {
    public List<Cell> cells;
    public int index;
    public int numActions;
    public boolean selected;


    public Row(int indx, boolean sel, List<AbstractForm.PebAction> act) {
      this.cells = ListSequence.fromList(new ArrayList<Cell>());
      this.enabledActions = ListSequence.fromList(new ArrayList<Boolean>());
      this.actions = act;
      this.index = indx;
      this.numActions = ListSequence.fromList(act).count();
      this.selected = sel;
    }
    public void addCell(String cellContent, String color, boolean openRow, int sizeS, int sizeM, boolean closeRow, boolean imp) {
      ListSequence.fromList(this.cells).addElement(new Cell(cellContent, color, openRow, sizeS, sizeM, closeRow, imp));
    }
    public void setActionEnabled(AbstractForm.PebAction act, boolean enabled) {
      ListSequence.fromList(this.enabledActions).addElement(enabled);
    }
    public List<AbstractForm.PebAction> getActions() {
      for (int i = 0; i < ListSequence.fromList(actions).count(); i++) {
        ListSequence.fromList(actions).getElement(i).adjustEnabled(ListSequence.fromList(enabledActions).getElement(i));
      }
      return actions;
    }
    public AbstractForm.PebAction getMainAction() {
      if (ListSequence.fromList(actions).count() == 0) {
        return null;
      }
      AbstractForm.PebAction firstOne = ListSequence.fromList(actions).getElement(0);
      firstOne.adjustEnabled(ListSequence.fromList(enabledActions).getElement(0));
      return firstOne;
    }

    /**
     * Both private, only accessible via getActions()
     */
    private List<AbstractForm.PebAction> actions;
    private List<Boolean> enabledActions;
  }

  public static class Cell {
    public String content;
    public String color;
    public int sizeM;
    public int sizeS;
    public boolean openRow;
    public boolean closeRow;
    public boolean important;

    public Cell(String content, String color, boolean open, int ss, int sm, boolean close, boolean imp) {
      this.content = content;
      this.color = color;
      this.important = imp;
      this.sizeM = sm;
      this.sizeS = ss;

      this.openRow = open;
      this.closeRow = close;
    }

  }
}
