package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.IntegerDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.DecimalDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.DateTimeDateDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.LocalDateDelegate;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;

public class TextEditor extends AbstractEditor implements IToolkit_TextEditor {
  protected String text;

  protected boolean useNumericKeyboard = false;
  protected boolean isDateDelegate = false;
  protected boolean isDateDelegateWithPicker = false;
  protected int multilineCount = 1;



  public TextEditor(PebbleTemplate template, int numOfLines) {
    super("txEditor", template);
    multilineCount = numOfLines;
  }

  public TextEditor(String name, PebbleTemplate template) {
    super(name, template);
  }

  public void setDelegate(IDataUxDelegate dlgt) {
    if (dlgt instanceof IntegerDelegate || dlgt instanceof DecimalDelegate) {
      useNumericKeyboard = true;

    } else if (dlgt instanceof DateTimeDateDelegate || dlgt instanceof LocalDateDelegate) {
      useNumericKeyboard = true;
      isDateDelegate = true;

    } else if (useNumericKeyboard) {
      // already set, probably by force.

    }

    // multiline on h2forms is alsways disabled, since the input will be missing
    if (isMultiLine()) {
      dlgt.setDisableFORCE();
    }

  }
  public void setText(String tx) {
    text = tx;
  }
  public String getText() {
    return text;
  }
  @Override
  public void setIssuesUpdateConclusion() {
    scanable = true;
  }


  @Override
  public void setOption(IToolkit_TextEditor.Option... option) {
    if (IToolkit_TextEditor.has(IToolkit_TextEditor.Option.FORCE_NUMERICAL_EDITOR, option)) {
      useNumericKeyboard = true;
    }
    super.setOption(option);
  }

  public boolean isMultiLine() {
    return multilineCount > 1;
  }
  public String[] calcLabels(String theText) {

    String[] lines = theText.split("\\r?\\n");
    for (int i = 0; i < lines.length; i++) {
      lines[i] = lines[i].trim();
    }
    return lines;
  }

  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();
    MapSequence.fromMap(renderMap).put(USE_NUMERIC_KEYBOARD, useNumericKeyboard);
    MapSequence.fromMap(renderMap).put(IS_DATE_DELEGATE, isDateDelegate);
    MapSequence.fromMap(renderMap).put(IS_DATE_DELEGATE_WITH_PICKER, isDateDelegateWithPicker);

    MapSequence.fromMap(renderMap).put(TEXT, text);

    MapSequence.fromMap(renderMap).put(MULTILINE, isMultiLine());
    MapSequence.fromMap(renderMap).put(NUM_OF_LINES, multilineCount);

    if (isMultiLine()) {
      MapSequence.fromMap(renderMap).put(MULTILINE_LABELS, calcLabels(labelText));
      MapSequence.fromMap(renderMap).put(MULTILINE_VALUES, calcLabels(text));

    } else {
      MapSequence.fromMap(renderMap).put(MULTILINE_LABELS, null);
      MapSequence.fromMap(renderMap).put(MULTILINE_VALUES, null);
    }

    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
  }
  public void handleRequest(HttpServletRequest req) {
    if (!(enabled)) {
      return;
    }

    String val = req.getParameter(editorId);

    if (val == null) {
      throw new H2FormRequestStateException("Client did not provide editor information in form for ATextEditor: EditorId " + editorId);

    } else {
      text = val;

    }
  }

}
