package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

public class TwoOnTopRestBelowDivider extends AbstractColumnDivider {
  protected int firstColSize;
  protected int secondColSize;
  protected int lowerColsSize;

  protected int numOfEmptiesToAdd;


  public TwoOnTopRestBelowDivider() {
    super();
  }

  @Override
  public void init(List<TableForm.Column> cols) {
    super.init(cols);

    firstColSize = 1;
    secondColSize = 1;
    lowerColsSize = 1;

    if (columnsTotal == 2 || columnsTotal == 3) {
      lowerColsSize = 2;

    } else if (columnsTotal >= 5) {
      int lowSpan = columnsTotal - 2;
      firstColSize = lowSpan / 2 + 1;
      secondColSize = lowSpan - firstColSize;
      // lower is always 1
    }

    // 1: 1, 1       -> remainder 1
    // 2: 1, 1, 2    -> remainder 1
    // 3: 1, 1, 2    -> remainder 0
    // 4: 1, 1, 1, 1 -> remainder 0
    numOfEmptiesToAdd = 0;
    if (columnsTotal <= 2) {
      numOfEmptiesToAdd = 1;

    }
  }

  public boolean needsCloseRow(int colIndex) {
    if (colIndex == 0 && columnsTotal == 1) {
      return true;
    }
    // two always closes
    if (colIndex == 1) {
      return true;
    }
    if (colIndex == (columnsTotal - 1)) {
      return true;
    }
    return false;
  }

  public boolean needsOpenRow(int colIndex) {
    if (colIndex == 0) {
      return true;
    }
    if (colIndex == 1 && columnsTotal == 1) {
      // only in case of one total
      return true;
    }
    if (colIndex == 2) {
      // always opens
      return true;
    }
    return false;
  }

  public int getSizeS(int colIndex) {
    if (colIndex == 0) {
      return firstColSize;
    }
    if (colIndex == 1) {
      return secondColSize;
    }
    return lowerColsSize;
  }
  public int getSizeM(int colIndex) {
    return getSizeS(colIndex);
  }

  public int numOfEmptyCellToAdd() {
    return numOfEmptiesToAdd;
  }


  public static void main(String[] args) {
    TableForm.Column cProto = new TableForm.Column("prop", "lab", null, 100, false);
    TwoOnTopRestBelowDivider d1 = new TwoOnTopRestBelowDivider();
    d1.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), cProto));

    TwoOnTopRestBelowDivider d2 = new TwoOnTopRestBelowDivider();
    d2.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), cProto, cProto));

    TwoOnTopRestBelowDivider d3 = new TwoOnTopRestBelowDivider();
    d3.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), cProto, cProto, cProto));

    TwoOnTopRestBelowDivider d4 = new TwoOnTopRestBelowDivider();
    d4.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), cProto, cProto, cProto, cProto));

    TwoOnTopRestBelowDivider d5 = new TwoOnTopRestBelowDivider();
    d5.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), cProto, cProto, cProto, cProto, cProto));

    TwoOnTopRestBelowDivider d6 = new TwoOnTopRestBelowDivider();
    d6.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), cProto, cProto, cProto, cProto, cProto, cProto));


    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d1));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d2));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d3));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d4));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d5));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d6));
  }

}
