package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

public class TwoTop12Divider extends AbstractColumnDivider {
  private List<Integer> singleLineWeights;
  private List<Boolean> closingRow;


  public TwoTop12Divider() {
    super();
  }

  @Override
  public void init(List<TableForm.Column> cols) {
    super.init(cols);

    if (ListSequence.fromList(cols).count() > 12) {
      throw new RuntimeException("This table column-divider only supports only up to 12 cols. You are using " + ListSequence.fromList(cols).count() + " cols.");
    }

    singleLineWeights = ListSequence.fromList(new ArrayList<Integer>());
    closingRow = ListSequence.fromList(new ArrayList<Boolean>());


    int numInLower = ListSequence.fromList(cols).count() - 2;
    int sizeLower = 6 / numInLower;
    int done = 0;

    for (int i = 0; i < ListSequence.fromList(cols).count(); i++) {
      if (i == 0) {
        // 3
        ListSequence.fromList(singleLineWeights).addElement(3);
        ListSequence.fromList(closingRow).addElement(false);
        done += 3;
      } else if (i == 1) {
        ListSequence.fromList(singleLineWeights).addElement(3);
        ListSequence.fromList(closingRow).addElement(false);
        done += 3;
      } else if (i == (ListSequence.fromList(cols).count() - 1)) {
        // last one
        ListSequence.fromList(singleLineWeights).addElement(12 - done);
        ListSequence.fromList(closingRow).addElement(false);

      } else {
        ListSequence.fromList(singleLineWeights).addElement(sizeLower);
        ListSequence.fromList(closingRow).addElement(false);
        done += sizeLower;
      }

    }

    // final check ..

    // where do we divide cols?
    int sum = 0;
    for (int i = 0; i < ListSequence.fromList(singleLineWeights).count(); i++) {
      sum += ListSequence.fromList(singleLineWeights).getElement(i);
      if (sum % 6 == 0) {
        ListSequence.fromList(closingRow).setElement(i, true);
      } else if ((sum > 6 && ListSequence.fromList(closingRow).all((it) -> it == false)) && i > 0) {
        ListSequence.fromList(closingRow).setElement(i - 1, true);
      }
    }
  }

  public boolean needsCloseRow(int colIndex) {
    return ListSequence.fromList(closingRow).getElement(colIndex);
  }

  public boolean needsOpenRow(int colIndex) {
    return false;
  }

  public int getSizeS(int colIndex) {
    return getSizeM(colIndex) * 2;
  }
  public int getSizeM(int colIndex) {
    return ListSequence.fromList(singleLineWeights).getElement(colIndex);
  }

  public int numOfEmptyCellToAdd() {
    return 0;
  }


  public static void main(String[] args) {
    TableForm.Column single8 = new TableForm.Column("prop", "lab", null, 8, false);
    TwoTop12Divider d1 = new TwoTop12Divider();
    d1.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8, single8, single8, single8, single8, single8, single8, single8, single8));

    TwoTop12Divider d3 = new TwoTop12Divider();
    d3.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8));

    TwoTop12Divider d4 = new TwoTop12Divider();
    d4.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8));

    TwoTop12Divider d5 = new TwoTop12Divider();
    d5.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8, single8));

    TwoTop12Divider d6 = new TwoTop12Divider();
    d6.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8, single8, single8));


    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d1));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d3));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d4));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d5));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d6));
  }

}
