package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UploadEditor;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;

public class UploadEditor extends AbstractEditor implements IToolkit_UploadEditor {
  protected String contentString;
  protected String uploadLocationStore;
  protected String uploadLocationRetrieve;

  public UploadEditor(PebbleTemplate template, String aUploadLocationStore, String aUploadLocationRetrieve) {
    super("upldEditor", template);

    DateTime dt = new DateTime();
    editorId += "_" + dt.year().get() + dt.monthOfYear().get() + dt.dayOfMonth().get() + dt.hourOfDay().get() + dt.minuteOfHour().get();

    uploadLocationRetrieve = aUploadLocationRetrieve;
    uploadLocationStore = aUploadLocationStore;
  }

  @Override
  public void setDelegate(IDataUxDelegate dlgt) {
  }
  @Override
  public void setText(String text) {
    contentString = text;
  }
  @Override
  public String getText() {
    return contentString;
  }

  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();

    MapSequence.fromMap(renderMap).put(TEXT, contentString);
    MapSequence.fromMap(renderMap).put(UPLOADLOCATIONSTORE, uploadLocationStore);
    MapSequence.fromMap(renderMap).put(UPLOADLOCATIONRETRIEVE, uploadLocationRetrieve);

    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
  }
  public void handleRequest(HttpServletRequest req) {
    if (!(enabled)) {
      return;
    }

    String val = req.getParameter(editorId);

    if (val == null) {
      throw new H2FormRequestStateException("Client did not provide editor information in form for AUploadEditor: EditorId " + editorId);

    } else {
      contentString = val;

    }
  }

}
