package org.modellwerkstatt.h2forms.tools;

/*Generated by MPS */

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.LogFactory;
import java.io.StringWriter;

public class OJDBC6_LoaderServlet extends HttpServlet {

  private static boolean initSuccessFullyCalled = false;


  @Override
  protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    PrintWriter out = response.getWriter();
    out.println("<html>OJDBC6_LoaderServlet - init() done is " + initSuccessFullyCalled + "</html>");
  }
  @Override
  public void init() throws ServletException {
    super.init();

    // Dan 7. Oct 2014
    // Start the oracle OracleTimeoutPollingThread by loading OracleTimeoutThreadPerVM
    // where that Thread get s initialized as watchdog. Class is loaded with system Classloader,
    // howerver, threads seems to be in servlet context. So do not unload this servlet.

    ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
    try {
      Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());

      // Cause oracle.jdbc.driver.OracleTimeoutPollingThread to be started with contextClassLoader = system classloader
      // Ignore silently - class not present
      try {
        Class.forName("oracle.jdbc.driver.OracleTimeoutThreadPerVM");
      } catch (ClassNotFoundException e) {
        LogFactory.getLog(OJDBC6_LoaderServlet.class).error("ClassNotFoundException while trying to load ojdbc driver. " + stackTrace2String(e));
      }
      initSuccessFullyCalled = true;

    } catch (Exception ex) {
      LogFactory.getLog(OJDBC6_LoaderServlet.class).error("Exception while trying to load ojdbc driver. " + stackTrace2String(ex));

    } finally {
      Thread.currentThread().setContextClassLoader(currentClassLoader);
    }


  }


  public static String stackTrace2String(Throwable t) {
    StringWriter sw = new StringWriter();
    t.printStackTrace(new PrintWriter(sw));
    return "\n" + sw.toString();
  }

}
