package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public abstract class AppMainWindowController extends ApplicationBasis {

  protected WindowController mainWindowController;

  protected IOFXSession mainMenuEvalSession;
  protected IToolkit_MainWindow appMainWindow;

  protected List<CmdAction> mainMenuAndTileActions;

  private IOFXSession tilesSession;
  private List<TileAction> tileActions;
  private String currentDynamicStatusInfo = "0";
  private int currentBranding = -1;
  private boolean confirmClosedInstalled = false;

  public AppMainWindowController(IToolkit_UiFactory uf, IGenAppUiModule behave, AppJmxRegistration helper, IOFXCoreReporter.MoWarePlatform aPlatFrm) {
    super(uf, behave, helper, aPlatFrm);

    tilesSession = null;
    tileActions = null;
  }

  public void userLoggedIn(String sysName, IOFXUserEnvironment userEnv, IOFXUserServices services, String connInfo, String connectInfoAddOn, String appFqName, String appShortName, String swVersion) {

    super.userLoggedIn(sysName, userEnv, connInfo, connectInfoAddOn, appFqName, appShortName, swVersion);

    mainMenuEvalSession = uiFactory.createNewSession(userEnv, services);

    // we need a user specific print instance here / user service instance.
    // 
    appPrintService = uiFactory.createConfiguredUserPrintService(appMainWindow, userEnv);
  }

  protected boolean initializeApplication(OFXUrlParams url, final ISelectionController fakeCrtl, String systemName, final IOFXUserEnvironment userEnv, String userConnectionInfo, String startupInfo) {

    boolean startupCmdUsed = false;
    try {
      // Okay, changing to statefull mode
      userEnvironment = userEnv;
      // set some status information
      userEnvironment.setAppStartupLocalMillis(System.currentTimeMillis());

      this.userLoggedIn(systemName, userEnv, this, userConnectionInfo, startupInfo, applicationBehaviour.getClass().getName(), applicationBehaviour.getShortAppName(), applicationBehaviour.getApplicationVersion());

      // initialize main menu
      Menu startFolder = applicationBehaviour.createStartMenu(userEnvironment);
      Menu extraFolder = applicationBehaviour.createExtrasMenu(userEnvironment);
      Menu helpFolder = applicationBehaviour.createHelpMenu(userEnvironment);

      mainMenuAndTileActions = startFolder.getAllCmdActionsOfMenu();
      ListSequence.fromList(mainMenuAndTileActions).addSequence(ListSequence.fromList(extraFolder.getAllCmdActionsOfMenu()));
      ListSequence.fromList(mainMenuAndTileActions).addSequence(ListSequence.fromList(helpFolder.getAllCmdActionsOfMenu()));

      tilesSession = uiFactory.createNewSession(userEnvironment, this);
      tileActions = applicationBehaviour.createAppTileActions(uiFactory, userEnvironment);
      ListSequence.fromList(tileActions).visitAll((it) -> {
        it.setupTileAction();
        ListSequence.fromList(mainMenuAndTileActions).addElement(it.getAction());
      });

      final Wrappers._T<List<String>> mainWinHotkeys = new Wrappers._T<List<String>>(ListSequence.fromList(new ArrayList<String>()));
      ListSequence.fromList(mainMenuAndTileActions).visitAll((action) -> {
        action.configure(uiFactory, mainWindowController, fakeCrtl, userEnvironment.getLangIndex());
        if (action.hotKey != null && !("".equals(action.hotKey))) {
          ListSequence.fromList(mainWinHotkeys.value).addElement(action.hotKey);
        }
        // actions translated in map_ActionUiModule, since used in multiple platforms
      });

      List<Menu> allSubs = startFolder.getAllPlainMenus();
      ListSequence.fromList(allSubs).addSequence(ListSequence.fromList(extraFolder.getAllPlainMenus()));
      ListSequence.fromList(allSubs).addSequence(ListSequence.fromList(helpFolder.getAllPlainMenus()));
      ListSequence.fromList(allSubs).visitAll((it) -> {
        if (it.labelText != null) {
          it.configureLabel(uiFactory.getTransProvider().translateSingle(userEnv.getLangIndex(), it.labelText));
        }
      });

      appMainWindow.setMenuAndInit(userEnvironment.getLangIndex(), startFolder, extraFolder, helpFolder);
      // MTS Jan 25 - connection no longer shown.
      appMainWindow.addStatusInformation("user " + userEnv.getUserName() + " / " + userEnv.getUserId());

      updateDynamicStatusInfo();

      // ensure menu hotkeys are available
      mainWinHotkeys.value = ListSequence.fromList(mainWinHotkeys.value).distinct().toList();
      appMainWindow.ensureHotkeyAvailable(mainWinHotkeys.value);

      // used to init batchjob environmentents
      applicationBehaviour.userLoggedIn(userEnv, this);

      this.logAppTrace("", "", IOFXCoreReporter.LOGIN, "application startup", getuser_connectionInfoAddOn(), null);

      // always setup tiles initially here, then eval start cmd
      recalcAndShowTiles();
      reevalEnabledInMenusAndTiles();

      BasisCmdStart cmdStart = applicationBehaviour.createStartupCmd(mainMenuEvalSession);
      if (cmdStart != null) {
        IOFXCmdModule.CmdUrlDefaults def = null;
        if (url != null && url.hasCmdName()) {
          def = getUrlDefaultFor(uiFactory.getAllCmdUrlDefaults(), url);
        }

        if (def != null && cmdStart.getCommandName().equals(def.cmdFqName)) {
          // same command
          // do not use startup cmd.

        } else {
          startupCmdUsed = true;

          if (!(cmdStart.hasParamsSet())) {
            // precondition - cmd enabled 
            IOFXCmdModule mod = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(cmdStart.getCommandName()));
            cmdStart = cmdStart.cloneWithParams(mod.getCommandDefaultParams(cmdStart.getCommandName(), null, false));
          }

          mainWindowController.receiveAndProcess(cmdStart);
          setCurrentAsAppStartupContainer();
        }

      }


    } catch (Exception ex) {
      mainWindowController.showException(ApplicationMDI.class.getName(), "", uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.FATA_APPFRMWRK_PROBLEM), "in initializeApplication()", ex, new IApplication.DlgRunnable() {

        public void run(boolean confirmed) {
          internal_immediatelyShutdown();
          appMainWindow.closeApplicationAndExit();
        }
      });
    }

    updateDynamicStatusInfo();
    return startupCmdUsed;
  }

  public String getUserName() {
    if (userEnvironment == null) {
      return "(app already shut down)";
    }
    return userEnvironment.getUserName();
  }

  public String getDynamicStatusInfoOrSD() {
    if (userEnvironment == null) {
      return "(shut down)";
    }
    return userEnvironment.getDynamicStatusInfo();
  }

  public void adjustDeviceID(String newId) {
    if (newId != null && !(newId.trim().equals(""))) {
      userEnvironment.adjustDeviceId(newId);
      deviceId = userEnvironment.getDeviceId();
    }
  }

  private void updateDynamicStatusInfo() {
    // TODO: Should be moved to user Services. 
    if (userEnvironment == null) {
      // shutdown ..

    } else {
      String newOne = getDynamicStatusInfoOrSD();
      int newBranding = userEnvironment.getBrandingId();

      if (newOne == null) {
        newOne = "";
      }
      if (!(newOne.equals(currentDynamicStatusInfo)) || newBranding != currentBranding) {
        currentDynamicStatusInfo = newOne.trim();
        currentBranding = newBranding;

        appMainWindow.setAppInfo(applicationBehaviour.getShortAppName(), applicationBehaviour.getApplicationVersion(), currentDynamicStatusInfo, currentBranding);
      }
    }
  }

  public void recalcAndShowTiles() {
    // do not expose session to toolkit
    applicationBehaviour.recalcTilesLabel(userEnvironment, tilesSession, tileActions);
    // always, even when size = 0
    appMainWindow.showTiles(tileActions);
  }

  public void reevalEnabledInMenusAndTiles() {
    touch();
    ListSequence.fromList(mainMenuAndTileActions).visitAll((it) -> it.reevalEnabled());

    if (!(shutdownMode)) {
      updateDynamicStatusInfo();
    }
  }

  public void checkToInstallConfirmCloseAlert() {
    boolean needInstall = !(noGraphsToCommit());

    if (needInstall && !(confirmClosedInstalled)) {
      appMainWindow.installCloseConfirmQuestion(true);
      confirmClosedInstalled = true;

    } else if (confirmClosedInstalled && !(needInstall)) {
      appMainWindow.installCloseConfirmQuestion(false);
      confirmClosedInstalled = false;
    }
  }

  public abstract boolean noGraphsToCommit();
  @Override
  public boolean checkForAppParDeploymentForward() {
    boolean forwardPlease = false;

    if (getAppTelemetrics().isParDeploymentForwardImmediate() || (getAppTelemetrics().isParDeploymentForwardGracefully() && noGraphsToCommit())) {
      forwardPlease = true;

      if (!(userAlreadyNotifiedParDeplyForward)) {
        userAlreadyNotifiedParDeplyForward = true;
        mainWindowController.showSimpleInfoDialog(uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.APPLICATION_LOCKED), new IApplication.DlgRunnable() {
          @Override
          public void run(boolean confirmed) {
            internal_immediatelyShutdown();
            appMainWindow.parDeploymentForwardNow();
          }
        });
      }
    }
    return forwardPlease;
  }

  public abstract void internal_closeAllRunningCmds();
  public void internal_immediatelyShutdown() {
    // double check running tabs? free locks etc?
    // (1) typically exitRequested() is called on user exits
    // (2) iteration over open command containers closes CommandContainers and in turn
    //     calls closeTabs() which reduces the elements in runningTabCommandContainers.

    // disable delivery of events.
    shutdownMode = true;

    internal_closeAllRunningCmds();

    if (tilesSession != null) {
      tilesSession.closeSessionAndfreeGC();
    }

    if (mainMenuEvalSession != null) {
      mainMenuEvalSession.closeSessionAndfreeGC();
    }

    // gcClean by mainMenuAndTileActions
    ListSequence.fromList(tileActions).clear();
    tileActions = null;

    ListSequence.fromList(mainMenuAndTileActions).visitAll((it) -> it.gcClear());
    ListSequence.fromList(mainMenuAndTileActions).clear();
    mainMenuAndTileActions = null;

    super.closeReporting();

    if (userEnvironment != null) {
      // might be that the user was not logged on.
      userEnvironment.gcClean();
      userEnvironment = null;
    }
  }

  public boolean inShutdownMode() {
    return shutdownMode;
  }


  public void receiveAndProcess(UxEvent ev) {
    mainWindowController.receiveAndProcess(ev);
  }
  public void showException(String cmdOrComponent, String sessId, String reason, String contextInformation, Throwable throwable, IApplication.DlgRunnable run) {
    mainWindowController.showException(cmdOrComponent, sessId, reason, contextInformation, throwable, run);
  }
  public void showSimpleInfoDialog(String info, IApplication.DlgRunnable run) {
    mainWindowController.showSimpleInfoDialog(info, run);
  }
  public void showBigInformationDialog(String info, IApplication.DlgRunnable run) {
    mainWindowController.showBigInformationDialog(info, run);
  }
  @Override
  public IOFXSession getMainWindowEvalSession() {
    return mainMenuEvalSession;
  }
  @Override
  public IToolkit_MainWindow getMainWindowImpl() {
    return appMainWindow;
  }
}
