package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.ArrayList;
import java.io.File;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;

/**
 * (1) Refactor from ApplicationController to AppCrtlBasis when introducing new SDI Controller
 * (2) Clean up IApplicationController und ICommandStarter interfaces. 
 * 
 * 
 * 
 * 
 */
public abstract class ApplicationBasis extends ApplicationReporter implements IApplication, IOFXUserServices {

  protected IGenAppUiModule applicationBehaviour;

  protected boolean applicationModalTabMode;
  protected List<ICommandContainer> allRunningContainersToTerminate;
  protected ICommandContainer startupCommandContainer;
  protected IPrintingServiceImpl appPrintService;

  protected boolean shutdownMode;
  protected boolean userAlreadyNotifiedParDeplyForward;
  protected Runnable afterStartupCmd;



  public ApplicationBasis(IToolkit_UiFactory uf, IGenAppUiModule behave, AppJmxRegistration helper, IOFXCoreReporter.MoWarePlatform aPlatFrm) {
    super(uf, helper, aPlatFrm);

    applicationBehaviour = behave;
    applicationModalTabMode = false;
    allRunningContainersToTerminate = new ArrayList<ICommandContainer>();

    shutdownMode = false;
    userAlreadyNotifiedParDeplyForward = false;
    startupCommandContainer = null;
    afterStartupCmd = null;
  }

  @Override
  public boolean isApplicationModalTabMode() {
    return applicationModalTabMode;
  }

  @Override
  public void addToContainerRecorder(ICommandContainer container) {
    allRunningContainersToTerminate.add(container);
  }
  public void setCurrentAsAppStartupContainer() {
    if (allRunningContainersToTerminate.size() > 0) {
      startupCommandContainer = allRunningContainersToTerminate.get(0);
    }
  }
  @Override
  public void removeFromContainerRecorder(ICommandContainer container) {
    if (startupCommandContainer == container) {
      startupCommandContainer = null;
      if (afterStartupCmd != null) {
        try {
          afterStartupCmd.run();

        } catch (Exception ex) {
          logFrmwrkProblem("", "", IOFXCoreReporter.APP, ex, "Exception while running afterStartupCmd!");

        } finally {
          afterStartupCmd = null;
        }
      }
    }

    if (!(allRunningContainersToTerminate.contains(container))) {
      logFrmwrkProblem("", "", IOFXCoreReporter.APP, "The terminated container " + container + " was not found in the allRunningContainersToTerminate - this can not happen.", fullApplicationCrtlState());

    } else {
      allRunningContainersToTerminate.remove(container);
    }

  }
  public void execAfterStartupOrNow(Runnable rnbl) {
    if (isStartupCmdRunning()) {
      afterStartupCmd = rnbl;
    } else {
      rnbl.run();
    }
  }
  public boolean isStartupCmdRunning() {
    return isCommandRunning() && allRunningContainersToTerminate.get(0) == startupCommandContainer;
  }

  public boolean isCommandRunning() {
    return allRunningContainersToTerminate.size() > 0;
  }

  @Override
  public boolean distributeTermEventOnRecorder(GlobalCmdTermEvent event) {
    boolean parentFound = false;
    ICommandContainer parent = event.getParentOfClosed();

    for (ICommandContainer cntr : List.copyOf(allRunningContainersToTerminate)) {
      cntr.receiveAndProcess(event);
      if (cntr == parent) {
        parentFound = true;
      }
    }
    return parentFound;
  }

  @Override
  public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    // ---> Forward, but be in control <---
    return appPrintService.renderPrint(documentFilename, xsltTemplateName, xmlGraphData, barcode);
  }
  @Override
  public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    return appPrintService.renderView(documentFilename, xsltTemplateName, xmlGraphData, barcode);
  }
  @Override
  public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    return appPrintService.render(documentFilename, xsltTemplateName, xmlGraphData, barcode);
  }
  @Override
  public void view(File pdfFile) {
    appPrintService.view(pdfFile);
  }
  @Override
  public void print(File pdfFile) {
    appPrintService.print(pdfFile);
  }

  @Override
  public void openUrl(String url) {
    appPrintService.openUrl(url);
  }
  @Override
  public void logOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String msg, HashMap<String, Object> paramMap) {
    // fore IOFXUserServices
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, source, cmdFqName, sessId, prio, msg);
    if (paramMap != null) {
      for (String key : paramMap.keySet()) {
        info.addParameter(key, paramMap.get(key));
      }
    }

    uiFactory.report(info);
  }

  @Override
  public IOFXUserEnvironment getUserEnvironment() {
    return userEnvironment;
  }

  @Override
  public IOFXUserServices getUserService() {
    return this;
  }



  public IOFXCmdModule.CmdUrlDefaults getUrlDefaultFor(List<IOFXCmdModule.CmdUrlDefaults> urlDefaults, final OFXUrlParams urlParam) {
    IOFXCmdModule.CmdUrlDefaults infoForCmd;

    if (!(urlParam.hasCmdName())) {
      throw new RuntimeException("This can not happen.");

    } else {
      infoForCmd = ListSequence.fromList(urlDefaults).findFirst((it) -> it.url.equals(urlParam.getCmdName()) && urlParam.numParams() >= it.minNumParams && urlParam.numParams() <= it.maxNumParams);

      if (infoForCmd != null) {
        IOFXCmdModule module = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(infoForCmd.cmdFqName));
        try {
          Object[] params = module.getCommandUrlDefaultParams(infoForCmd.cmdFqName, urlParam);
          // can not convert string to int, typically - check done

        } catch (NumberFormatException ex) {
          infoForCmd = null;

        } catch (IllegalArgumentException ex) {
          // status convert
          infoForCmd = null;
        }


      }
      return infoForCmd;
    }
  }
  public BasisCmdStart cmdStartForUrlDefault(IOFXCmdModule.CmdUrlDefaults def, OFXUrlParams urlParams, IOFXSession session) {
    // calculateParams() method signature could be changed, since working with localSelectionCrtls now
    IOFXCmdModule module = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(def.cmdFqName));

    Object[] params = module.getCommandUrlDefaultParams(def.cmdFqName, urlParams);

    if (params == null) {
      throw new RuntimeException("This can not be true. Tried to start a command with params null.");
    }

    boolean enabled = module.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, def.cmdFqName, params, session) != IOFXCmdModule.CommandPermission.DISABLED;

    if (!(enabled)) {
      return null;

    } else {
      BasisCmdStart ev = new BasisCmdStart(def.cmdFqName, params);
      ev.setLabelText(def.desc);
      return ev;
    }
  }
}
