package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import javax.management.NotificationBroadcasterSupport;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import java.util.HashMap;
import java.util.Map;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.dataux.runtime.telemetrics.ApplicationTelemetrics;

public abstract class ApplicationReporter extends NotificationBroadcasterSupport implements ApplicationReporterMBean {
  protected IToolkit_UiFactory uiFactory;

  protected IOFXUserEnvironment userEnvironment;
  protected String userInfo;
  protected String userName;
  protected int userId;
  protected int userLangIndex;

  protected String connectionInfo;
  protected String connectionInfoAddOn;

  protected String deviceName;
  protected String deviceId;
  protected String deviceSwName;
  protected String systemName;
  protected IOFXCoreReporter.MoWarePlatform platform;

  protected String shortAppName;
  protected String appFqName;
  protected String swAppVersion;


  protected String progressor;
  protected AppJmxRegistration jmxRegHelper;
  protected long sequence;
  protected long lastInteraction;
  protected long appStartupLocalMillis;
  protected long lastRequestDiffMillis;
  protected long lastRequestDiffMillis2;
  protected long lastRequestDiffMillis3;
  protected String lastRequestLog;

  protected boolean debug;
  protected boolean ebLockingEnabled;
  protected String currentSequence = "no seq.";
  protected String jmxUniqueNameSuffix = "";


  public ApplicationReporter(IToolkit_UiFactory uf, AppJmxRegistration helper, IOFXCoreReporter.MoWarePlatform aPlatFrm) {
    uiFactory = uf;
    jmxRegHelper = helper;
    userInfo = "no-userinfo";
    progressor = "no-info";
    sequence = 0;
    debug = false;
    ebLockingEnabled = true;
    userLangIndex = -1;
    systemName = "no-info";
    lastInteraction = System.currentTimeMillis();
    appStartupLocalMillis = lastInteraction;
    platform = aPlatFrm;
    lastRequestDiffMillis = 0;
    lastRequestDiffMillis2 = 0;
    lastRequestDiffMillis3 = 0;
    lastRequestLog = "";
  }


  protected void userLoggedIn(String sysName, IOFXUserEnvironment userEnv, String connInfo, String connectInfoAddOn, String aAppFqName, String aShortAppName, String swVersion) {

    userEnvironment = userEnv;
    appStartupLocalMillis = userEnv.getAppStartupLocalMillis();
    userName = userEnv.getUserName();
    userId = userEnv.getUserId();
    // not beeing dependent on user env info.
    userInfo = userEnv.getUserName() + " (" + userEnv.getUserId() + ")";
    userLangIndex = userEnv.getLangIndex();

    deviceName = userEnv.getDeviceName();
    deviceSwName = userEnv.getDeviceSwName();
    deviceId = userEnv.getDeviceId();

    appFqName = aAppFqName;
    shortAppName = aShortAppName;
    swAppVersion = swVersion;

    connectionInfo = connInfo;
    connectionInfoAddOn = connectInfoAddOn;

    systemName = sysName;
    jmxRegHelper.registerClient(this);
  }

  public String appUserSystemVersionInfo() {
    return shortAppName + " " + swAppVersion + "  [" + userName + " @ " + systemName + "]";
  }
  public String getEscSwAppVersion() {
    return swAppVersion.toLowerCase().replaceAll("\\W", "_");
  }
  public void touch() {
    lastInteraction = System.currentTimeMillis();
  }
  public String getuser_deviceId() {
    return deviceId;
  }
  public String getuser_deviceSw() {
    return deviceSwName;
  }

  public String getuser_jmxInstanceName() {
    // no ipv6 like 0:0:0:0:0:0 stuff
    String full = userInfo.replace(":", "_");
    if (!("".equals(deviceName))) {
      full += " " + deviceName;
    }
    if (!("".equals(jmxUniqueNameSuffix))) {
      full += jmxUniqueNameSuffix;
    }
    return full;
  }
  public void setJmxUniqueNameSuffix(String s) {
    jmxUniqueNameSuffix = s;
  }

  @Override
  public String getuser_device() {
    return deviceName + " / " + deviceSwName;
  }
  public String getuser_connectionInfo() {
    return connectionInfo;
  }
  public String getuser_connectionInfoAddOn() {
    return connectionInfoAddOn;
  }
  public String setuser_connectionInfoAddOn(String val) {
    return connectionInfoAddOn = val;
  }

  public String getuser_progressor() {
    return progressor;
  }
  public void setuser_progressor(String prog) {
    progressor = prog;
  }
  public void setuser_formseqId(String id) {
    currentSequence = id;
  }
  public String getuser_sequenceinfo() {
    return currentSequence;
  }
  public void setuser_lastRequestDiffMillis(long val, long val2, long val3, String log) {
    lastRequestDiffMillis = val;
    lastRequestDiffMillis2 = val2;
    lastRequestDiffMillis3 = val3;
    lastRequestLog = log;

  }
  public String getuser_lastInteraction() {
    return new DateTime(lastInteraction).toString();
  }
  public String getuser_appStartup() {
    return new DateTime(appStartupLocalMillis).toString();
  }

  protected CoreReporterInfo createInfoObject(IOFXCoreReporter.Type typ, String source, String cmdName, String sessId, IOFXCoreReporter.LogPriority prio, String desc) {
    CoreReporterInfo info = new CoreReporterInfo(typ, appFqName, swAppVersion, source, cmdName, sessId, prio, userId, userName, deviceName + " " + deviceSwName, deviceId, connectionInfo, MoVersion.MOWARE_PLUGIN_VERSION, platform, systemName, desc);
    return info;
  }

  public void logMowareTracing(String commandName, String sessId, String source, String desc, String param1) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE, source, commandName, sessId, IOFXCoreReporter.LogPriority.TRACE, desc);
    info.addParameter(CoreReporterInfo.PARAM, param1);

    uiFactory.report(info);
  }
  public void logMowareTracing(String commandName, String sessId, String source, String desc, HashMap<String, Object> paramsNotNull) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE, source, commandName, sessId, IOFXCoreReporter.LogPriority.TRACE, desc);
    CoreReporterInfo.takeOverParamsIfNotNull(info.getParameters(), paramsNotNull);

    uiFactory.report(info);
  }
  public void logFrmwrkProblem(String commandName, String sessId, String source, String desc, String param1) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
    info.addParameter(CoreReporterInfo.PARAM, param1);

    uiFactory.report(info);
  }
  public void logFrmwrkProblem(String commandName, String sessId, String source, Throwable t, String desc) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
    info.setException(t);

    uiFactory.report(info);
  }

  public void logAppWarning(String commandName, String sessId, String source, String warningMsg, String param1) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.INFO, warningMsg);
    info.addParameter(CoreReporterInfo.PARAM, param1);

    uiFactory.report(info);
  }
  public void logAppProblem(String commandName, String sessId, String source, Throwable t, String desc) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
    info.setException(t);

    uiFactory.report(info);
  }
  public void logAppProblem(String commandName, String sessId, String source, Throwable t, String desc, String param1) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
    info.addParameter(CoreReporterInfo.PARAM, param1);
    info.setException(t);

    uiFactory.report(info);
  }
  public void logAppTrace(String commandName, String sessId, String source, String desc, String param, Map<String, Object> additionalParamsOrNull) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_TRACE, source, commandName, sessId, IOFXCoreReporter.LogPriority.TRACE, desc);

    info.addParameter(CoreReporterInfo.PARAM, param);
    CoreReporterInfo.takeOverParamsIfNotNull(info.getParameters(), additionalParamsOrNull);

    // independent of event, report EB diff time once... per request
    if (lastRequestDiffMillis > 0) {
      info.addParameter(CoreReporterInfo.REQ_DIFF, lastRequestDiffMillis);
      lastRequestDiffMillis = 0;
    }
    if (lastRequestDiffMillis2 > 0) {
      info.addParameter(CoreReporterInfo.REQ_DIFF2, lastRequestDiffMillis2);
      info.addParameter(CoreReporterInfo.REQ_LOG, lastRequestLog);
      lastRequestDiffMillis2 = 0;
    }
    if (lastRequestDiffMillis3 > 0) {
      info.addParameter(CoreReporterInfo.REQ_DIFF3, lastRequestDiffMillis3);
      lastRequestDiffMillis3 = 0;
    }


    uiFactory.report(info);
  }


  public String reportException(String cmdOrSysName, String sessId, String message, String contextInformation, Throwable throwable) {
    String messageToUser;
    String exMessage = throwable.getMessage();

    cmdOrSysName = MoVersion.getShortNameFromFQ(cmdOrSysName);

    if (throwable instanceof NullPointerException) {
      messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n";
      exMessage = "Null Pointer Exception";
      logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.USER_EX, throwable, "NPE", message + "\n" + contextInformation);

    } else if (throwable instanceof IncorrectResultSetColumnCountException) {

      if (exMessage.contains("GET()")) {
        messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n" + uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.GET_USER_PROBLEM) + "\n\n[" + exMessage + "]";
        exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.GET_PROBLEM);

        logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.USER_EX, throwable, "IncorrectResultSetColumnCount", message + "\n" + contextInformation);

      } else if (exMessage.contains("UPDATE()")) {
        messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n" + uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TCN_PROBLEM) + "\n\n[" + exMessage + "]";
        exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TCN_PROBLEM);

        logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.TCN, throwable, "IncorrectResultSetColumnCount", message + "\n" + contextInformation);

      } else {
        messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n" + uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.INSERT_DELETE_RELOAD_PROBLEM) + "\n\n[" + exMessage + "]";
        exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.INSERT_DELETE_RELOAD_PROBLEM);

        logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.USER_EX, throwable, "IncorrectResultSetColumnCount", message + "\n" + contextInformation);
      }

    } else if (throwable instanceof UncategorizedSQLException) {
      if (exMessage.toLowerCase().contains("[17002]")) {
        messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.LOST_CONN_USER_ERROR);
        exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_ERROR);

      } else {
        messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n";
        exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_ERROR);
      }
      logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.USER_EX, throwable, "UncategorizedSQL", message + "\n" + contextInformation);


    } else if (throwable instanceof OFXShutDownSessionException) {
      IOFXProblem prblm = ((OFXShutDownSessionException) throwable).getProblem();

      messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR);
      exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.GUARD_MSG) + " " + prblm.getSimpleUserText();

      logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.USER_EX, throwable, "Guard", prblm.getSimpleUserText());

    } else {
      messageToUser = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n";
      exMessage = uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.TEC_ERROR);

      logAppProblem(cmdOrSysName, sessId, IOFXCoreReporter.USER_EX, throwable, throwable.getClass().getSimpleName(), message + "\n" + contextInformation);

    }


    exMessage = "\n\n Exception occured in " + cmdOrSysName + ": " + exMessage + "\n\n\n";

    exMessage += OFXConsoleHelper.stackTrace2String(throwable);

    exMessage += "\n\nCONTEXT:   " + message;
    if (contextInformation != null && !("".equals(contextInformation.trim()))) {
      exMessage += "\n" + contextInformation;
    }

    jmxRegHelper.getAppTelemetrics().incException();

    if (uiFactory.isSilentExLogging()) {
      // appWindow with ERROR_SMALL
      return messageToUser;

    } else {
      // appWindow with ERROR_LARGE
      return exMessage;
    }
  }

  public ApplicationTelemetrics getAppTelemetrics() {
    return jmxRegHelper.getAppTelemetrics();
  }

  public void closeReporting() {
    if (jmxRegHelper != null) {
      try {
        // On servers, loader with eb might already be down...
        logAppTrace("", "", IOFXCoreReporter.LOGIN, "application shutdown", "", null);

        jmxRegHelper.unregisterClient(this);

      } catch (Throwable t) {
      }
    }
    jmxRegHelper = null;
  }

  public abstract String fullApplicationCrtlState();

  public String toggleDebugEnabled() {
    debug = !(debug);
    return "Debug now set to '" + debug + "'.";
  }
  public String toggleEventBusLockingEnabled() {
    ebLockingEnabled = !(ebLockingEnabled);
    logAppTrace("", "", IOFXCoreReporter.LOCKING, "eb locking via jmx set to " + ebLockingEnabled, "", null);

    return "EventBusLocking now set to '" + ebLockingEnabled + "'.";
  }
  public boolean isDebug() {
    return debug;
  }

  public boolean isEbLockingForThisInstance() {
    return uiFactory.getEventBusLocking() && ebLockingEnabled;
  }
  public void setDebug(boolean dbg) {
    debug = dbg;
  }
}
