package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.modellwerkstatt.objectflow.runtime.IOFXPrintFactory;
import javax.sql.DataSource;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IMoEventBusService;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.Arrays;
import org.modellwerkstatt.dataux.runtime.sdicore.CheckerForCmdUrlDefaults;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import java.io.File;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenPagePane;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXSimpleManMapSession;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import java.util.Set;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public abstract class BaseUiFactory implements IOFXCoreReporter {

  protected MoWareTranslations defaulTrans;
  protected String connectionInfo;
  protected boolean skipTCNExceptions;
  protected boolean isSilentLogging;
  protected boolean mowareTrace;
  protected boolean appTrace;
  protected boolean eventBusLocking;
  protected boolean scrollAdjustEnabled;
  protected boolean portJEnabled;
  protected boolean portJLocal;
  protected boolean logAllEventsToStdErrAdditionally;

  protected boolean experimentalFeatures;
  protected boolean reloadOnTabChange;
  protected boolean collectSelections;
  protected boolean alwaysRollbackSession;
  protected boolean checkAlsoPredecessorDuplication;
  protected boolean optimKeyboard;
  protected boolean autoParDeploymentForwardGracefully;
  private boolean deployedVersionCheck;

  protected String uploadLocationRetrieve;
  protected String uploadLocationStore;
  protected String uploadFsLocationStore;
  protected int uploadMaxSize;

  protected String COMMAND_CONTAINER_FQ_NAME = "org.modellwerkstatt.dataux.runtime.core.EventCommandContainer";
  protected Class commandContainerClass;

  protected List<IOFXCmdModule.CmdUrlDefaults> allUrlDefaults;
  protected List<IExtAuthProvider> extAuthProviders;

  @Autowired
  protected ApplicationContext context;
  @Autowired
  protected IOFXPrintFactory printFactory;
  @Autowired
  protected DataSource dataSource;
  @Autowired
  protected IOFXPlatform platform;
  @Autowired
  private IMoEventBusService eventBusService;
  @Autowired
  private IOFXTranslationProvider transProvider;


  public BaseUiFactory(MoWareTranslations.TranslationSelection transType) {
    defaulTrans = new MoWareTranslations(transType);
    allUrlDefaults = new ArrayList<IOFXCmdModule.CmdUrlDefaults>();

    connectionInfo = null;
    skipTCNExceptions = false;
    isSilentLogging = false;
    eventBusLocking = false;
    mowareTrace = false;
    scrollAdjustEnabled = false;
    portJEnabled = false;
    portJLocal = false;
    experimentalFeatures = false;
    reloadOnTabChange = false;
    collectSelections = false;
    alwaysRollbackSession = false;
    checkAlsoPredecessorDuplication = false;
    optimKeyboard = false;

    deployedVersionCheck = true;
    autoParDeploymentForwardGracefully = false;

    commandContainerClass = null;
    logAllEventsToStdErrAdditionally = false;
    uploadMaxSize = 2000000;
  }


  public void initCmdUrlDefaults() {

    Map<String, IOFXCmdModule> allModuels = context.getBeansOfType(IOFXCmdModule.class);
    for (String key : allModuels.keySet()) {
      allUrlDefaults.addAll(Arrays.asList(allModuels.get(key).getCmdUrlDefaults()));
    }

    CheckerForCmdUrlDefaults checker = new CheckerForCmdUrlDefaults();
    List<String> doubles = checker.check(allUrlDefaults);
    if (doubles.size() != 0) {
      throw new RuntimeException("The following urls (+ param counts) are defined more than once in the application: " + String.join(", ", doubles));

    }
  }

  public List<IOFXCmdModule.CmdUrlDefaults> getAllCmdUrlDefaults() {
    return allUrlDefaults;
  }

  public void initExtAuthProviders() {
    extAuthProviders = new ArrayList<IExtAuthProvider>();
    Map<String, IExtAuthProvider> allProviders = context.getBeansOfType(IExtAuthProvider.class);
    for (IExtAuthProvider provider : allProviders.values()) {
      extAuthProviders.add(provider);
    }
  }
  public List<IExtAuthProvider> getAllExtAuthProviders() {
    return extAuthProviders;
  }

  public boolean getSkipLoggingTcnException() {
    return skipTCNExceptions;
  }
  public void setSkipLoggingTcnException(boolean val) {
    skipTCNExceptions = val;
  }
  public boolean isSilentExLogging() {
    return isSilentLogging;
  }
  public void setSilentExLogging(boolean val) {
    isSilentLogging = val;
  }
  public void setPortJ(boolean val) {
    portJEnabled = val;
  }
  public boolean getPortJ() {
    return portJEnabled;
  }
  public void setPortJLocal(boolean val) {
    portJEnabled = val;
    portJLocal = val;
    if (val) {
      OFXLogger.enablePortJ();
    }
  }
  public boolean getPortJLocal() {
    return portJLocal;
  }

  public boolean isScrollAdjust() {
    return scrollAdjustEnabled;
  }
  public void setScrollAdjust(boolean val) {
    scrollAdjustEnabled = val;
  }
  public boolean getMowareTrace() {
    return mowareTrace;
  }
  public boolean getAppTrace() {
    return appTrace;
  }
  public void setAppTrace(boolean val) {
    appTrace = val;
  }
  public boolean getOptimKeyboard() {
    return optimKeyboard;
  }
  public void setOptimKeyboard(boolean val) {
    optimKeyboard = val;
  }
  public boolean getExperimentalFeatures() {
    return experimentalFeatures;
  }
  public void setExperimentalFeatures(boolean val) {
    experimentalFeatures = val;
  }
  public boolean getCollectSelections() {
    return collectSelections;
  }
  public void setCollectSelections(boolean val) {
    collectSelections = val;
  }
  public boolean getCheckAlsoPredecessorDuplication() {
    return checkAlsoPredecessorDuplication;
  }
  public void setCheckAlsoPredecessorDuplication(boolean val) {
    checkAlsoPredecessorDuplication = val;
  }
  public boolean getReloadOnTabChange() {
    return reloadOnTabChange;
  }
  public void setReloadOnTabChange(boolean val) {
    reloadOnTabChange = val;
  }
  public boolean getAlwaysRollbackSession() {
    return alwaysRollbackSession;
  }
  public void setAlwaysRollbackSession(boolean val) {
    alwaysRollbackSession = val;
  }
  public boolean getEventBusLocking() {
    return eventBusLocking;
  }
  public void setMowareTrace(boolean val) {
    mowareTrace = val;
    if (val) {
      appTrace = val;
    }
  }
  public void setEventBusLocking(boolean val) {
    eventBusLocking = val;
  }
  public void setLogEventsToStdErr(boolean val) {
    logAllEventsToStdErrAdditionally = val;
  }
  public boolean getLogEventsToStdErr() {
    return logAllEventsToStdErrAdditionally;
  }
  public String getUploadLocationRetrieve() {
    return uploadLocationRetrieve;
  }
  public String getUploadLocationStore() {
    return uploadLocationStore;
  }
  public String getUploadFsLocationStore() {
    return uploadFsLocationStore;
  }
  public void setUploadLocationRetrieve(String val) {
    uploadLocationRetrieve = (val.endsWith(File.separator) ? val : val + File.separator);
  }
  public void setUploadLocationStore(String val) {
    uploadLocationStore = (val.endsWith(File.separator) ? val : val + File.separator);
  }
  public void setUploadFsLocationStore(String val) {
    uploadFsLocationStore = (val.endsWith(File.separator) ? val : val + File.separator);
  }
  public void setUploadMaxSize(int val) {
    uploadMaxSize = val;
  }
  public int getUploadMaxSize() {
    return uploadMaxSize;
  }
  public void setAutoParDeploymentForwardGracefully(boolean val) {
    autoParDeploymentForwardGracefully = val;
  }
  public boolean isAutoParDeploymentForwardGracefully() {
    return autoParDeploymentForwardGracefully;
  }
  public boolean isCheckDeployedVersion() {
    return deployedVersionCheck;
  }
  public void setCheckDeployedVersion(boolean val) {
    deployedVersionCheck = val;
  }
  public void setDefaultEnglish(boolean val) {
    defaulTrans = new MoWareTranslations(MoWareTranslations.TranslationSelection.EN_DEFAULT_TRANS);
  }

  public String getSettingsDescription() {
    String settings = "";

    if (skipTCNExceptions) {
      settings += "SkipLoggingTcnExcpt ";
    }
    if (isSilentLogging) {
      settings += "SilentExcptLoggin ";
    }
    if (eventBusLocking) {
      settings += "EventBusLocking ";
    }
    if (scrollAdjustEnabled) {
      settings += "ScrollAdjust ";
    }
    if (alwaysRollbackSession) {
      settings += "AlwaysRollbackSession ";
    }
    if (portJEnabled) {
      settings += "PortJ ";
    }
    if (experimentalFeatures) {
      settings += "ExperimentalFeatures ";
    }
    if (reloadOnTabChange) {
      settings += "ReloadOnTabChange ";
    }
    if (collectSelections) {
      settings += "CollectSelections ";
    }
    if (deployedVersionCheck) {
      settings += "ChckDplVrs ";
    }
    if (autoParDeploymentForwardGracefully) {
      settings += "AutoParDeplyFrwdGracefly ";
    }
    if (logAllEventsToStdErrAdditionally) {
      settings += "LogAllEventsToStdErrAdditionally ";
    }
    if (appTrace) {
      settings += "AppTrace ";
    }
    if (mowareTrace) {
      settings += "MoWareTrace ";
    }
    return settings;
  }

  public String getStatusDescription() {
    String settings = "EventBus " + eventBusService.getCurrentStatus();
    return settings;
  }


  public Object getNewClassInstanceByFQName(String fqName) {
    try {
      ClassLoader cl = this.getClass().getClassLoader();
      Class bean = cl.loadClass(fqName);
      Object instance = this.context.getAutowireCapableBeanFactory().createBean(bean);
      return instance;

    } catch (ClassNotFoundException cnfe) {
      throw new RuntimeException("Class '" + fqName + "' not found!", cnfe);
    }
  }
  public IGenPagePane createGenPagePaneByFqName(String fqName) {
    return ((IGenPagePane) getNewClassInstanceByFQName(fqName));
  }
  public IOFXSession createNewSession(IOFXUserEnvironment userEnv, IOFXUserServices srv) {
    if (userEnv == null || srv == null) {
      throw new RuntimeException("This can not happen " + userEnv + " / " + srv + " - none should be null.");
    }
    OFXSimpleManMapSession session = context.getAutowireCapableBeanFactory().createBean(OFXSimpleManMapSession.class);
    // single user environment, userEnv and userEnvironment should be same anyway
    session.initSession(userEnv, srv, alwaysRollbackSession);
    return session;
  }
  public IOFXCommand createNewCommand(Class commandClass) {
    return ((IOFXCommand) context.getAutowireCapableBeanFactory().createBean(commandClass));
  }

  public void report(CoreReporterInfo cri) {
    if (logAllEventsToStdErrAdditionally) {
      System.err.println(OFXLogger.convertToString(cri));
    }
    if (!(mowareTrace) && cri.getMsgType() == IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE) {
      return;
    }
    if (!(appTrace) && cri.getMsgType() == IOFXCoreReporter.Type.APP_TRACE) {
      return;
    }

    boolean sent = false;

    if (portJLocal) {
      // log stuff to file, similar to batchjob
      sent = true;
      if (this.sendToPortJ(cri)) {
        OFXLogger.logCoreInfoToJOrConsole(cri);
      }

    } else if (portJEnabled) {
      // MoOptionalEventbus considers messages always sent
      sent = true;
      if (this.sendToPortJ(cri)) {
        sent = getEventBus().sendToLogChannel("portjlog", OFXLogger.convertToJSON(cri));

      }

    }

    if (!(sent)) {
      // lg7 also reports frmwrk problems, but for sure in DEBUG prio :) no spam mails
      if (cri.getMsgType() == IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM) {
        cri.setPrio(IOFXCoreReporter.LogPriority.DEBUG);
      }

      StringBuilder sb = new StringBuilder();

      sb.append(cri.getCmdFqName() + ": ");
      sb.append(cri.getDescription() + " ");

      if (cri.getParameters().containsKey(CoreReporterInfo.PARAM)) {
        sb.append(cri.getParameters().get(CoreReporterInfo.PARAM) + " ");
        cri.getParameters().remove(CoreReporterInfo.PARAM);
      }

      Set<String> allKeys = cri.getParameters().keySet();
      for (String key : allKeys) {
        sb.append(" " + key + ": " + cri.getParameters().get(key));
      }

      if (skipTCNExceptions && IOFXCoreReporter.TCN.equals(cri.getSource())) {
        // nop
      } else {
        OFXLogger.log(cri.getSource(), cri.getPrio(), sb.toString(), cri.getException());
      }
    }
  }

  public IMoEventBusService getEventBus() {
    return eventBusService;
  }

  public IOFXTranslationProvider getTransProvider() {
    return transProvider;
  }

  public IPrintingServiceImpl createConfiguredUserPrintService(Object tecHandle, IOFXUserEnvironment userEnvironment) {
    return printFactory.createConfiguredUserPrintService(tecHandle, userEnvironment);
  }
  public IOFXCmdModule getModuleByInstanceName(String fqName) {
    return (IOFXCmdModule) this.context.getBean(fqName);
  }
  public String getSystemLabel(int langIndex, MoWareTranslations.Key key) {
    // legacy existing translations
    if (langIndex < 0) {
      return defaulTrans.t(key);
    }

    if (transProvider.providesTranslationKey(key.name())) {
      return transProvider.translateSingle(langIndex, key.name());
    }
    return defaulTrans.t(key);
  }
  public IOFXPlatform getPlatform() {
    return platform;
  }
  public String getConnectionUrl() {
    if (connectionInfo == null) {
      try {
        DatabaseMetaData dbmd = dataSource.getConnection().getMetaData();

        connectionInfo = dbmd.getURL();
        String version = dbmd.getDriverVersion();
        connectionInfo += " (ver " + version + ")";

      } catch (SQLException sqex) {
        OFXLogger.log(BaseUiFactory.class, IOFXCoreReporter.LogPriority.INFO, "Can not get db-driver connection info", sqex);
        connectionInfo = "(not available due to SQLException)";
      }

    }
    return connectionInfo;
  }

  public ICommandContainer createCommandContainer() {
    try {
      if (commandContainerClass == null) {
        commandContainerClass = Class.forName(COMMAND_CONTAINER_FQ_NAME);
      }

      return ((ICommandContainer) commandContainerClass.newInstance());

    } catch (ClassNotFoundException e) {
      throw new RuntimeException(e);
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  public void setCommandContainerFqName(String fqName) {
    COMMAND_CONTAINER_FQ_NAME = fqName;
  }


  public boolean isFX8LegacyImpl() {
    return false;
  }

}
