package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXSession;

public class BasisCmdStart extends UxEvent implements IOFXSession.IUxEventActionable {
  private String commandFqName;

  private Object[] paramsToUse;
  private ICommandContainer parent;
  private String labelText;
  private String autoConclusion;
  private boolean autoConclusionMode;
  private boolean forcedToThisWindowCrtl;
  private String cmdIdentificationString;


  public BasisCmdStart(String cName, Object[] params) {
    commandFqName = cName;
    paramsToUse = params;

    // has to be set by EventCommandContainer after reception
    parent = null;
    labelText = null;
    autoConclusion = null;
    autoConclusionMode = false;
    forcedToThisWindowCrtl = false;
    cmdIdentificationString = null;
  }

  public BasisCmdStart(String label, String cName, Object[] params) {
    this(cName, params);
    setLabelText(label);
  }

  public void setCmdIdentification(String id) {
    cmdIdentificationString = id;
  }

  public void setParent(ICommandContainer par) {
    parent = par;
  }

  public ICommandContainer getParentContainer() {
    return parent;
  }

  public String getCommandName() {
    return commandFqName;
  }

  public void setLabelText(String txt) {
    labelText = txt;
  }
  public String getLabelText() {
    return labelText;
  }
  public BasisCmdStart withLabel(String lab) {
    setLabelText(lab);
    return this;
  }
  public void setAutoConclusion(String auto) {
    autoConclusion = auto;
    autoConclusionMode = true;
  }
  public String getAutoConclusion() {
    return autoConclusion;
  }
  public boolean onAutoConclusionOrNoUi() {
    return autoConclusionMode;
  }

  public boolean hasParamsSet() {
    return paramsToUse != null;
  }
  public Object[] getParams() {
    return paramsToUse;
  }

  public void forceToThisWindowCrtl() {
    forcedToThisWindowCrtl = true;
  }
  public boolean isForcedToThisWindowCrtl() {
    return forcedToThisWindowCrtl;
  }

  public BasisCmdStart cloneWithParams(Object[] singleExecParams) {
    BasisCmdStart s = new BasisCmdStart(commandFqName, singleExecParams);
    // check also in other clone methods
    s.setParent(getParentContainer());
    s.setLabelText(getLabelText());

    s.autoConclusion = this.autoConclusion;
    s.autoConclusionMode = this.autoConclusionMode;
    s.cmdIdentificationString = this.cmdIdentificationString;
    return s;
  }

  public String paramInfo() {
    return commandFqName;
  }

  @Override
  public void performAction() {
    // start via parent
    if (parent == null) {
      throw new RuntimeException("This can not happen");
    }
    parent.receiveAndProcess(this);
  }

  @Override
  public int getTriggerCode() {
    return this.hashCode();
  }
  public static void main(String[] args) {
    BasisCmdStart s1 = new BasisCmdStart("hello", null);
    Object[] obj = new Object[]{"test2"};
    BasisCmdStart s2 = new BasisCmdStart("hello", obj);
  }
}
