package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;

public class CircularEventStore {
  private int max;
  private int currentPos;
  private int eventsStored;

  private String[] events;


  public CircularEventStore(int maxSize) {
    max = maxSize;
    events = new String[max];
    currentPos = 0;
    eventsStored = 0;
  }

  public void add(UxEvent ev) {
    events[currentPos] = ev.toString();
    currentPos++;
    if (eventsStored < max) {
      eventsStored++;
    }
    if (currentPos >= max) {
      currentPos = 0;
    }
  }

  public String getLast() {
    if (eventsStored == 0) {
      // none
      return null;
    }

    int lastEventIndex = currentPos - 1;
    if (lastEventIndex < 0) {
      lastEventIndex = max - 1;
    }
    return events[lastEventIndex];
  }

  public List<String> toList() {
    ArrayList<String> inOrder = new ArrayList<String>(max);

    int index = currentPos - eventsStored;
    if (index < 0) {
      index = max + index;
    }
    for (int cnt = 0; cnt < eventsStored; cnt++) {
      inOrder.add(events[index]);
      index++;
      if (index >= max) {
        index = 0;
      }
    }
    return inOrder;
  }


  @Override
  public String toString() {
    StringBuilder b = new StringBuilder();
    int i = 0;
    for (String e : toList()) {
      b.append(String.format("%10s: %s\n", "" + i++, e));
    }
    return b.toString();
  }


  public static void main(String[] args) {
    CircularEventStore es = new CircularEventStore(3);
    es.add(new FukYouEvent("first"));
    es.add(new FukYouEvent("second"));
    es.add(new FukYouEvent("third"));
    es.add(new FukYouEvent("fourth"));
    es.add(new FukYouEvent("fivth"));
    es.add(new FukYouEvent("sixth"));
    es.add(new FukYouEvent("seventh"));
    System.out.println(es.toString());

  }


}
