package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConclusionInformation;
import org.modellwerkstatt.objectflow.runtime.IOFXPage;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenPagePane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.Arrays;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXChangePageException;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXCommandDisabledReason;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.OFXSuccessorCommandConfig;
import mjson.Json;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;

/**
 * CommandContainer provides the runtime environment for commands and is thus
 * presumably one of the most important classes. 
 * 
 * The class is independent of any application environment or toolkit. The defined 
 * behaviour can be used in any environment and acts as a shared single common source. 
 * 
 * CommandContainer provides all necessary infrastructure to run / end a command. The 
 * container is responsible for refresh logic and handling of parent commands. It wires 
 * together forms, pagepanes, ui implementation and the command itself.
 * 
 */
public abstract class CommandContainer implements ICommandContainer, ConsumerHandler {
  public static final int ESC_CONCLUSION_CODE = 0;
  public static final String ESC_CONCLUSION_ICON_NAME = "arrow_back";
  public static final int UPDATE_CONCLUSION_CODE = 1;

  protected IToolkit_UiFactory uiFactory;
  protected IApplication app;
  protected IWindowController windowCrtl;

  protected IOFXCommand command;
  protected Object[] cmdParams;
  protected IOFXCommand predecessorCommand;
  protected Object[] predecessorCmdParams;

  protected String fullCmdNameAndSuccessor;
  protected String sessId;
  protected String cmdStartDescription;
  protected int langIndex;

  protected boolean containerClosed;
  protected long containerClosedTimestamp;

  protected boolean isStillOkayAsParentForMultiExecution;


  protected CommandContainer parentCommandContainer;

  protected String windowTitle;
  protected String adjustedUrl;
  private int currentPageIndex;
  private List<IOFXProblem> currentProblems;
  private String currentPageTitle;
  private String currentLockingMessage;
  private List<?> currentBoundObjects;
  private String currentUIColor;


  protected List<OFXConclusionInformation> currentConclusionInfos;
  protected List<IOFXPage.IOFXPageConclusion> currentConclusions;

  private IGenPagePane currentGenPagePane;
  protected IToolkit_CommandContainerUi commandUI;
  protected PagePaneSelCrtl currentPagePaneSelCrtl;
  protected PagePaneSelectionRecorder selRecorder;

  protected boolean autoConclusionMode_NoUi;
  protected boolean commandRequestedModalTab;

  protected boolean ebLockingActive;
  protected long ebLockRequestedTimestamp;
  private List<String> ebLocksHold;


  public CommandContainer() {
  }

  public void initialize(IToolkit_UiFactory fact, IApplication crtl, IWindowController win, ICommandContainer parent, BasisCmdStart startEvent, String aSessId) {

    uiFactory = fact;
    app = crtl;
    windowCrtl = win;

    parentCommandContainer = ((CommandContainer) parent);
    containerClosed = false;
    currentUIColor = null;

    fullCmdNameAndSuccessor = startEvent.getCommandName();
    sessId = aSessId;
    windowTitle = startEvent.getLabelText();
    isStillOkayAsParentForMultiExecution = true;

    // default for successor is true, since ui is not opened if cancel in command init.
    commandRequestedModalTab = false;
    // autoconclusion init
    autoConclusionMode_NoUi = false;

    ebLockingActive = false;
    selRecorder = new PagePaneSelectionRecorder();
  }

  public boolean isSuccessor() {
    return predecessorCommand != null;
  }

  public boolean isAutoConNoUi() {
    return autoConclusionMode_NoUi;
  }
  public boolean setAutoConclusionMode_NoUi() {
    return autoConclusionMode_NoUi = true;
  }

  protected void fg_conclusionKey(KeyEvent ev) throws Exception {
    if (containerClosed) {
      return;
    }
    boolean processed = false;
    // (1) conclusion hotkeys are handled here, the ApplicationCrtl will dispatch hotkeys to the current
    // command.
    // (2) any action hotkeys have to be handled in the PagePaneCrtl (if global) or localy in Table
    // since table hotkeys depend on the ui focus.

    if ("DBG_GRAPH".equals(ev.getKey())) {
      String controllerInfo = currentPagePaneSelCrtl.getControllersInfo();
      windowCrtl.showGraphDebugger(currentPagePaneSelCrtl.getLoadedList(), controllerInfo);
      processed = true;

    } else if ("DBG_SESSION".equals(ev.getKey())) {
      windowCrtl.showBigInformationDialog("SESSION DEBUGGER\n\nYour session is currently in the following state:\n\n" + command.getCommandSession().toString(), null);
      processed = true;

    } else {
      for (OFXConclusionInformation info : currentConclusionInfos) {
        // only when no modifier active and conclusion enabled
        if (!(ev.isWithModifier()) && ev.getKey().equals(info.hotkey) && info.enabled) {
          processed = true;
          // we could also issue a event here..
          fg_doConclusion(info.conclusionHashCode);
          break;
        }
      }
    }
    if (!(processed)) {
      currentPagePaneSelCrtl.onGlobalKeyPressEvent(ev.getKey());
    }
  }



  protected void bg_fg_initContainer(InitCmdEvent ev) {
    cmdParams = ev.getParams();
    command = ev.getCommand();
    cmdStartDescription = ev.paramInfo();

    if (command.getCommandSession() == null) {
      this.receiveAndProcess(new CloseCntrExInfoEvent(new RuntimeException("Configuration/Programming Error - no session provided for command.")));
      return;
    } else if (command.hasSuccessorCommand() && isSuccessor()) {
      this.receiveAndProcess(new CloseCntrExInfoEvent(new RuntimeException("Command has a successor and is run as successor, this is not supported by the runtime.")));
      return;
    }


    langIndex = getSession().getUserEnvironment().getLangIndex();
    isStillOkayAsParentForMultiExecution = command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL);

    if (!(isSuccessor())) {
      commandRequestedModalTab |= command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL);
      // imediately inc counter, that will point out any problems straight away.
      app.getAppTelemetrics().incCommands();

      // graph edit takes over uicolor of parent
      if (command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD)) {
        currentUIColor = parentCommandContainer.currentUIColor;
      }
      if (currentUIColor == null) {
        currentUIColor = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(command.getCommandFqName())).getCommandDefaultColor(command.getCommandFqName());
      }
    }

    // straight before running command init we have to check for any locking issues, readOnly does not need locks
    if (!(command.getCommandSession().isReadOnly())) {
      // session not read only, check for necessary locks
      List<String> locks = command.getLockNecessaryLockNames();
      // sort out null locks
      locks = ListSequence.fromList(locks).where((it) -> it != null).toList();

      if (ListSequence.fromList(locks).count() > 0 && app.isEbLockingForThisInstance()) {
        // okay locks are needed ...
        ebLockingActive = true;
        ebLocksHold = ListSequence.fromList(new ArrayList<String>());

        uiFactory.getEventBus().register(this, "locking");
        String lockName = "";
        for (String lock : locks) {
          lockName += lock + ", ";
          ListSequence.fromList(ebLocksHold).addElement(lock.toLowerCase());
        }

        ebLockRequestedTimestamp = System.currentTimeMillis();
        uiFactory.getEventBus().publish("locking", createLockJson(lockName, ebLockRequestedTimestamp, this.hashCode()).set("type", "requestLock"));
      }
    }

    // lockingMessage and autoCommitMode => no ui?
    if (isAutoConNoUi() && currentLockingMessage != null) {
      List<IOFXProblem> problems = getSession().getAndclearProblemState();
      ListSequence.fromList(problems).addElement(new OFXProblem(currentLockingMessage, null, null));
      this.receiveAndProcess(new CancelAndClose(problems));
      return;
    }

    // measure command execution time
    try {
      currentProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());

      command.initCommand();

    } catch (OFXAbortedException aborted) {
      this.receiveAndProcess(new CancelAndClose(getSession().getAndclearProblemState()));
      return;

    } catch (Exception ex) {
      this.receiveAndProcess(new CloseCntrExInfoEvent(ex));
      return;

    }

    adjustedUrl = command.getAdjustedCmdUrl();

    // label not set in BasisCmdStart
    if (windowTitle == null) {
      windowTitle = command.getCommandTitleShort();
    }

    if (!(isSuccessor())) {
      String addOnTitle = command.getWindowTitle();

      if (addOnTitle != null && command.getWindowTitleType() == IOFXCommand.OFXWindowTitleType.ADD_ON) {
        windowTitle = windowTitle + " " + addOnTitle;

      } else if (addOnTitle != null) {
        // then it is overwrite or force overwrite.
        windowTitle = addOnTitle;

      }

    } else if (command.getWindowTitleType() == IOFXCommand.OFXWindowTitleType.FORCE_OVERWRITE) {
      // must be successor
      if (command.getWindowTitle() != null) {
        windowTitle = command.getWindowTitle();
      }
    }

    if (command.hasSuccessorCommand() && command.isReadyForSuccessor()) {
      prepareSuccessorExecution();
      return;
    }
    if (command.isTerminatedOk()) {
      this.receiveAndProcess(new CloseCntrCmdTermedEvent("no pages, term ok"));
      return;
    }
    if (command.isUserCancelTerminated()) {
      this.receiveAndProcess(new CloseCntrCmdTermedEvent("user canceled due to RO-session and no page present"));
      return;
    }

    // load them also in the same manner as the command init ...
    currentPageIndex = this.command.getCurrentPageIndex();

    // exec the initCurrentPage in background, but not the binding to PagePane
    try {
      selRecorder.clear();
      currentBoundObjects = command.initCurrentPage(selRecorder);
      // a flag in page init is allowed. it just displays the message then
      // but does not provide any data for rootSelectionController
      currentProblems = getSession().getAndclearProblemState();


    } catch (OFXAbortedException ex) {
      List<IOFXProblem> problems = getSession().getAndclearProblemState();
      if (isAutoConNoUi()) {
        this.receiveAndProcess(new CancelAndClose(problems));
        return;
      }

      currentBoundObjects = ListSequence.fromList(new ArrayList<>());
      currentProblems = problems;

    } catch (Exception ex) {
      this.receiveAndProcess(new CloseCntrExInfoEvent(ex));
      return;

    }

    currentPageTitle = command.calcCurrentPageDynamicTitleAndScopes();

    // we should not have a dirty session here, AND NO PREDECESSOR -> creator
    if (command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL)) {
      if (!(getSession().inSuccessorPattern()) && getSession().isDirty()) {
        app.logAppWarning(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "DIRTY_SESSION (not shared) after cmd init + page init", null);
      }
    }

    this.receiveAndProcess(new OpenUiEvent());
  }
  private IGenPagePane instantiateNewGenPagePane() {
    String currentPagePaneFqName = command.calcCurrentPagePaneFqName(command.getCurrentPageIndex());
    IGenPagePane pane = ((IGenPagePane) uiFactory.createGenPagePaneByFqName(currentPagePaneFqName));
    if (pane == null) {
      throw new RuntimeException("Form " + currentPagePaneFqName + " for Command " + command.getCommandFqName() + " not found (null). Recompile complete solution? ");
    }
    return pane;
  }
  private void setupNewInitializedGenPagePane() {
    // cleanup old one and instantiate new one
    if (currentPagePaneSelCrtl != null) {
      currentPagePaneSelCrtl.gcClear();
    }

    currentPagePaneSelCrtl = new PagePaneSelCrtl(this, uiFactory.getPlatform(), currentGenPagePane, currentGenPagePane.getPagePaneType(), langIndex);
    currentGenPagePane.initializeGenPagePane(currentPagePaneSelCrtl, uiFactory);

    if (command.getCommandSession().isReadOnly()) {
      currentPagePaneSelCrtl.forceNotEditable();
    }

    // set page title first
    if (currentPageTitle != null && !(currentPageTitle.trim().equals(""))) {
      currentGenPagePane.setHeading(currentPageTitle);
    }
    // something to flag? Yes - you can inappropriately use that in the init .. :(
    if (ListSequence.fromList(currentProblems).count() > 0) {
      configureProblemsWithAResolveAction(currentProblems);
      currentGenPagePane.setProblems(currentProblems);
      receiveAndProcess(new FlagOnUiEvent(currentProblems));

      currentProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());
    }

    // current page is already determined when calling this method
    currentConclusions = Arrays.asList(command.getCurrentPageConclusions(currentGenPagePane));
    currentConclusionInfos = new ArrayList<OFXConclusionInformation>();

    // first one is escape
    OFXConclusionInformation escInfo;

    if (currentConclusions.size() == 0 || isDocumentSearch()) {
      escInfo = new OFXConclusionInformation(ESC_CONCLUSION_CODE, uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.CLOSE_BUTTON), ESC_CONCLUSION_ICON_NAME, "ESC", false);
    } else {
      escInfo = new OFXConclusionInformation(ESC_CONCLUSION_CODE, uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.ESC_BUTTON), ESC_CONCLUSION_ICON_NAME, "ESC", false);
    }
    escInfo.enabled = !(command.hasOption(IOFXCommand.OFXCmdOptions.NO_ESC));
    currentConclusionInfos.add(escInfo);

    for (int i = 0; i < currentConclusions.size(); i++) {
      IOFXPage.IOFXPageConclusion curCon = currentConclusions.get(i);

      String buttonText = uiFactory.getTransProvider().translateSingle(langIndex, uiFactory.getPlatform().getTextForLabel(curCon.getLabelName()));
      OFXConclusionInformation info = new OFXConclusionInformation(curCon.hashCode(), buttonText, uiFactory.getPlatform().getIconForLabel(curCon.getLabelName()), uiFactory.getPlatform().getHotKeyForLabel(curCon.getLabelName()), uiFactory.getPlatform().isHideOnDisabledForLabel(curCon.getLabelName()));

      currentConclusionInfos.add(info);
    }

    commandUI.setConclusions(currentConclusionInfos, currentPagePaneSelCrtl.getGlobalHotkeys());
  }
  private void setupNewPageWithoutUI() {
    // cleanup old one and instantiate new one
    if (currentPagePaneSelCrtl != null) {
      currentPagePaneSelCrtl.gcClear();
    }

    currentPagePaneSelCrtl = new PagePaneSelCrtl(this, uiFactory.getPlatform(), null, ListSequence.fromList(currentBoundObjects).getElement(0).getClass(), langIndex);

    if (command.getCommandSession().isReadOnly()) {
      currentPagePaneSelCrtl.forceNotEditable();
    }

    // current page is already determined when calling this method
    currentConclusions = Arrays.asList(command.getCurrentPageConclusions(currentGenPagePane));
    currentConclusionInfos = new ArrayList<OFXConclusionInformation>();
    OFXConclusionInformation escInfo = new OFXConclusionInformation(ESC_CONCLUSION_CODE, uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.ESC_BUTTON), ESC_CONCLUSION_ICON_NAME, "ESC", false);

    escInfo.enabled = !(command.hasOption(IOFXCommand.OFXCmdOptions.NO_ESC));
    currentConclusionInfos.add(escInfo);

    for (int i = 0; i < currentConclusions.size(); i++) {
      IOFXPage.IOFXPageConclusion curCon = currentConclusions.get(i);
      String buttonText = uiFactory.getTransProvider().translateSingle(langIndex, uiFactory.getPlatform().getTextForLabel(curCon.getLabelName()));
      OFXConclusionInformation info = new OFXConclusionInformation(curCon.hashCode(), buttonText, uiFactory.getPlatform().getIconForLabel(curCon.getLabelName()), uiFactory.getPlatform().getHotKeyForLabel(curCon.getLabelName()), true);

      currentConclusionInfos.add(info);
    }
  }

  protected void fg_reevalConclusions() {
    // conclusions and buttons installed above (this method is called by pagepaneselcrtl)
    boolean scanConclusionPresent = false;
    for (int i = 0; i < currentConclusions.size(); i++) {
      // skip ESC, currentConclusions are without ESC, thus conInfos = currenCon + 1
      currentConclusionInfos.get(i + 1).enabled = currentConclusions.get(i).isEnabled();
      if ("UPD".equals(currentConclusionInfos.get(i + 1).hotkey)) {
        scanConclusionPresent = true;
      }
    }

    if (getSession().isLockedByOtherUser()) {
      currentConclusionInfos.get(0).enabled = true;

    }

    // new pattern here. check enabled condition without callbacks. Why not use this pattern with actions?
    // it is a little bit faster, since on request/response architectures, enabled has not to be reevaluated...
    if (!(isAutoConNoUi())) {
      commandUI.reevalConclusions(currentConclusionInfos);
    }

    app.reevalEnabledInMenusAndTiles();
  }

  protected void fg_requestFocusAndFinalAfterEventOnCurrentForm(boolean bringTabToForeGround) {
    if (bringTabToForeGround) {
      windowCrtl.focusTab(this, commandUI);
    }

    if (uiFactory.getReloadOnTabChange()) {
      // modilaka reload feature .. :) bad for search filter :(
      currentPagePaneSelCrtl.reloadViews();
    }

    commandUI.delayedRequestFocus();

    // This "event" is executed after the requestFocus(). So it is absolutely the
    // last thing that happens when interacting with the command. Hopefully, we can
    // also use that event to serialize ui interaction .. .

    currentPagePaneSelCrtl.preDelayedAfterFullUiInitialized();
    commandUI.delayedAfterFullUiInitialized();
  }



  protected void fg_openUserInterface() throws Exception {
    boolean successorCanUseUiFromPredecessor = isSuccessor() && commandUI != null;
    if (!(isAutoConNoUi())) {
      currentGenPagePane = instantiateNewGenPagePane();

      if (successorCanUseUiFromPredecessor) {
        // there is already a commandUI available.

      } else {
        // commandUI set due to successor pattern?
        if (command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD)) {
          boolean fullSize = command.wizzardWithFullSizeUis() || currentGenPagePane.pageNeedsMaxAvailableSpace();
          commandUI = uiFactory.createPromptContainerUi(app.getMainWindowImpl(), fullSize);
        } else {
          commandUI = uiFactory.createTabContainerUi(app.getMainWindowImpl(), commandRequestedModalTab);
        }
      }

      commandUI.setCommandContainer(this);

      if (currentLockingMessage != null && !(currentLockingMessage.equals(""))) {
        // this might call setNotification() twice no a tabui in case of predecessor
        commandUI.setNotification(currentLockingMessage);
      }

      setupNewInitializedGenPagePane();

      if (successorCanUseUiFromPredecessor) {
        IToolkit_Form frm = currentGenPagePane.getPagePaneToolkitImpl();
        frm.rootForm();
        commandUI.setContent(frm);

        if (command.getWindowTitleType() == IOFXCommand.OFXWindowTitleType.FORCE_OVERWRITE) {
          // calculated after cmd init
          commandUI.adjustWindowTitle(windowTitle);
        }



      } else {
        // supported at all?
        if (adjustedUrl != null) {
          commandUI.setAdjustUrl(adjustedUrl);
        }
        windowCrtl.showCommandContainerUI(this, commandUI, windowTitle, currentGenPagePane.getPagePaneToolkitImpl());
      }



    } else {
      // auto conclusion mode. do not instantiate an ui
      setupNewPageWithoutUI();

    }


    // Clear selection and select the first one (e.g. for FormDelegate), leads to
    // reload views and to a reevalEnabled for all componentes
    currentPagePaneSelCrtl.addLoadedListReference(currentBoundObjects);

    // request Focus, due to visibilty, view hierarchy etc -> only toolkit impl. can handle that.
    if (!(isAutoConNoUi())) {
      selRecorder.transferSelections(currentPagePaneSelCrtl);

      // set ui color if not null, color is only set after initialization, not dynamically.
      String color = currentGenPagePane.calcUiColor(currentPagePaneSelCrtl.getSelection(currentGenPagePane.getPagePaneType(), false).getObjectOrNull());
      if (color != null) {
        currentUIColor = color;
      }
      if (currentUIColor != null) {
        commandUI.setColor(currentUIColor);
      }


      fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
    }
  }

  protected void fg_ensureTerminatedAndCloseContainer(Exception x) {
    // Final ressort when ex happens
    try {
      if (containerClosed) {
        app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "CommandContainer.fg_ensureTerminatedExceptionConclusionAndCloseContainer() container already closed, but closing requested with ex.", OFXConsoleHelper.stackTrace2String(x));
        return;
      }


      // this can only occure, when an framework EX has happend and final_cancel not called within cmd
      if (!(command.isTerminatedCancel())) {
        command.doFinalCancelConclusion(null, x);
      }
      fg_closeUiAndContainer(x instanceof OFXShutDownSessionException);

    } catch (Throwable t) {
      // can not do anything - is ui closed now?
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "CommandContainer.fg_ensureTerminatedExceptionConclusionAndCloseContainer() Ex while closing command.", OFXConsoleHelper.stackTrace2String(t));
    }

  }
  protected void fg_cancelAndClose(boolean userCancelRequested, List<IOFXProblem> problems) {
    // cancelFirst might be false in case of a final_ok no-page command
    if (containerClosed) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "CommandContainer.fg_cancelAndClose() requested, but container already closed. (user_cancel " + userCancelRequested + " / " + problems + ")", OFXConsoleHelper._____organizeCurrentStacktrace_____());
      // ignore this call
      return;
    }

    try {
      if (userCancelRequested) {
        command.doFinalUserCancelConclusion();

      } else if (!(command.isTerminatedCancel())) {
        // e.g. not acknowledged error cancel windows from cmd init
        command.doFinalCancelConclusion(problems, null);

      }
    } catch (Exception ex) {
      app.logAppProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, ex, "CommandContainer.fg_cancelAndClose() ex in cmd while closing. (user_cancel " + userCancelRequested + " / " + problems + ")");
    }


    try {
      fg_closeUiAndContainer(false);
      // crash this container but not the whole app ... 
    } catch (Exception ex) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, ex, "CommandContainer.fg_cancelAndClose() frmwrk ex in fg_closeUiAndContainer(false). (user_cancel " + userCancelRequested + " / " + problems + ")");

      ebLockingActive = false;
      ebLocksHold = ListSequence.fromList(new ArrayList<String>());
    }

  }


  protected void fg_doConclusion(int ccHash) throws Exception {
    boolean wasDynamicUpdateConclusion = (ccHash == UPDATE_CONCLUSION_CODE);

    if (containerClosed) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "CommandContainer.fg_doConclusion() hash " + ccHash + " but container already closed!", OFXConsoleHelper._____organizeCurrentStacktrace_____());
      // ignore this call
      return;
    }

    if (app.checkForAppParDeploymentForward()) {
      // ignore conclusion execution and wait 
      return;
    }

    // ----------- handle esc ----
    if (ccHash == ESC_CONCLUSION_CODE) {
      // graph edit or search command can be canceld without asking user
      if (command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL) && command.getCommandSession().isDirty() && !(command.isCurrentlyReadOnlySession()) && !(isAutoConNoUi())) {
        // search command as well as modal dialogs do not confirm close ...
        receiveAndProcess(new CancelAndClose());
        return;
      }
      // no dirty session, close immediately
      receiveAndProcess(new CancelAndCloseImmediately(true, "USER_CANCEL"));
      return;
    }

    // ------ handle other conclusions
    // doConclusion is not suitable for background processing right now.
    // that would need a fg, bg, fg sequence
    if (ccHash == UPDATE_CONCLUSION_CODE) {
      for (OFXConclusionInformation info : currentConclusionInfos) {
        if ("UPD".equals(info.hotkey)) {
          ccHash = info.conclusionHashCode;
          break;
        }
      }
    }

    IOFXPage.IOFXPageConclusion conclusionToExecute = null;
    for (IOFXPage.IOFXPageConclusion c : currentConclusions) {
      if (c.hashCode() == ccHash) {
        conclusionToExecute = c;
        break;
      }
    }

    if (conclusionToExecute == null) {
      // Might happen on mde double send of form?
      throw new RuntimeException("TEC Problem: conclusion ccHash " + ccHash + " not found in " + currentConclusions + " (contclsd? " + containerClosed + ")");

    } else if (!(conclusionToExecute.isEnabled()) && getSession().isLockedByOtherUser()) {
      String msg = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.LOCK_NOT_GOT_CANCEL), getSession().getLockedByUser());

      List<IOFXProblem> problems = getSession().getAndclearProblemState();
      ListSequence.fromList(problems).addElement(new OFXProblem(msg, null, null));
      receiveAndProcess(new CancelAndClose(problems));
      return;

    } else if (!(conclusionToExecute.isEnabled())) {
      throw new RuntimeException("Conclusion " + conclusionToExecute.getLabelName() + " not enabled!");

    }


    boolean canSaveOnForms = true;
    boolean changePageRequestedInConclusion = false;
    try {
      // clear flag
      if (!(isAutoConNoUi())) {
        currentGenPagePane.setProblems(ListSequence.fromList(new ArrayList<IOFXProblem>()));
      }

      // if a save on the form is needed
      // can we execute that ?
      if (conclusionToExecute.needsSave()) {
        String errText = currentPagePaneSelCrtl.issueSaveAndValidate();
        canSaveOnForms = (errText == null);
        if (!(canSaveOnForms)) {
          if (uiFactory.flagValidationAdditionally()) {
            currentGenPagePane.setProblems(ListSequence.fromListAndArray(new ArrayList<IOFXProblem>(), new OFXProblem(errText, "", null)));
          } else {
            currentGenPagePane.setProblems(ListSequence.fromListAndArray(new ArrayList<IOFXProblem>(), new OFXProblem("", "", null)));
          }

        } else {
          List<IDelegateChange> changes = currentPagePaneSelCrtl.collectDelegateChanges();
          if (changes != null) {
            reportDelegateChanges(changes);
          }
        }
      }

      // if needed and we can, execut conclusion in command ..
      if (canSaveOnForms) {
        command.execConclusion(conclusionToExecute);

      }

      // the doConclusion() in command does catch the
      // - OFXCommandCancelException (and rethrow it)
      // - OFXCommandDoneException
      // - OFXChangePageException    (and rethrow it)
      // - OFXPageFlagException      (and rethrow it)
      // - any other exception       (and rethrow it)

      // okay, no exception, everything ok, but is command ended?
      // isTerminatedCancel() or isTerminatedException() is not possible here
      // 4th Jan. 2016 - wrong: isTerminatedCancel can be without excpt, when message is empty.
      if (command.hasSuccessorCommand() && command.isReadyForSuccessor()) {
        // this is special... we release events in case of successor exec..
        prepareSuccessorExecution();
        return;
      }
      if (command.isTerminatedOk() || command.isTerminatedCancel()) {
        receiveAndProcess(new CloseCntrCmdTermedEvent("Term in page conclusion"));
        return;
      }
      // do nothing here.. stay on the same form .. no reload no nothing, right?
      // yes, because container may have been closed already


    } catch (OFXAbortedException ex) {
      List<IOFXProblem> problems = getSession().getAndclearProblemState();

      // condition used in final_ok / final_cancel
      if (isAutoConNoUi() || (command.isTerminatedOk() || command.isTerminatedCancel())) {
        receiveAndProcess(new CancelAndClose(problems));
        return;
      }

      // flag might have changed any entities
      currentPagePaneSelCrtl.reloadViews();

      // then show flag message
      configureProblemsWithAResolveAction(problems);
      currentGenPagePane.setProblems(problems);
      // no flag after page init
      currentProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());

      // does that lead to a request focus after a flag. Is necessary, right?
      fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
      // early return here
      receiveAndProcess(new FlagOnUiEvent(problems));
      return;


    } catch (OFXChangePageException ex) {
      // question is - is it a reload or not?
      changePageRequestedInConclusion = true;

    }

    if (changePageRequestedInConclusion) {
      boolean inBackground = command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD) && uiFactory.useBackgroundThread() && !(wasDynamicUpdateConclusion);
      receiveAndProcess(new InitPageAfterCon(inBackground));

    } else if (!(isAutoConNoUi()) && canSaveOnForms) {
      // staying on same page and a ui is available.
      currentPagePaneSelCrtl.reloadViews();
      fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
    }

  }

  public void bg_fg_initPage() {
    boolean onlyAReload = (currentPageIndex == command.getCurrentPageIndex());
    currentPageIndex = command.getCurrentPageIndex();

    // thats nice, so if we are in a search command, clearKeyStore and force any repo interaction
    if (command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD)) {
      command.getCommandSession().clearAllKeystores();
    }

    long startTime = System.currentTimeMillis();
    try {
      selRecorder.clear();
      currentBoundObjects = command.initCurrentPage(selRecorder);

      List<IOFXProblem> sessionProblems = getSession().getAndclearProblemState();
      if (ListSequence.fromList(currentProblems).count() > 0) {
        // problems available for pagechange (legacy)
        ListSequence.fromList(currentProblems).addSequence(ListSequence.fromList(sessionProblems));

      } else {
        currentProblems = sessionProblems;
      }

      currentPageTitle = command.calcCurrentPageDynamicTitleAndScopes();


    } catch (OFXAbortedException ex) {
      List<IOFXProblem> problems = getSession().getAndclearProblemState();

      if (isAutoConNoUi()) {
        receiveAndProcess(new CancelAndClose(problems));
        return;
      }

      currentBoundObjects = ListSequence.fromList(new ArrayList<>());

      // set by page statement?
      ListSequence.fromList(currentProblems).addSequence(ListSequence.fromList(problems));

    } catch (Exception ex) {
      receiveAndProcess(new CloseCntrExInfoEvent(ex));
      return;
    }
    receiveAndProcess(new SetupUiAftrPageInit(onlyAReload, startTime));
  }

  public void fg_setupUiAfterPageInit(SetupUiAftrPageInit uEvent) {
    boolean onlyAReload = uEvent.isReloadOnly();

    if (!(onlyAReload)) {
      currentGenPagePane = instantiateNewGenPagePane();
      setupNewInitializedGenPagePane();
      IToolkit_Form frm = currentGenPagePane.getPagePaneToolkitImpl();
      frm.rootForm();
      commandUI.setContent(frm);

    } else {
      // title and flag also available on reload
      if (currentPageTitle != null && !(currentPageTitle.trim().equals(""))) {
        currentGenPagePane.setHeading(currentPageTitle);
      }
      if (ListSequence.fromList(currentProblems).count() > 0) {
        configureProblemsWithAResolveAction(currentProblems);
        currentGenPagePane.setProblems(currentProblems);
        receiveAndProcess(new FlagOnUiEvent(currentProblems));

        currentProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());
      }
      // set selection crtl fro pagePane
      command.getCurrentPageConclusions(currentGenPagePane);
    }

    currentPagePaneSelCrtl.addLoadedListReference(currentBoundObjects);
    selRecorder.transferSelections(currentPagePaneSelCrtl);

    fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
  }


  public void fg_pushSelectionNoReloadView(Object objectToSelect) {
    IOFXSelection possibleSelection = Selection.convertObject2Selection(objectToSelect);
    currentPagePaneSelCrtl.updateSelectionExchangeRootObjects(possibleSelection, command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD));

  }

  public boolean fg_handleGlobalCmdTerminate(GlobalCmdTermEvent ev, String compoundGOConc) throws Exception {

    if (command == null || containerClosed == true) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "fg_handleGlobalCmdTerminate() command is null - due to printing? [NPE predecessor=" + predecessorCommand + " closed=" + containerClosed + "]", null);
      return true;


    } else if (parentCommandContainer == ev.getClosedContainer()) {
      // my parent was closed, should never happen in case we are a GE
      parentCommandContainer = null;

      if (this.isGraphEdit()) {
        receiveAndProcess(new CancelAndCloseImmediately(false, "Graph owner of this graph edit was killed. canceling this ge."));
      }
      return true;


    } else if (ev.iAmParent(this) && ev.killParentGO() && !(isAutoConNoUi())) {
      // do not kill parent with this when in autocon mode; else kill this parent now..
      receiveAndProcess(new CancelAndCloseImmediately(false, "GUARD in graphedit " + fullCmdNameAndSuccessor));

      return true;
    }



    // LEGACY MODE: (1) exchange objects, (2) push selections, (3) calc PageDynTitle and (4) reload views
    if (!(command.hasOption(IOFXCommand.OFXCmdOptions.NEW_STYLE_TERM_HANDLING)) && ev.iAmParent(this)) {
      for (Object obj : ev.getCmdSelections()) {
        fg_pushSelectionNoReloadView(obj);
      }
    }

    // work on handlers, if any handler present ... 
    // clear problem state also when noHandler and parent 

    if ((IOFXCommand.OFXTermHandlerType.NoOrChildHandler(command.getCmdTermHandlerType()) && ev.iAmParent(this)) || IOFXCommand.OFXTermHandlerType.ALSO_ANY_CMD_TERM.equals(command.getCmdTermHandlerType())) {
      if (!(isAutoConNoUi())) {
        currentGenPagePane.setProblems(ListSequence.fromList(new ArrayList<IOFXProblem>()));
      }
    }

    if ((IOFXCommand.OFXTermHandlerType.CHILD_CMD_TERM_ONLY.equals(command.getCmdTermHandlerType()) && ev.iAmParent(this)) || IOFXCommand.OFXTermHandlerType.ALSO_ANY_CMD_TERM.equals(command.getCmdTermHandlerType())) {
      try {

        selRecorder.clear();
        command.handleCmdTermAndClearGeFqName(ev.iAmParent(this), ev.wasOk(), ev.getCmdSelections(), selRecorder);

      } catch (OFXAbortedException ex) {
        isStillOkayAsParentForMultiExecution = false;
        List<IOFXProblem> problems = getSession().getAndclearProblemState();

        if (isAutoConNoUi()) {
          receiveAndProcess(new CancelAndClose(problems));

        } else {
          configureProblemsWithAResolveAction(problems);
          currentGenPagePane.setProblems(problems);
          currentProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());

          if (!(ev.isNoReloadOnParent())) {
            currentPagePaneSelCrtl.reloadViews();
            selRecorder.transferSelections(currentPagePaneSelCrtl);
          }
          receiveAndProcess(new FlagOnUiEvent(problems));
        }
        return true;


      } catch (Exception e) {
        isStillOkayAsParentForMultiExecution = false;
        receiveAndProcess(new CloseCntrExInfoEvent(e));
        return true;

      }
    }

    // -- -- -- final reload -- -- -- 
    if (ev.iAmParent(this) || IOFXCommand.OFXTermHandlerType.ALSO_ANY_CMD_TERM.equals(command.getCmdTermHandlerType())) {
      if (!(ev.isNoReloadOnParent()) && !(isAutoConNoUi())) {


        currentPageTitle = command.calcCurrentPageDynamicTitleAndScopes();
        if (currentPageTitle != null && !(currentPageTitle.trim().equals(""))) {
          currentGenPagePane.setHeading(currentPageTitle);
        }

        currentPagePaneSelCrtl.reloadViews();
        selRecorder.transferSelections(currentPagePaneSelCrtl);

      }
    }

    // -- -- -- handle auto conclusion -- -- -- 
    if (ev.iAmParent(this) && isAutoConNoUi()) {

      // we are outer cmd (GO), handle auto conclusion, do not have to reload own views in autoconclusion mode
      if (compoundGOConc == null) {
        throw new IllegalStateException("AutoConc of GO " + fullCmdNameAndSuccessor + " is null.");
      }
      if (ev.wasOk()) {
        int conclusionHash = getConclusionHashFromName(compoundGOConc);
        receiveAndProcess(new ConclusionEvent(conclusionHash, "AutoCon"));
        return true;
      } else {
        receiveAndProcess(new CancelAndCloseImmediately(false, "auto conclusion no ui - child not termed final_ok"));
        return true;
      }
    }

    // event not relevant for logging
    return false;
  }

  public void fg_closeUiAndContainer(boolean sessionShutdownByGuard) {

    // okay, close container ..
    containerClosed = true;
    isStillOkayAsParentForMultiExecution = false;
    containerClosedTimestamp = System.currentTimeMillis();

    // eventbus locks used?
    try {
      if (ebLockingActive) {
        getUiFactory().getEventBus().unregister(this, "locking");
      }

    } catch (Throwable t) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "Ex while unregistering locking", OFXConsoleHelper.stackTrace2String(t));

    } finally {
      ebLocksHold = null;
      ebLockingActive = false;
    }


    List<Object> selectionsToForward = ListSequence.fromList(new ArrayList<Object>());

    if (command == null) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "Command is null here (MoWare Bug) - this can not be true", OFXConsoleHelper._____organizeCurrentStacktrace_____());
      return;
    }


    if (command.isTerminatedOk()) {
      app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "command closed FINAL_OK", "", null);

      String cmdOkMsg;
      if (!(isSuccessor())) {
        cmdOkMsg = command.getTerminateOkInformation();
        selectionsToForward = command.getTerminateOkSelections();

      } else {
        cmdOkMsg = predecessorCommand.getTerminateOkInformation();
        selectionsToForward = predecessorCommand.getTerminateOkSelections();

        if (ListSequence.fromList(selectionsToForward).count() == 0) {
          // just take command selections? 
          selectionsToForward = command.getTerminateOkSelections();
          if (ListSequence.fromList(selectionsToForward).count() > 0) {
            String successorMsg = command.getTerminateOkInformation();
            if (cmdOkMsg != null && successorMsg != null) {
              cmdOkMsg = successorMsg + " - " + cmdOkMsg;

            } else if (successorMsg != null) {
              cmdOkMsg = successorMsg;

            }
          }
        }

      }

      boolean hasProblemOtherThenWarnings = getSession().hasProblemsOtherThanWarnings();
      List<IOFXProblem> remainingProblems = getSession().getAndclearProblemState();

      if (ListSequence.fromList(remainingProblems).count() > 0) {
        if (hasProblemOtherThenWarnings) {
          throw new RuntimeException("Command " + fullCmdNameAndSuccessor + "  has remaining problems but is terminatedOk.\n" + FlagOnUiEvent.asSimpleString(remainingProblems));
        }

        if (cmdOkMsg != null) {
          ListSequence.fromList(remainingProblems).addElement(new OFXProblem("\n" + cmdOkMsg, null, null, IOFXProblem.Opt.WARNING_HINT));
        }
        windowCrtl.showProblemsDialog(remainingProblems, null);

      } else if (cmdOkMsg != null) {
        windowCrtl.setToastInformation(cmdOkMsg);

      }


    } else if (command.isTerminatedCancel()) {
      app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "command closed FINAL_CANCEL", "", null);

      // selection update needed?
      if (!(isSuccessor())) {
        selectionsToForward = command.getTerminateCancelSelections();
      } else {
        selectionsToForward = predecessorCommand.getTerminateCancelSelections();
      }

    } else if (command.isUserCancelTerminated()) {
      app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "command closed FINAL_USER_CANCEL", "", null);

    } else {
      // not terminated in cancel or in exception. this is an infra error.
      throw new RuntimeException("Command container close requested (not a forced shutdown), but command not terminated in ok, cancel or user cancel. cmd=" + fullCmdNameAndSuccessor);

    }

    try {
      // typically this might crash on an app problem

      if (!(isAutoConNoUi())) {
        // in case we do not have an ui, commandUI is null, inform app crtl
        windowCrtl.closeCommandContainerUI(this, commandUI, parentCommandContainer);
      }
    } catch (Exception ex) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "CommandContainer.fg_closeUiAndContainer(): Apcrtl excpt isolated on excpt shutdown.", OFXConsoleHelper.stackTrace2String(ex));

    }


    // was a ui used at all?
    if (currentPagePaneSelCrtl != null) {
      // does also clean up gen s
      currentPagePaneSelCrtl.gcClear();
    }
    currentPagePaneSelCrtl = null;
    currentGenPagePane = null;


    // that s it .. dec command count. seems to be a clean shutdow, gcClear already called.
    app.getAppTelemetrics().decCommand();
    // No exception after this point, infra already down.

    // necessary only for graph edits, sharing a session
    boolean killParentGo = sessionShutdownByGuard && command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD);
    GlobalCmdTermEvent commandTermEvent = new GlobalCmdTermEvent(this, parentCommandContainer, killParentGo, command.isTerminatedOk(), command.isUserCancelTerminated(), command.isTerminatedCancel(), selectionsToForward);

    // inform container also.
    commandUI = null;
    cmdParams = null;

    IOFXSession.IUxEvent registeredEvent = null;
    if (command.isTerminatedOk()) {
      registeredEvent = getSession().getRegisteredUxEvent();
    }

    command = null;
    // dan spring 19 - do not uifactory to null, we use it for logging.
    currentConclusions = null;
    currentConclusionInfos = null;

    // Do NOT SET applicationController to null in order to always allow for monitorting
    windowCrtl.commandClosed(commandTermEvent);

    if (registeredEvent != null) {
      windowCrtl.receiveAndProcess(((UxEvent) registeredEvent));
    }


    // paraentCommandContainer still accessible by others while processing commandClosed()
    parentCommandContainer = null;
    predecessorCommand = null;
    predecessorCmdParams = null;
  }

  private String calcDisabledReasonText(OFXCommandDisabledReason reason, String labelText) {

    String msg = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.CMD_NOT_ENABLED), labelText);
    if (reason == null) {
      // mh, this should not happen

    } else if (reason.getReasonType() == OFXCommandDisabledReason.ReasonType.WRONG_STATE) {
      msg = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.INNER_CMD_WRONG_STATE), labelText, reason.getFurtherDesc());

    } else if (reason.getReasonType() == OFXCommandDisabledReason.ReasonType.NO_PERMISSION) {
      msg = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.INNER_CMD_NO_PERM), labelText);

    }
    return msg;
  }
  public void fg_startCompoundInnerCommand(CompoundOuterCmdStart outerCompound) {

    // current selection controller is currentpagepanesel
    IOFXDynCmdParams paramProvider = outerCompound.getInnerUriParamProv();
    Object[] paramsForInner;
    if (paramProvider != null) {
      paramsForInner = paramProvider.calc(currentPagePaneSelCrtl, null);

    } else {
      paramsForInner = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(outerCompound.getInnerGeCmd())).getCommandDefaultParams(outerCompound.getInnerGeCmd(), currentPagePaneSelCrtl, null);
    }

    BasisCmdStart innerCmdEvent = new BasisCmdStart(outerCompound.getInnerGeCmd(), paramsForInner);
    if (outerCompound.getInnerGeAutoCon() != null) {
      innerCmdEvent.setAutoConclusion(outerCompound.getInnerGeAutoCon());
    }

    IOFXCmdModule procOfInner = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(innerCmdEvent.getCommandName()));
    boolean enabled = procOfInner.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, innerCmdEvent.getCommandName(), paramsForInner, getSession()) != IOFXCmdModule.CommandPermission.DISABLED;

    if (!(enabled)) {
      OFXCommandDisabledReason reason = new OFXCommandDisabledReason(OFXCommandDisabledReason.ReasonType.COMPLEX_CONDITION, "Bedingung nicht erfüllt");
      String msg = calcDisabledReasonText(reason, ((!("".equals(outerCompound.getLabelText()))) ? outerCompound.getLabelText() : MoVersion.getShortNameFromFQ(innerCmdEvent.getCommandName())));

      List<IOFXProblem> problems = getSession().getAndclearProblemState();
      ListSequence.fromList(problems).addElement(new OFXProblem(msg, null, null));
      receiveAndProcess(new CancelAndClose(problems));

    } else {
      // start innter with App-Crtl, since we have to use different parent and differnet sel crtl now!
      receiveAndProcess(innerCmdEvent);

    }

  }

  public int getConclusionHashFromName(String autoConclusionName) throws Exception {
    Integer conclusionHash = null;

    if ("OFX_USER_CANCEL".equals(autoConclusionName)) {
      conclusionHash = 0;

    } else {
      // look up conclusion hash....
      for (int i = 0; i < currentConclusions.size(); i++) {
        if (currentConclusions.get(i).getName().equals(autoConclusionName)) {
          conclusionHash = currentConclusions.get(i).hashCode();
          break;
        }
      }
      if (conclusionHash == null) {
        throw new RuntimeException("getConclusionHashByName '" + autoConclusionName + "' not found in " + command.getCommandFqName() + "\n available " + currentConclusions);
      }

    }
    return conclusionHash;
  }

  private void prepareSuccessorExecution() {
    OFXSuccessorCommandConfig cfg = command.getSuccessorCommandConfig();

    // permissions are finally checked by proc
    IOFXCmdModule prc = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(cfg.getCmdName()));

    IOFXCmdModule.CommandPermission perm = prc.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, cfg.getCmdName(), cfg.getParams(), getSession());

    if (perm == IOFXCmdModule.CommandPermission.DISABLED) {
      // uups
      OFXCommandDisabledReason reason = new OFXCommandDisabledReason(OFXCommandDisabledReason.ReasonType.COMPLEX_CONDITION, "Bedingung nicht erfüllt.");
      String msg = calcDisabledReasonText(reason, MoVersion.getShortNameFromFQ(cfg.getCmdName()));

      List<IOFXProblem> problems = getSession().getAndclearProblemState();
      ListSequence.fromList(problems).addElement(new OFXProblem(msg, null, null));
      receiveAndProcess(new CancelAndClose(problems));

    } else if (uiFactory.getCheckAlsoPredecessorDuplication() && commandUI == null && app.isSameInstanceRunningThenFocus(cfg.getCmdName(), cfg.getParams())) {

      receiveAndProcess(new CancelAndCloseImmediately(false, "Successor already running"));

    } else {

      IOFXCommand cmd = prc.startCommand(IOFXCmdModule.CmdExecStrategy.INNER_NO_NEW_SESSION, cfg.getCmdName(), cfg.getParams(), getSession(), getSession().getUserEnvironment(), getSession().getUserServices());

      // origParams set by InitCmdEvent. Running in same container !
      predecessorCommand = command;
      predecessorCmdParams = cmdParams;
      command = cmd;

      fullCmdNameAndSuccessor = getSession().getCurrentCmdName();

      command.manageAlsoPredecessor(predecessorCommand);
      // not in background, since we do not expect any checkout activity
      receiveAndProcess(new InitCmdEvent(false, cmd, cfg.getParams()));
    }
  }

  protected Json createLockJson(String lockName, long reqTimeStamp, long reqId) {
    String userName = getSession().getUserEnvironment().getUserName();
    String deviceId = getSession().getUserEnvironment().getDeviceId();
    String deviceName = getSession().getUserEnvironment().getDeviceName();
    long appStartupTime = getSession().getUserEnvironment().getAppStartupLocalMillis();

    // former containerHash is actually a kind of req. id
    Json obj = Json.object().set("lockName", lockName).set("userName", userName).set("deviceName", deviceName).set("deviceId", deviceId).set("userInstanceName", lockingInstanceName()).set("requestTimestamp", ebLockRequestedTimestamp).set("containerHash", reqId).set("appStartup", appStartupTime);
    return obj;
  }

  protected String lockingInstanceName() {
    String userName = getSession().getUserEnvironment().getUserName();
    return userName + "__" + this.hashCode();
  }

  protected boolean isRelevantLock(String userInstanceName, String lockName) {

    if (userInstanceName.equals(lockingInstanceName())) {
      return false;
    }

    for (String tmp : lockName.split(",")) {
      final String requestedLock = tmp.trim();

      if (!("".equals(requestedLock)) && ListSequence.fromList(ebLocksHold).any((it) -> it.equals(requestedLock))) {
        return true;
      }
    }
    return false;
  }

  public void fg_showLockInfo(String byUsers) {
    if (!(getSession().isLockedByOtherUser())) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "A showLockInfo() was issued, but session was not locked", "isLockedByOtherUser()=" + getSession().isLockedByOtherUser() + " / isReadOnly()=" + getSession().isReadOnly());

    } else {
      ListSequence.fromList(ebLocksHold).clear();
      uiFactory.getEventBus().unregister(this, "locking");
      ebLockingActive = false;

      currentLockingMessage = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.LOCK_NOT_GOT_READONLY), byUsers);
      if (commandUI != null) {
        commandUI.setNotification(currentLockingMessage);
        // shortcut, but open ui might not be processed fully.  
        receiveAndProcess(new ReevalEvent());
      }
    }
  }




  private boolean isEqualOnParam(Object param1, Object param2) {
    // one of them null?
    if (param1 == null || param2 == null) {
      if (param1 != param2) {
        return false;
      }
      return true;
    }
    // both are not null..  mh.. any of IOFXEntity?
    if (param1 instanceof IOFXEntity || param2 instanceof IOFXEntity) {
      if (!(param1 instanceof IOFXEntity && param2 instanceof IOFXEntity)) {
        return false;
      }
      // not the same, when creating new instances ... which are not save on db already ..
      if (OFXKeyReference.isNullKey(((IOFXEntity) param1).getIM3Key()) && OFXKeyReference.isNullKey(((IOFXEntity) param2).getIM3Key())) {
        return false;
      }

      return isEqualOnParam(((IOFXEntity) param1).getIM3Key(), ((IOFXEntity) param2).getIM3Key());
    }
    // okay, not null, not entity .. don t know.. simply puh .. just check with equals ?
    return param1.equals(param2);
  }

  private boolean checkCmdInstance(IOFXCommand iam, Object[] myParams, String fqName, Object[] params) {
    if (!(iam.getCommandFqName().equals(fqName))) {
      return false;
    }

    if (myParams.length != params.length) {
      return false;
    }
    for (int i = 0; i < myParams.length; i++) {
      if (!(isEqualOnParam(myParams[i], params[i]))) {
        return false;
      }
    }
    return true;
  }
  public boolean isSameCommandInstance(String fqName, Object[] params) {
    if (predecessorCommand != null && uiFactory.getCheckAlsoPredecessorDuplication()) {
      return checkCmdInstance(predecessorCommand, predecessorCmdParams, fqName, params) || checkCmdInstance(command, cmdParams, fqName, params);

    }
    return checkCmdInstance(command, cmdParams, fqName, params);
  }

  public boolean hasRwSessionToCommit() {
    boolean hasSessionToCommit = (command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD) || command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL)) && !(command.isCurrentlyReadOnlySession());
    return hasSessionToCommit;
  }
  public boolean isGraphEdit() {
    return command.isCommandType(IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD);
  }
  public boolean isReadOnly() {
    return command.isCurrentlyReadOnlySession();
  }
  public boolean isDocumentSearch() {
    return command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD);
  }

  public IOFXSelection getSelectionAbsoluteFromCurrentPagePane(Class cls, boolean includingDerived) {
    // stateless
    return currentPagePaneSelCrtl.getSelectionAbsolute(cls, includingDerived);
  }
  public IToolkit_UiFactory getUiFactory() {
    // stateless
    return uiFactory;
  }

  public IOFXSession getSession() {
    return command.getCommandSession();
  }
  @Override
  public String toString() {
    // use dumpContainerSate for full info, this one is used in corereporter logging
    return fullCmdNameAndSuccessor;
  }
  public boolean isStillOkayAsParentForMultiExecution() {
    return isStillOkayAsParentForMultiExecution;
  }
  public String dumpCmdContainerState() {
    String s = "**** CommandContainer for " + fullCmdNameAndSuccessor + ", closed=" + containerClosed + "\n";
    s += "**** autoconclusionMode_NoUI=" + autoConclusionMode_NoUi + " isSuccesorNor" + isSuccessor();
    s += "**** predecessor=" + predecessorCommand;
    s += "**** parentCommand=" + parentCommandContainer;
    return s;
  }

  public void reportDelegateChanges(List<IDelegateChange> changes) {
    for (IDelegateChange chg : changes) {
      app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.DELEGATGECHANGE, chg.getSource(), chg.getChange(), null);
    }
  }
  public void configureProblemsWithAResolveAction(List<IOFXProblem> prblms) {

    ListSequence.fromList(prblms).visitAll((it) -> {
      BasisCmdStart bcs = ((BasisCmdStart) it.getResolveActionOrNull());
      if (bcs != null) {
        bcs.setParent(CommandContainer.this);

        IOFXCmdModule module = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(bcs.getCommandName()));
        IOFXTranslationProvider tranProvider = uiFactory.getTransProvider();
        IOFXPlatform platform = uiFactory.getPlatform();

        if (bcs.getLabelText() == null) {
          String defaultLabel = module.getCommandDefaultLabel(bcs.getCommandName());
          String labelText = tranProvider.translateSingle(getSession().getUserEnvironment().getLangIndex(), defaultLabel);
          bcs.setLabelText(labelText);

        } else {
          String labelText = tranProvider.translateSingle(getSession().getUserEnvironment().getLangIndex(), platform.getTextForLabel(bcs.getLabelText()));
          bcs.setLabelText(labelText);
        }
      }
    });

  }
}
