package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormat;
import java.util.concurrent.BlockingQueue;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import java.util.concurrent.LinkedBlockingQueue;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.javaxbus.Message;
import mjson.Json;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.joda.time.DateTime;

public class EventCommandContainer extends CommandContainer {
  public static DateTimeFormatter LOCK_DBG_TIME_FRMT = DateTimeFormat.forPattern("EEE HH:mm:ss.SSS");

  private BlockingQueue<UxEvent> containerEventQueue;
  private CircularEventStore lastEvents;
  private boolean inLoop;

  private CompoundOuterCmdStart compoundCommand;
  private String singleAutoConclusion;

  private long lastBgEventStartTime;
  private UxBgableEvent lastBgEvent;
  private volatile boolean processingPossileNoShutdown;


  public EventCommandContainer() {
  }

  public void initContainer(IToolkit_UiFactory fact, IApplication crtl, IWindowController win, ICommandContainer parent, BasisCmdStart cmdStart, String sessId) {
    super.initialize(fact, crtl, win, parent, cmdStart, sessId);

    compoundCommand = null;
    singleAutoConclusion = null;
    containerEventQueue = new LinkedBlockingQueue<UxEvent>(10);
    lastEvents = new CircularEventStore(15);
    inLoop = false;
    processingPossileNoShutdown = true;

    if (cmdStart instanceof CompoundOuterCmdStart) {
      compoundCommand = ((CompoundOuterCmdStart) cmdStart);
      if (compoundCommand.onAutoConclusionOrNoUi()) {
        super.setAutoConclusionMode_NoUi();
      }

    } else if (cmdStart.onAutoConclusionOrNoUi()) {
      // BasisCmdStart then .... 
      singleAutoConclusion = cmdStart.getAutoConclusion();
      super.setAutoConclusionMode_NoUi();

    }

    lastBgEventStartTime = 0;
    lastBgEvent = null;
  }

  public void receiveAndProcess(UxEvent message) {
    // No EX handling here, since we do not expect any exceptions
    if (!(processingPossileNoShutdown)) {
      return;
    }

    if (message instanceof BasisCmdStart) {
      ((BasisCmdStart) message).setParent(this);
      windowCrtl.receiveAndProcess(message);

    } else if (message instanceof MultiCmdStart) {
      ((MultiCmdStart) message).setParent(this);
      windowCrtl.receiveAndProcess(message);

    } else {
      containerEventQueue.add(message);

      // we have a message to process, rock on...
      if (!(inLoop) && (app.getMainWindowImpl() == null || app.getMainWindowImpl().inUiThread())) {
        processPendingEvents();
      }
    }
  }

  public void internal_immediatelyShutdown() {
    processingPossileNoShutdown = false;
    containerEventQueue.clear();
    containerEventQueue.add(new CancelAndCloseImmediately(true, "immediately shutdown app"));
    processPendingEvents();
  }
  public synchronized void processPendingEvents() {

    if (containerEventQueue.size() == 0) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.APP, "processPendingEvents() in EventCommandContainer called without any events to process (or lock recv. while open ui)", null);
      return;
    }

    UxEvent ev = null;
    long evStartTime = 0;
    boolean logEventAsMowareTrace = false;
    try {
      inLoop = true;
      while (containerEventQueue.size() > 0) {
        ev = containerEventQueue.take();

        logEventAsMowareTrace = true;
        evStartTime = System.currentTimeMillis();
        lastEvents.add(ev);

        // log correct time of Background events, log all bg events!
        if (lastBgEvent != null) {
          logEvent(lastBgEvent, System.currentTimeMillis() - lastBgEventStartTime);
          lastBgEvent = null;
          lastBgEventStartTime = 0;
        }

        // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        if (ev instanceof InitCmdEvent) {
          final InitCmdEvent initEvent = ((InitCmdEvent) ev);

          if (initEvent.inBackground()) {
            app.getMainWindowImpl().execEventInBackground(this, new Runnable() {
              public void run() {
                bg_fg_initContainer(initEvent);
              }
            });

          } else {
            bg_fg_initContainer(initEvent);

          }

        } else if (ev instanceof OpenUiEvent) {
          fg_openUserInterface();

          if (compoundCommand != null && compoundCommand.hasInnerGe()) {
            // start inner
            fg_startCompoundInnerCommand(compoundCommand);

          } else if (compoundCommand != null && !(compoundCommand.hasInnerGe())) {
            // compound without inner always on auto?
            int ccHash = getConclusionHashFromName(compoundCommand.getAutoConclusion());
            receiveAndProcess(new ConclusionEvent(ccHash, "AutoCon"));


          } else if (singleAutoConclusion != null) {
            int ccHash = getConclusionHashFromName(singleAutoConclusion);
            receiveAndProcess(new ConclusionEvent(ccHash, "AutoCon"));

          }

        } else if (ev instanceof FocusEvent) {
          logEventAsMowareTrace = false;
          fg_requestFocusAndFinalAfterEventOnCurrentForm(((FocusEvent) ev).isBringTabToForeground());

        } else if (ev instanceof ReevalEvent) {
          logEventAsMowareTrace = false;
          fg_reevalConclusions();

        } else if (ev instanceof PushSelEvent) {
          fg_pushSelectionNoReloadView(((PushSelEvent) ev).getSingleObjectToSelect());
          currentPagePaneSelCrtl.reloadViews();

        } else if (ev instanceof KeyEvent) {
          fg_conclusionKey(((KeyEvent) ev));

        } else if (ev instanceof LockInfoEvent) {
          fg_showLockInfo(((LockInfoEvent) ev).getByUser());

        } else if (ev instanceof InitPageAfterCon) {
          InitPageAfterCon ipac = ((InitPageAfterCon) ev);
          if (uiFactory.isFX8LegacyImpl()) {
            // fop problems again? ESC while rendering in conclusion?  ipac.inBackground() also true :)
            UxEvent fopEscHit = containerEventQueue.peek();
            if (fopEscHit != null && fopEscHit instanceof CancelAndCloseImmediately && ((CancelAndCloseImmediately) fopEscHit).isUserCancel()) {
              containerEventQueue.take();
            }
          }
          if (ipac.inBackground()) {
            app.getMainWindowImpl().execEventInBackground(this, new Runnable() {
              public void run() {
                bg_fg_initPage();
              }
            });

          } else {
            bg_fg_initPage();

          }

        } else if (ev instanceof SetupUiAftrPageInit) {
          // response to next event :)
          fg_setupUiAfterPageInit(((SetupUiAftrPageInit) ev));

        } else if (ev instanceof ConclusionEvent) {
          ConclusionEvent concEv = ((ConclusionEvent) ev);
          fg_doConclusion(concEv.getConclusionHash());

        } else if (ev instanceof CloseCntrCmdTermedEvent) {
          fg_closeUiAndContainer(false);

        } else if (ev instanceof CloseCntrExInfoEvent) {
          final CloseCntrExInfoEvent resultInfo = ((CloseCntrExInfoEvent) ev);
          // probably command already temrinated

          windowCrtl.showException(fullCmdNameAndSuccessor, sessId, "CloseCntrExInfoEvent Exception", lastEvents.toString(), resultInfo.getException(), new IApplication.DlgRunnable() {
            public void run(boolean confirmed) {
              EventCommandContainer.this.fg_ensureTerminatedAndCloseContainer(resultInfo.getException());
            }
          });

        } else if (ev instanceof CancelAndCloseImmediately) {
          if (this.containerClosed) {
            //  FX8 completely processed = cmd null? do not cmd.getSession()-> NPE, fop printing problem
            //  H2Forms par deploy while startup cmd in error and forwarding to next url
          } else {
            CancelAndCloseImmediately cce = ((CancelAndCloseImmediately) ev);
            List<IOFXProblem> problems = getSession().getAndclearProblemState();
            ListSequence.fromList(problems).addElement(new OFXProblem(cce.getMessage(), null, null));
            fg_cancelAndClose(cce.isUserCancel(), problems);
          }

        } else if (ev instanceof CancelAndClose) {
          CancelAndClose cc = ((CancelAndClose) ev);
          if (cc.isCloseQuestion()) {
            windowCrtl.askCloseQuestionDialog(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.SESSION_DIRTY), new IApplication.DlgRunnable() {
              public void run(boolean confirmed) {
                if (confirmed) {
                  fg_cancelAndClose(true, null);
                }
              }
            });

          } else {
            final List<IOFXProblem> prblms = ((CancelAndClose) ev).getProblems();
            windowCrtl.showProblemsDialog(prblms, new IApplication.DlgRunnable() {
              public void run(boolean confirmed) {
                EventCommandContainer.this.fg_cancelAndClose(false, prblms);
              }
            });
          }

        } else if (ev instanceof FlagOnUiEvent) {
          // noop

        } else if (ev instanceof GlobalCmdTermEvent) {
          GlobalCmdTermEvent gcte = (GlobalCmdTermEvent) ev;
          logEventAsMowareTrace = fg_handleGlobalCmdTerminate(gcte, (compoundCommand == null ? null : compoundCommand.getAutoConclusion()));

        } else if (ev instanceof RunLater) {
          RunLater rl = ((RunLater) ev);
          rl.exec();

        } else {
          throw new RuntimeException("This can not happen. Unknown event " + ev);
        }

        if (ev instanceof UxBgableEvent) {
          lastBgEventStartTime = evStartTime;
          lastBgEvent = ((UxBgableEvent) ev);

        } else if (logEventAsMowareTrace) {
          logEvent(ev, System.currentTimeMillis() - evStartTime);

        }
      }

    } catch (final Exception ex) {
      this.isStillOkayAsParentForMultiExecution = false;

      windowCrtl.showException(fullCmdNameAndSuccessor, sessId, "Exception while processing " + ev, lastEvents.toString(), ex, new IApplication.DlgRunnable() {
        public void run(boolean confirmed) {
          EventCommandContainer.this.fg_ensureTerminatedAndCloseContainer(ex);
        }
      });

    } finally {
      inLoop = false;

    }
  }

  public void logEvent(UxEvent ev, long diffTime) {
    HashMap<String, Object> params = new HashMap<String, Object>();
    params.put(CoreReporterInfo.DIFF, diffTime);

    if (ev instanceof InitCmdEvent) {
      app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "command initialized", ev.paramInfo(), params);

    } else if (ev instanceof OpenUiEvent) {
      params.put(CoreReporterInfo.PARAM, ev.paramInfo());
      params.put(CoreReporterInfo.MEM, Runtime.getRuntime().totalMemory() / 1048576);
      app.logMowareTracing(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, ev.name(), params);

    } else if (ev instanceof FlagOnUiEvent) {
      FlagOnUiEvent fe = ((FlagOnUiEvent) ev);
      if (ListSequence.fromList(fe.getMessage()).count() == 0) {
        throw new RuntimeException("this can not happen - flag on ui has 0 problems.");
      }

      for (int i = 0; i < ListSequence.fromList(fe.getMessage()).count(); i++) {
        IOFXProblem prblm = ListSequence.fromList(fe.getMessage()).getElement(i);

        HashMap<String, Object> copy = new HashMap<String, Object>(params);
        if (i > 0) {
          copy.remove(CoreReporterInfo.DIFF);
        }
        CoreReporterInfo.takeOverParamsIfNotNull(copy, prblm.getPropMapOrNull());

        app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "flag on ui (prblm " + (i + 1) + ")", prblm.getSimpleUserText(), copy);
      }


    } else if (ev instanceof ConclusionEvent) {
      app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "conclusion", ev.paramInfo(), params);

    } else if (ev instanceof CancelAndClose && !(((CancelAndClose) ev).isCloseQuestion())) {
      CancelAndClose ce = ((CancelAndClose) ev);
      if (ListSequence.fromList(ce.getProblems()).count() == 0) {
        throw new RuntimeException("this can not happen - CancelAndClose has 0 problems.");
      }

      for (int i = 0; i < ListSequence.fromList(ce.getProblems()).count(); i++) {
        IOFXProblem prblm = ListSequence.fromList(ce.getProblems()).getElement(i);

        HashMap<String, Object> copy = new HashMap<String, Object>(params);
        if (i > 0) {
          copy.remove(CoreReporterInfo.DIFF);
        }
        CoreReporterInfo.takeOverParamsIfNotNull(copy, prblm.getPropMapOrNull());

        app.logAppTrace(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, "close on ui (prblm " + (i + 1) + ")", prblm.getSimpleUserText(), copy);
      }

    } else {
      params.put(CoreReporterInfo.PARAM, ev.paramInfo());
      app.logMowareTracing(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EVENT, ev.name(), params);
    }

  }


  public void handle(Message busMsg) {
    // called by async bus thread.

    try {
      if (containerClosed) {
        long diff = System.currentTimeMillis() - containerClosedTimestamp;
        app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EB_HANDLER, "Rec. event '" + busMsg + "' althought container '" + this + "' closed " + diff + "ms ago.", null);
        return;
      }
      if (busMsg.isErrorMsg()) {
        app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EB_HANDLER, "EB BUS ERROR (from EB, but EB still running)", busMsg.getErrMessage() + " / " + busMsg.getErrFailureCode() + " / " + busMsg.getErrFailureType());
        return;
      }
      Json body = busMsg.getBodyAsMJson();
      if (!(body.has("type"))) {
        app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EB_HANDLER, "EB BUS ERROR (still running, received an unknown message with no type)", body.toString());
        return;
      }
      String type = body.at("type").asString();



      if ("requestLock".equals(type) || "locked".equals(type)) {
        // should we be subscribed?
        if (!(ebLockingActive)) {
          app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EB_HANDLER, "EB BUS ERROR (cmd still running: ebLockingNotActive, but receiving bus msgs)", body.toString());
          return;
        }

        String reqLockName = (body.has("lockName") ? body.at("lockName").asString().toLowerCase() : "");

        String reqUserName = (body.has("userName") ? body.at("userName").asString() : "");
        String reqDeviceName = (body.has("deviceName") ? body.at("deviceName").asString() : "");
        String reqDeviceId = (body.has("deviceId") ? body.at("deviceId").asString() : "");

        String reqUserInstanceName = (body.has("userInstanceName") ? body.at("userInstanceName").asString() : "");
        long reqTimestamp = (body.has("requestTimestamp") ? body.at("requestTimestamp").asLong() : 0);
        long reqId = (body.has("containerHash") ? body.at("containerHash").asLong() : 0);
        long reqLockTimestamp = (body.has("lockTimestamp") ? body.at("lockTimestamp").asLong() : 0);
        long reqAppStartup = (body.has("appStartup") ? body.at("appStartup").asLong() : 0);


        if (isRelevantLock(reqUserInstanceName, reqLockName)) {
          if ("requestLock".equals(type)) {

            long timeStampMillis = System.currentTimeMillis();
            long diff = timeStampMillis - ebLockRequestedTimestamp;

            if (Math.abs(diff) > 43200000) {
              // ignore ... some old session hanging around?
              app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.LOCKING, "Receiving relevant 'requestLock' (from " + reqUserName + " / " + reqLockName + "). We have an old session? " + LOCK_DBG_TIME_FRMT.print(ebLockRequestedTimestamp), "Diff between ebLockRequest and now " + diff);


            } else {
              uiFactory.getEventBus().publish("locking", createLockJson(reqLockName, timeStampMillis, reqId).set("type", "locked").set("lockTimestamp", ebLockRequestedTimestamp));

              HashMap<String, Object> paramsPayLoad = new HashMap<String, Object>();
              paramsPayLoad.put("lockName", reqLockName);
              paramsPayLoad.put("requestedBy", Json.object().set("userName", reqUserName).set("deviceName", reqDeviceName).set("deviceId", reqDeviceId));
              IOFXUserEnvironment env = getSession().getUserEnvironment();
              paramsPayLoad.put("heldBy", Json.object().set("userName", env.getUserName()).set("deviceName", env.getDeviceName()).set("deviceId", env.getDeviceId()));

              app.logMowareTracing(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.LOCKING, "sent lock not granted", paramsPayLoad);


            }

            long diffTime = timeStampMillis - reqTimestamp;
            if (diffTime > 4000) {
              app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.LOCKING, "Receiving relevant 'requestLock' (from " + reqUserName + " / " + reqLockName + ") took more than four sec. - (clocks synced?)", "Diff between req. and now " + diffTime);
            }


          } else if ("locked".equals(type) && reqId == this.hashCode()) {
            long diffTime = System.currentTimeMillis() - ebLockRequestedTimestamp;

            if (!(getSession().isLockedByOtherUser())) {
              String lockUserName = reqUserName + " " + reqDeviceName;
              getSession().setLockedByOtherUser(lockUserName);

              HashMap<String, Object> paramsPayLoad = new HashMap<String, Object>();
              paramsPayLoad.put("lockName", reqLockName);
              paramsPayLoad.put("heldBy", Json.object().set("userName", reqUserName).set("deviceName", reqDeviceName).set("deviceId", reqDeviceId));
              IOFXUserEnvironment env = getSession().getUserEnvironment();
              paramsPayLoad.put("requestedBy", Json.object().set("userName", env.getUserName()).set("deviceName", env.getDeviceName()).set("deviceId", env.getDeviceId()));

              app.logMowareTracing(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.LOCKING, "received lock not granted", paramsPayLoad);

              if (uiFactory.useBackgroundThread()) {
                app.getMainWindowImpl().execEventInForeground(this, new LockInfoEvent(lockUserName));
              } else {
                containerEventQueue.add(new LockInfoEvent(lockUserName));
              }

            } else {

              app.logMowareTracing(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.LOCKING, "Session already locked but received another lock not granted for " + reqLockName + " (held by " + reqUserName + " / " + reqDeviceId + ")", "lock hold since " + LOCK_DBG_TIME_FRMT.print(reqLockTimestamp) + " (appstart " + LOCK_DBG_TIME_FRMT.print(new DateTime(reqAppStartup)) + ") diffTime " + diffTime);
            }

          } else if ("locked".equals(type) && !(getSession().isLockedByOtherUser())) {
            // request hash code not matching.
            long diffTime = System.currentTimeMillis() - reqTimestamp;
            app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.LOCKING, "Received 'locked' for" + reqLockName + " (held by " + reqUserName + " / " + reqDeviceId + ") requested by " + reqId + " - but we are " + this.hashCode() + " (simultaneous open?)", "diff time request to now " + diffTime);

            // send another lock msg with original lock requester ID :)
          }


        }
      }


    } catch (Throwable t) {
      app.logFrmwrkProblem(fullCmdNameAndSuccessor, sessId, IOFXCoreReporter.EB_HANDLER, t, "Processing EventBus messages");

    }
  }


  public void ll(String eventName, String desc, String repr) {
    if (eventName.toLowerCase().contains("focus") || eventName.toLowerCase().contains("reeval")) {
      return;
    }

    System.err.println(String.format("%20s %s: %25s  %10s %s", fullCmdNameAndSuccessor, ("" + hashCode()).substring(0, 3), eventName, desc, repr));
  }
}
