package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import java.util.List;

public class GlobalCmdTermEvent extends UxEvent {
  private ICommandContainer cmdcrtl;
  private ICommandContainer parentCmdContainer;

  private boolean terminateOk;
  private boolean terminateUserCancel;
  private boolean terminateCancel;

  private boolean killParentGraphOwner;

  private boolean doNotReloadParentViewsOnFastMultiProcessing;

  private List<Object> selections;


  public GlobalCmdTermEvent(ICommandContainer aCmd, ICommandContainer parentCont, boolean killParentGO, boolean termOk, boolean termUserCancel, boolean termCancel, List<Object> selectns) {
    super();
    cmdcrtl = aCmd;
    parentCmdContainer = parentCont;
    killParentGraphOwner = killParentGO;

    terminateOk = termOk;
    terminateCancel = termCancel;
    terminateUserCancel = termUserCancel;
    selections = selectns;

    doNotReloadParentViewsOnFastMultiProcessing = false;


    if (termOk && (termCancel || termUserCancel)) {
      throw new IllegalStateException("ISE1: This can not happen " + termOk + " vs. " + termUserCancel + " / " + termCancel);

    } else if (termUserCancel && (termOk || termCancel)) {
      throw new IllegalStateException("ISE2: This can not happen " + termOk + " vs. " + termUserCancel + " / " + termCancel);

    }
  }


  public ICommandContainer getClosedContainer() {
    return cmdcrtl;
  }
  public ICommandContainer getParentOfClosed() {
    return parentCmdContainer;
  }
  public boolean iAmParent(ICommandContainer cmd) {
    return parentCmdContainer == cmd;
  }
  public List<Object> getCmdSelections() {
    // might be lenght 0
    return selections;
  }
  public boolean wasOk() {
    return terminateOk;
  }
  public boolean killParentGO() {
    return killParentGraphOwner;
  }
  public boolean wasCancelOrUserCancel() {
    // if terminatecancelbyEx there is always termcancel.
    return terminateCancel || terminateUserCancel;
  }
  public void setNotReloadViewsOnParent() {
    doNotReloadParentViewsOnFastMultiProcessing = true;
  }
  public boolean isNoReloadOnParent() {
    return doNotReloadParentViewsOnFastMultiProcessing;
  }

  public String paramInfo() {
    String type = (terminateOk ? " OK" : " NOT OK");
    if (terminateCancel) {
      type = " CANCEL";
    } else if (terminateUserCancel) {
      type = " USR CANCEL";
    }
    return cmdcrtl + " in " + type;
  }



}
