package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenPagePane;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.Selection;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;

public class PagePaneSelCrtl<T> extends SelectionController implements IPagePaneSelCrtl<T> {
  protected static final boolean NEW22_STRATEGY = true;
  public static final boolean NEW25_BOUNDTOPROPERTY = true;

  protected boolean COLLECT_SELECTIONS = false;


  protected List<T> loadedList = null;
  protected List<CmdAction> actions = null;
  protected ICommandContainer responsibleCommandContainer;
  protected int langIndexRequested;

  protected SelectionController lastSelCrtlAttachedTo = null;

  public PagePaneSelCrtl(ICommandContainer cmdContainer, IOFXPlatform plt, IGenPagePane genPagePane, Class selRootType, int langIndex) {
    super(null, null, selRootType, "");
    this.pagePaneCrtl = this;
    this.langIndexRequested = langIndex;

    responsibleCommandContainer = cmdContainer;

    loadedList = ListSequence.fromList(new ArrayList<T>());
    actions = ListSequence.fromList(new ArrayList<CmdAction>());

    COLLECT_SELECTIONS = cmdContainer.getUiFactory().getCollectSelections();
  }

  public void ensureFirstSelected() {
    if (ListSequence.fromList(loadedList).count() > 0) {
      if (!(ListSequence.fromList(loadedList).first().equals(this.selection.getObjectOrNull()))) {
        pushSelection(new Selection(ListSequence.fromList(loadedList).first()), true);
      }
    }
  }

  protected void exchangeObjectInList(final List<IOFXEntity> origList, List<IOFXEntity> objToReplace) {
    List<IOFXEntity> notFound = ListSequence.fromList(new ArrayList<IOFXEntity>());

    boolean found;
    // okay, we have to replace the object in current list viewed with the object given.
    for (IOFXEntity currentObj : objToReplace) {
      found = false;
      Object key = currentObj.getIM3Key();
      for (int i = 0; i < ListSequence.fromList(origList).count(); i++) {
        // replace it
        if (ListSequence.fromList(origList).getElement(i).getIM3Key().equals(key)) {
          ListSequence.fromList(origList).setElement(i, currentObj);
          found = true;
          break;
        }
      }

      // not found, mark it for later adding
      if (!(found)) {
        ListSequence.fromList(notFound).addElement(currentObj);
      }
    }

    if (ListSequence.fromList(notFound).count() > 0) {
      ListSequence.fromList(notFound).visitAll(new _FunctionTypes._void_P1_E0<IOFXEntity>() {
        public void invoke(IOFXEntity it) {
          ListSequence.fromList(origList).addElement(it);
        }
      });
    }

  }

  public void updateSelectionExchangeRootObjects(final IOFXSelection sel, boolean isExchangeinSearchCmd) {
    // legacy? is it ever null?
    if (sel == null) {
      return;
    }



    if (responsibleForSelectionType.equals(sel.getType())) {
      // prio 1: exchange directly
      if (isExchangeinSearchCmd) {
        exchangeObjectInList(((List<IOFXEntity>) loadedList), ((List<IOFXEntity>) sel.getObjects()));
      }
      // okay, search command handled. now do we have to update the selection
      this.selection = sel;

    } else if (isExchangeinSearchCmd && responsibleForSelectionType.isAssignableFrom(sel.getType())) {
      // prio 2: exchange in case assignable - only for search
      exchangeObjectInList(((List<IOFXEntity>) loadedList), ((List<IOFXEntity>) sel.getObjects()));
      this.selection = sel;

    } else if (isExchangeinSearchCmd) {
      // view object at search command?
      if (ListSequence.fromList(loadedList).count() == 1) {
        final IOFXEntity viewObject = ((IOFXEntity) ListSequence.fromList(loadedList).getElement(0));
        // replace anyway, does not matter if it is a viewobject or entity .. :)
        // okay, this is a view object
        final Wrappers._boolean straightHitStrongTyped = new Wrappers._boolean(false);

        // prio3: exchange type save if possible.
        ListSequence.fromList(dependentSelectionController).visitAll((it) -> {
          if (it.responsibleForSelectionType.equals(sel.getType()) && !(it.boundToProperty.equals(""))) {
            // bountType matches expected type.
            Object l = MoJSON.get(viewObject, it.boundToProperty);
            if (l instanceof List) {
              exchangeObjectInList(((List<IOFXEntity>) l), ((List<IOFXEntity>) sel.getObjects()));
              it.selection = sel;
              straightHitStrongTyped.value = true;
            }
          }
        });

        // prio4: if not exchanged, check assignable situation
        if (!(straightHitStrongTyped.value)) {
          ListSequence.fromList(dependentSelectionController).visitAll((it) -> {
            if (it.responsibleForSelectionType.isAssignableFrom(sel.getType()) && !(it.boundToProperty.equals(""))) {
              // bountType matches expected type.
              Object l = MoJSON.get(viewObject, it.boundToProperty);
              if (l instanceof List) {
                exchangeObjectInList(((List<IOFXEntity>) l), ((List<IOFXEntity>) sel.getObjects()));
                it.selection = sel;
              }
            }
          });

        }
      }

    } else if (!(isExchangeinSearchCmd)) {
      // then we have to push, eval will follow in reloadViews()
      pushSelection(sel, true);
    }


  }


  @Override
  public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate issuer) {
    responsibleCommandContainer.receiveAndProcess(new ConclusionEvent(1, "UPDATE"));
  }

  @Override
  public void pushSelectionAbsolute(IOFXSelection selection) {
    // Called by table to update selection here.
    super.pushSelection(selection, true);

    ListSequence.fromList(actions).visitAll((it) -> it.reevalEnabled());
    // also check current Wiz
    responsibleCommandContainer.receiveAndProcess(new ReevalEvent());
  }

  public void reloadViews() {

    // simply update mainListView, pass in selection
    ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        it.loadList(loadedList, selection);
      }
    });

    if (selection != null && selection.isSingleObject()) {
      ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.reload(selection.getObjectOrNull()));
    } else {
      ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.reload(null));
    }

    // eval actions and conclusion buttons
    ListSequence.fromList(actions).visitAll((it) -> it.reevalEnabled());
    responsibleCommandContainer.receiveAndProcess(new ReevalEvent());
  }

  @Override
  public ISelectionController registerSelControlled(Class interestedInSelection, ISelectionController.Binding binding, IGenSelControlled viewToRegister) {


    ISelectionController localController = super.registerSelControlled(interestedInSelection, binding, viewToRegister);
    lastSelCrtlAttachedTo = ((SelectionController) localController);

    if (localController == null) {
      throw new IllegalArgumentException("View " + viewToRegister.getClass().getName() + " interested in Selections of " + interestedInSelection.getName() + " and binding ['" + binding.getClassType() + "." + binding.getProperty() + "] could not be registered in SelController hierarchy.\n\nCURRENT GRAPH:\n" + this.getControllersInfo() + "\n\n");

    }
    return localController;
  }

  @Override
  public IOFXSelection getSelectionAbsolute(Class type, boolean includingDerived) {
    IOFXSelection sel = super.getSelection(type, includingDerived);
    if (sel == null) {
      throw new IllegalStateException("No selection object available for type " + type.getName());
    }
    return sel;
  }


  public void addLoadedListReference(List<?> objects) {
    // no longer necessary, done during GEN time

    ListSequence.fromList(loadedList).clear();
    ListSequence.fromList(loadedList).addSequence(ListSequence.fromList(((List<T>) objects)));

    // (1) now do not clear a selection. developer might has used a
    // form.pushSelection() in pageInit in order to set selection on purpose

    if (ListSequence.fromList(loadedList).count() == 1) {
      // (2) we need to push a selection if loaded size is one
      // due to delegateForm binding, right?

      Object objToLoad = ListSequence.fromList(loadedList).getElement(0);
      if (objToLoad.getClass().equals(responsibleForSelectionType)) {
        // the same ..
        this.pushSelection(new Selection(ListSequence.fromList(loadedList).getElement(0)), false);

      } else if (responsibleForSelectionType.isAssignableFrom(objToLoad.getClass())) {
        Selection s = new Selection(responsibleForSelectionType);
        s.setObject(objToLoad);
        this.pushSelection(s, false);

      } else {
        throw new RuntimeException("Can not load object " + objToLoad.getClass() + " to PagePane expecting " + responsibleForSelectionType);

      }
    }
    reloadViews();
  }


  public List<String> getGlobalHotkeys() {
    return ListSequence.fromList(actions).where((it) -> it.globalHotkey && !(it.hotKey.equals(""))).select((it) -> it.hotKey).toList();
  }

  public void onGlobalKeyPressEvent(String key) {
    for (CmdAction action : actions) {
      if (action.globalHotkey && key.equals(action.hotKey) && action.reevalEnabled()) {
        action.startCommand();
        return;
      }
    }
  }

  public void addActionAndInjectDependencies(Menu menu, ISelectionController localSelectionCrtl) {

    for (CmdAction action : menu.getAllCmdActionsOfMenu()) {
      action.configure(responsibleCommandContainer.getUiFactory(), responsibleCommandContainer, localSelectionCrtl, langIndexRequested);
      ListSequence.fromList(actions).addElement(action);
    }

    for (Menu sub : menu.getAllPlainMenus()) {
      if (sub.labelText != null) {
        sub.configureLabel(responsibleCommandContainer.getUiFactory().getTransProvider().translateSingle(langIndexRequested, sub.labelText));
      }
    }
  }

  public int getLangIndexRequested() {
    return langIndexRequested;
  }

  public List<T> getLoadedList() {
    return loadedList;
  }

  public ICommandContainer getResponsibleContainer() {
    // used in pl driver only.
    return responsibleCommandContainer;
  }


  @Override
  public void gcClear() {
    ListSequence.fromList(this.actions).visitAll((it) -> it.gcClear());
    this.responsibleCommandContainer = null;
    ListSequence.fromList(this.loadedList).clear();
    this.loadedList = null;
    ListSequence.fromList(this.actions).clear();
    this.actions = null;
    super.gcClear();
  }
}
