package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRange;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class IntegerDelegate extends Delegate<Integer, IToolkit_TextEditor> {

  protected MetaInfoLocalVar<Integer> min = new MetaInfoLocalVar<Integer>(null);
  protected MetaInfoLocalVar<Integer> max = new MetaInfoLocalVar<Integer>(null);

  public IntegerDelegate(IToolkit_UiFactory factory, int langIdx) {
    super(factory, langIdx);
    toolkitEditor = factory.createTextEditor();
    toolkitEditor.setDelegate(this);
  }

  public Integer getValue() {
    if (isCurrentlyInOptionalState()) {
      return 0;
    }
    return Integer.parseInt(toolkitEditor.getText());
  }
  public void setValue(Integer value) {
    if (value != null) {
      toolkitEditor.setText(value.toString());
    } else {
      toolkitEditor.setText("");
    }
  }

  @Override
  public void load(Object obj) {
    super.load(obj);

    if (metaInfo != null) {
      IOFXMetaRange<Integer> m = ((IOFXMetaRange<Integer>) metaInfo);

      min.setValue(m.getMin());
      max.setValue(m.getMax());
    }
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }

    String errText = null;
    try {
      toolkitEditor.setValidationErrorText("");

      if (isCurrentlyInOptionalState()) {
        // ok this is  an optional integer value, if user enters nothing, return 0
        return null;
      }

      // might raise an exception
      int value = Integer.parseInt(toolkitEditor.getText());

      // check min max stuff here ..
      if (min.isValueSet() && max.isValueSet()) {
        if (value < min.getValue() || value > max.getValue()) {
          errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_BETWEEN_ERR), min.getValue().toString(), max.getValue().toString());
        }
      } else if (min.isValueSet()) {
        if (value < min.getValue()) {
          errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_MINIMUM_ERR), min.getValue().toString());
        }
      } else if (max.isValueSet()) {
        if (value > max.getValue()) {
          errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DECIMAL_MAXIMUM_ERR), max.getValue().toString());
        }
      }

    } catch (Exception ex) {
      errText = uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.INTEGER_VALIDATION_ERR);

    }

    if (errText != null) {
      toolkitEditor.setValidationErrorText(errText);
    }

    return errText;
  }


  public void setMaximum(int maxValue) {
    max.setValue(maxValue);
    max.setReadOnly();
  }

  public void setMinimum(int minValue) {
    min.setValue(minValue);
    min.setReadOnly();
  }

  @Override
  public void setFormat(String frmt) {
    frmt = frmt.toLowerCase().replace("no0", "");
    super.setFormat(frmt);
  }


}
