package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_StatusEditor;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class StatusDelegate extends Delegate<IOFXMetaStatus.IOFXStatusElement, IToolkit_StatusEditor> {
  public String statusOptionalItemText = ReferenceDelegate.GENERAL_OPTIONAL_ITEM_TEXT;

  private IOFXMetaStatus.IOFXStatusElement[] elements;
  private List<String> currentDelegateLabels;

  public StatusDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option... alterOptions) {
    super(factory, langIdx);

    toolkitEditor = factory.createStatusEditor(IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, alterOptions));
    // parrent handles that as a textEditor
    // however, we have to access it as a status editor.
    toolkitEditor.setDelegate(this);
  }

  public IOFXMetaStatus.IOFXStatusElement getValue() {
    int selIdx = toolkitEditor.getSelectedIndex();

    if (selIdx < elements.length) {
      return elements[selIdx];

    } else if (selIdx == elements.length && optional.getValue()) {
      return null;

    }

    throw new RuntimeException("getValue() with selected-index '" + selIdx + "' called but index does not suit elements length " + elements.length + " on property " + propertyName + "(or +1 while optional is " + optional.getValue() + ")");
  }
  public void setValue(IOFXMetaStatus.IOFXStatusElement value) {
    if (elements == null && value == null) {
      // might happen on flag in page init. no values at all
      return;
    }

    List<String> labels = ListSequence.fromList(new ArrayList<String>());
    int selectedIndex = -1;
    for (int i = 0; i < elements.length; i++) {
      if (SaveObjectComperator.equals(elements[i], value)) {
        selectedIndex = i;
      }
      if (elements[i] == null) {
        throw new RuntimeException("One of the status elements (index " + i + ") is null. This is not allowed. Scope not correct.");
      }
      ListSequence.fromList(labels).addElement(uiFactory.getTransProvider().translateSingle(langIndex, elements[i].getLongDesc()));
    }

    //  allow for null values, when not enabled, e.g. DelegateForm bound to Table, no selection
    if (optional.getValue() || (value == null && !(enabled.getValue()))) {
      ListSequence.fromList(labels).addElement(statusOptionalItemText);
      if (value == null) {
        selectedIndex = ListSequence.fromList(labels).count() - 1;
      }
    }

    if (!(ReferenceDelegate.sameContent(labels, currentDelegateLabels))) {
      currentDelegateLabels = labels;
      toolkitEditor.setItems(labels);
    }


    if (selectedIndex == -1) {
      throw new RuntimeException("setValue() with '" + value + "' but enabled elements are restricted to " + labels + " and Editor is enabled.");
    }

    if (selectedIndex >= ListSequence.fromList(labels).count()) {
      throw new RuntimeException("setValue() with '" + value + "' called. Index " + selectedIndex + " exceeds items list length " + labels + " on property " + propertyName + "(optional is " + optional.getValue() + ")");
    }

    toolkitEditor.setSelectedIndex(selectedIndex);
  }

  @Override
  public void load(Object obj) {
    if (propertyName != null) {

      metaInfo = MoJSON.get(obj, Delegate.getMetaDataAccessorToPath(propertyName));
      // check optional and enabled ..
      if (metaInfo != null) {
        IOFXMetaStatus<IOFXMetaStatus.IOFXStatusElement> m = ((IOFXMetaStatus) metaInfo);
        elements = m.getElements();
      }
    }

    super.load(obj);
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");

    // do not call isCurrentlyInOptional state, since an item is added anyway and
    // that method will call getText() what is not implemented for ComboBoxes ..
    String errText = null;

    if (toolkitEditor.getSelectedIndex() < 0) {
      errText = uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.STATUS_VALIDATION_ERR);
      toolkitEditor.setValidationErrorText(errText);
    }
    return errText;
  }


  @Override
  public void setOptionalText(String text) {
    if (text != null) {
      // optional text is not translated, one should move the translationProvider out of the GEN anyway
      statusOptionalItemText = text.trim();
    }
  }
}
