package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.modellwerkstatt.dataux.runtime.extensions.ITableRowColor;
import java.text.ParseException;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;

public class TableCellBigDecimalConverter implements ITableCellStringConverter<BigDecimal> {
  private boolean doNotDisplayZeroValue = false;
  private DecimalFormat privatFormatter;
  private ITableRowColor<BigDecimal> colorConv;

  public TableCellBigDecimalConverter(DecimalFormat formatter, boolean noNullOption) {
    privatFormatter = formatter;
    doNotDisplayZeroValue = noNullOption;
  }
  public TableCellBigDecimalConverter(DecimalFormat formatter, boolean noNullOption, ITableRowColor<BigDecimal> colConv) {
    privatFormatter = formatter;
    doNotDisplayZeroValue = noNullOption;
    colorConv = colConv;
  }

  public String convert(BigDecimal obj) {
    if (obj == null) {
      return "";
    }
    if (doNotDisplayZeroValue && BigDecimal.ZERO.compareTo(obj) == 0) {
      return "";
    }
    return privatFormatter.format(obj);
  }

  public boolean isRightAligned() {
    return true;
  }

  public String getBgColor(BigDecimal obj) {
    if (colorConv != null) {
      return colorConv.getColor(obj);
    }
    return null;
  }

  @Override
  public boolean hasDynamicColor() {
    return colorConv != null;
  }
  public BigDecimal convertBack(String s) {
    try {
      return ((BigDecimal) privatFormatter.parse(s));
    } catch (ParseException e) {
      throw new RuntimeException(e);
    }
  }

  public String formatterToLocalizedPattern() {
    return privatFormatter.toLocalizedPattern();
  }

  public static void main(String[] args) {
    TableCellBigDecimalConverter c = new TableCellBigDecimalConverter(MoWareFormattersFactory.forDecimalFormatPattern("#,##0.00", "de"), false);
    BigDecimal b = new BigDecimal("1111.10");
    System.err.println(">> " + c.convert(b));
    System.err.println(">> " + b.toString());
    System.err.println(">> " + c.formatterToLocalizedPattern());
  }
}
