package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import java.util.Map;

public class TableCellStatusConverter<T extends IOFXMetaStatus.IOFXStatusElement<T>> implements ITableCellStringConverter<IOFXMetaStatus.IOFXStatusElement<T>> {
  private IOFXMetaStatus.IOFXStatusElement<T> defaultStatus;
  private Map<Integer, String> tranLationMap;

  public TableCellStatusConverter(IOFXMetaStatus.IOFXStatusElement<T> dflt, Map<Integer, String> descTranslationMap) {
    defaultStatus = dflt;
    tranLationMap = descTranslationMap;

  }

  public String convert(IOFXMetaStatus.IOFXStatusElement<T> obj) {
    // returns empty string, since representation is not related to optional option 
    if (obj == null) {
      return "";
    }
    return tranLationMap.get(obj.getDbValue().hashCode());
  }
  public boolean isRightAligned() {
    return false;
  }
  public String getBgColor(IOFXMetaStatus.IOFXStatusElement<T> obj) {
    if (obj == null) {
      return null;
    }
    return obj.getColor();
  }
  public IOFXMetaStatus.IOFXStatusElement<T> convertBack(String shortText) {
    for (T t : defaultStatus.getAllStatusElements()) {
      String translatedText = tranLationMap.get(t.getDbValue().hashCode());
      if (translatedText.equals(shortText)) {
        return t;
      }
    }
    return null;
  }

  public T[] getAllElements() {
    // in case full info is needed for colors (eg. vaadin)
    //  use other methods if not necessary
    return defaultStatus.getAllStatusElements();
  }



  @Override
  public String[] getColorMapOrNull() {
    boolean hasColor = false;

    T[] allStati = defaultStatus.getAllStatusElements();

    for (T sta : allStati) {
      if (sta.hasColor()) {
        hasColor = true;
        break;
      }
    }


    if (hasColor) {

      String[] colors = new String[allStati.length];
      int idx = 0;
      for (T sta : allStati) {
        if (sta.hasColor()) {
          colors[idx++] = sta.getColor();
        }
      }
      return colors;


    } else {
      return null;
    }
  }
}
