package org.modellwerkstatt.dataux.runtime.extensions;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;
import org.modellwerkstatt.dataux.runtime.core.BindingImpl;
import org.modellwerkstatt.dataux.runtime.core.IPagePaneSelCrtl;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;

public abstract class DynamicListOfDelegates<T> implements IUpdateConclusionReceiver, ICustomDataUxElement<T> {


  private IToolkit_DelegateForm uiDelegateForm;
  private IToolkit_UiFactory uiFactory;
  private T boundObject = null;
  protected List<IDataUxDelegate> delegates;
  private ISelectionController selController;
  private Class boundClass;
  private boolean delegatesCreated;



  public DynamicListOfDelegates(Class theBoundClass) {
    delegates = ListSequence.fromList(new ArrayList<IDataUxDelegate>());
    boundClass = theBoundClass;
    delegatesCreated = false;
  }
  public IToolkit_Form getToolkitImplementation() {
    return uiDelegateForm;
  }
  public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate newFocusHolder) {
    throw new RuntimeException("issueUpdateConclusion() not implemented");
  }
  public void loadDataOnDelegates(T theBoundObject) {
    for (IDataUxDelegate dlgt : delegates) {
      dlgt.load(theBoundObject);
    }
  }
  public void storeDataFromDelegates(T theBoundObject) {
    for (IDataUxDelegate dlgt : delegates) {
      dlgt.store(theBoundObject);
    }
  }

  public void loadObjectToForm(T objectToLoad) {
    boolean sameObjectLoadedTwice = false;

    if (!(delegatesCreated)) {
      delegatesCreated = true;
      createDelegatesOnFirstDataLoad(uiFactory, objectToLoad);
      for (IDataUxDelegate dlgt : delegates) {
        uiDelegateForm.addDelegate(dlgt);
      }
    }

    if (objectToLoad != null && boundObject == objectToLoad) {
      sameObjectLoadedTwice = true;
    }
    boundObject = ((T) objectToLoad);
    IUpdateConclusionReceiver.IFocusAbleDelegate lastFocussed = delegateWithFocus();
    for (IDataUxDelegate dlgt : delegates) {
      dlgt.setRequestFocus(false);
    }

    loadDataOnDelegates(boundObject);

    IUpdateConclusionReceiver.IFocusAbleDelegate manualMarkFocussed = delegateWithFocus();

    if (sameObjectLoadedTwice && manualMarkFocussed == null && lastFocussed != null) {
      if (lastFocussed.isEnabled()) {
        lastFocussed.setRequestFocus(true);
      }
    }
  }
  public IUpdateConclusionReceiver.IFocusAbleDelegate delegateWithFocus() {
    // Dan Mrsl 16: refactor that once...
    for (IDataUxDelegate dlgt : delegates) {
      if (dlgt.isRequestFocus()) {
        return dlgt;
      }
    }
    return null;
  }

  public String saveAndValidate() {
    boolean validationError = false;
    String errText = uiDelegateForm.checkDelegatesValidAndFocus();
    if (errText == null) {
      this.storeDataFromDelegates(boundObject);
    }

    // ok - no problem :)
    return errText;
  }
  @Override
  public List<IDelegateChange> collectDelegateChanges() {
    return null;
  }
  public void forceNotEditable() {
    for (IDataUxDelegate dlgt : delegates) {
      dlgt.setDisableFORCE();
    }
  }
  public void clear() {
    // clear delegate form, i.e. remove all content ...
    loadObjectToForm(null);
  }
  public void loadList(List<T> objects, IOFXSelection selection) {
    if (selection != null) {
      // loadList could be called, when reload() is executed .. update form..
      // therefore always execute loadList ...
      if (selection.size() == 1) {
        loadObjectToForm(((T) selection.getObject()));
      } else {
        // check advanced binding! BoundType: Aufgabe / SelectedClass: Aufgabe
        // if we receive a list with one object but we do not have a selection right now. automatically select.
        if (objects.size() == 1) {
          // in forms3 this features was only enables, if a type and a selectedClass was specified
          // dataux always uses a selectedClass..
          selController.pushSelectionAbsolute(new Selection(objects.get(0)));

        } else {
          clear();
        }
      }
    }
  }
  public void pushSelection(IOFXSelection selection) {
    selController.pushSelectionAbsolute(selection);
  }
  public boolean selectionChanged(IOFXSelection selection, boolean doNoLoadReloadFollows) {
    if (selection.size() != 1) {
      clear();
    } else
    if (!(doNoLoadReloadFollows)) {
      // check map_DelegateForm
      loadObjectToForm(((T) selection.getObject()));
    }
    return true;
  }
  public IOFXSelection getSelection(Class clazz, boolean includingDerived) {
    return selController.getSelectionAbsolute(clazz, includingDerived);
  }

  public abstract List<String> getColumnConstraints();
  public abstract BindingImpl getBinding();
  public abstract void createDelegatesOnFirstDataLoad(IToolkit_UiFactory factory, T boundObject);

  public void initializeGen(IToolkit_UiFactory factory, IPagePaneSelCrtl pageCrtl, ISelectionController.Binding externalBinding, Menu externalMenu) {
    uiFactory = factory;
    uiDelegateForm = factory.createToolkitDelegateForm();
    uiDelegateForm.setColLayoutConstraints(getColumnConstraints());

    // external Binding can be ignored with DelegateFrom?
    // except we use inheritance include ExtRechnung RechnungUi ?
    if (externalBinding != null) {
      selController = pageCrtl.registerSelControlled(boundClass, externalBinding, this);
    } else {
      selController = pageCrtl.registerSelControlled(boundClass, getBinding(), this);
    }
  }

  @Override
  public void addDelegateInfo(String delegateName, String path, String label) {
  }

  public void gcClear() {
    for (IDataUxDelegate dlgt : delegates) {
      dlgt.gcClear();
    }
    uiFactory = null;
    selController = null;
    boundObject = null;
    uiDelegateForm = null;
  }
}
