package org.modellwerkstatt.dataux.runtime.genspecifications;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.dataux.runtime.core.IEventProcessor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_EnableItem;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.MultiCmdStart;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public abstract class CmdAction extends AbstractAction {
  public IOFXCmdModule cmdModule;
  public IEventProcessor eventProcessor;

  protected IToolkit_EnableItem uiButton_1;
  protected IToolkit_EnableItem uiButton_2;

  protected IOFXDynCmdParams nonDefaultDynParamCreator;
  protected ISelectionController localSelCrtl;

  protected boolean gcCleanCalled;

  protected boolean multiGoOnWhenCanceled;
  protected boolean multiFastExecNoUi;
  protected boolean multicanPotentiallyExecWhenMultiSelection;

  public String commandFqName;
  public String image;
  public String hotKey;
  public String toolTip;
  public boolean globalHotkey;
  public boolean hideWhenDisabled;
  public boolean urlEnabledCmd;
  public boolean isGraphEdit;

  public boolean DEBUG = false;

  public CmdAction(String cmdName, String customLabel, boolean globalHk, IOFXDynCmdParams selProv, boolean goOnWhenCanceled, boolean fastExecNoUi, boolean canPotentiallyMultiSelect) {
    super(customLabel);
    nonDefaultDynParamCreator = selProv;
    commandFqName = cmdName;
    globalHotkey = globalHk;


    multiGoOnWhenCanceled = goOnWhenCanceled;
    multiFastExecNoUi = fastExecNoUi;
    multicanPotentiallyExecWhenMultiSelection = canPotentiallyMultiSelect;

    toolTip = "";
    hideWhenDisabled = false;
    gcCleanCalled = false;

  }

  public CmdAction(String cmdName, boolean globalHk, IOFXDynCmdParams selProv, boolean goOnWhenCanceled, boolean fastExecNoUi, boolean canPotentiallyMultiSelect) {
    // use cmd defaults pls
    this(cmdName, null, globalHk, selProv, goOnWhenCanceled, fastExecNoUi, canPotentiallyMultiSelect);
  }

  public boolean noLabelSet() {
    return labelText == null;
  }

  public void configure(IToolkit_UiFactory factory, IEventProcessor processor, ISelectionController localSel, int langIdx) {
    localSelCrtl = localSel;
    cmdModule = factory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(commandFqName));
    eventProcessor = processor;

    IOFXTranslationProvider tranProvider = factory.getTransProvider();
    IOFXPlatform platform = factory.getPlatform();

    if (noLabelSet()) {
      String defaultLabel = cmdModule.getCommandDefaultLabel(commandFqName);
      labelText = tranProvider.translateSingle(langIdx, defaultLabel);
      image = cmdModule.getCommandDefaultIcon(commandFqName);
      hotKey = cmdModule.getCommandDefaultHotkey(commandFqName);
      hideWhenDisabled = false;

    } else {
      String platformKey = labelText;
      labelText = tranProvider.translateSingle(langIdx, platform.getTextForLabel(platformKey));
      image = platform.getIconForLabel(platformKey);
      hotKey = platform.getHotKeyForLabel(platformKey);
      hideWhenDisabled = platform.isHideOnDisabledForLabel(platformKey);
    }

    toolTip = cmdModule.getCommandToolTip(commandFqName);
    isGraphEdit = cmdModule.isCommandType(commandFqName, IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD);
  }



  public void attachButton1(IToolkit_EnableItem item) {
    uiButton_1 = item;
  }

  public void attachButton2(IToolkit_EnableItem item) {
    uiButton_2 = item;
  }

  public ISelectionController getLocalSelController() {
    return localSelCrtl;
  }
  public void adjustTooltipToCmd(IToolkit_UiFactory factory, String fqName) {
    IOFXCmdModule innerProc = factory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(fqName));
    toolTip = innerProc.getCommandToolTip(fqName);
  }
  public String getToolTip() {
    return toolTip;
  }

  public boolean checkForMultiSelection(IOFXCmdModule proc, String cmdFqName, IOFXSelection localSelection) {
    // any options left?
    if (!(canPotentiallyExecWhenMultiSelection())) {
      return false;
    }
    Object[] params;
    List<Object> objs = localSelection.getObjects();
    IOFXCmdModule.CmdExecStrategy strategy = (canPotentiallyExecWhenMultiSelection() ? IOFXCmdModule.CmdExecStrategy.AUTO_CON_MULTI : IOFXCmdModule.CmdExecStrategy.MULTI);

    for (Object o : objs) {
      params = this.calculateParams(o);
      if (params == null) {
        return false;
      }
      IOFXCmdModule.CommandPermission x = proc.getCommandPermission(strategy, cmdFqName, params, eventProcessor.getSession());
      if (x == IOFXCmdModule.CommandPermission.DISABLED) {
        return false;
      }
    }
    return true;
  }


  public boolean reevalEnabled() {
    // calculate enabled here ...
    boolean enabled = false;

    Object[] params = this.calculateParams(null);
    if (params != null) {
      enabled = cmdModule.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, commandFqName, params, eventProcessor.getSession()) != IOFXCmdModule.CommandPermission.DISABLED;
    } else {
      IOFXSelection tmpLocalSelection = localSelCrtl.getLocalSelection();
      if (tmpLocalSelection != null && tmpLocalSelection.size() > 0) {
        enabled = checkForMultiSelection(cmdModule, commandFqName, tmpLocalSelection);
      }

    }


    if (uiButton_1 != null) {
      uiButton_1.setItemEnabled(enabled);

    }
    if (uiButton_2 != null) {
      uiButton_2.setItemEnabled(enabled);

    }
    return enabled;
  }


  @Override
  public String toString() {
    return "Action '" + labelText + "' (" + commandFqName + ")";
  }


  public Object[] calculateParams(Object singleSelToReplace) {
    if (nonDefaultDynParamCreator != null) {
      return nonDefaultDynParamCreator.calc(localSelCrtl, singleSelToReplace);
    }
    return cmdModule.getCommandDefaultParams(commandFqName, localSelCrtl, singleSelToReplace);
  }

  public BasisCmdStart configCompoundOuterCmdStartOrJustBasisCmdStart(Object[] singleExecParams) {
    return new BasisCmdStart(commandFqName, singleExecParams);
  }

  public void startCommand() {
    try {
      // here, command can be startet by SINGLE, MULTI or MULTI_AUTO_CON
      IOFXSelection sel = localSelCrtl.getLocalSelection();

      // simple menuaction, no autocon, no compound
      if (sel != null && sel.size() >= 2 && canPotentiallyExecWhenMultiSelection()) {
        BasisCmdStart prototype = configCompoundOuterCmdStartOrJustBasisCmdStart(null);
        prototype.setLabelText(labelText);

        MultiCmdStart multi = new MultiCmdStart(prototype, sel.getObjects(), localSelCrtl, nonDefaultDynParamCreator);
        if (multiGoOnWhenCanceled) {
          multi.enable_goOnWhenCanceled();
        }
        if (multiFastExecNoUi) {
          multi.enable_fastExecNoUi();
        }
        eventProcessor.receiveAndProcess(multi);

      } else {
        Object[] localParams = calculateParams(null);
        BasisCmdStart ev = configCompoundOuterCmdStartOrJustBasisCmdStart(localParams);
        ev.setLabelText(labelText);

        eventProcessor.receiveAndProcess(ev);
      }

    } catch (Exception ex) {
      OFXLogger.log(CmdAction.class, IOFXCoreReporter.LogPriority.ERROR, "EXCEPTION occured in " + this.getClass().getSimpleName() + ".startCommand() for " + commandFqName + "\n" + ex.getClass().getName() + ": " + ex.getMessage() + "\n" + OFXConsoleHelper.stackTrace2String(ex), null);

    }

  }

  public boolean canPotentiallyExecWhenMultiSelection() {
    return multicanPotentiallyExecWhenMultiSelection;
  }

  public void gcClear() {
    gcCleanCalled = true;
    this.cmdModule = null;
    this.eventProcessor = null;
    this.uiButton_1 = null;
    this.uiButton_2 = null;
    this.localSelCrtl = null;
    this.nonDefaultDynParamCreator = null;
  }
}
