package org.modellwerkstatt.dataux.runtime.genspecifications;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxElementHook;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import java.util.Arrays;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.Selection;

public abstract class DelegateForm<T> implements IUpdateConclusionReceiver, IGenSelControlled<T> {
  protected IToolkit_DelegateForm uiDelegateForm;
  protected IDataUxElementHook dataUxElementHook;
  protected ISelectionController selController;
  protected IUpdateConclusionReceiver.IFocusAbleDelegate updateIssuer;

  protected IDataUxDelegate[] boundDelegates;
  protected T boundObject = null;
  protected boolean readOnly = false;
  protected List<IDelegateChange> delegateChanges = null;
  protected Class contentClass;
  protected boolean boundWithProperty;

  public DelegateForm(Class cc, boolean rd) {
    contentClass = cc;
    readOnly = rd;
  }


  @Override
  public IToolkit_Form getToolkitImplementation() {
    return uiDelegateForm;
  }
  public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate issuer) {
    updateIssuer = issuer;
    selController.issueUpdateConclusion(issuer);
  }
  public void preDelayedAfterFullUiInitialized() {
  }
  public void loadDelegatesWithBoundObject() {
    for (IDataUxDelegate dlgt : boundDelegates) {
      dlgt.load(boundObject);
    }
  }
  public IUpdateConclusionReceiver.IFocusAbleDelegate delegateWithFocus() {
    for (IDataUxDelegate dlgt : boundDelegates) {
      if (dlgt.isRequestFocus()) {
        return dlgt;
      }
    }
    return null;
  }

  public void loadObjectToForm(T objectToLoad) {
    delegateChanges = null;

    // same object is loaded twice in case of a new cmd/page load
    // but not after issuing a update conclusion :)
    boundObject = objectToLoad;
    for (IDataUxDelegate dlgt : boundDelegates) {
      dlgt.setRequestFocus(false);
    }
    // then bind object to fields, read meta information including focus info.
    loadDelegatesWithBoundObject();

    IUpdateConclusionReceiver.IFocusAbleDelegate markedByProgrammer = delegateWithFocus();

    if (markedByProgrammer == null && updateIssuer != null) {
      updateIssuer.setRequestFocus(true);
      loadDelegatesWithBoundObject();
    }
    updateIssuer = null;

    if (dataUxElementHook != null) {
      dataUxElementHook.boundObjectLoadedOrNull(boundObject);
    }
  }
  public void store(Object object) {
    // first onStore - maybe a exception is thrown there
    IDelegateChange change;

    for (IDataUxDelegate dlgt : boundDelegates) {
      change = dlgt.store(boundObject);
      if (change != null) {
        if (delegateChanges == null) {
          delegateChanges = new ArrayList<IDelegateChange>();
        }
        delegateChanges.add(change);
      }
    }
  }

  public String saveAndValidate() {
    String errText = null;
    if (!(readOnly)) {
      errText = uiDelegateForm.checkDelegatesValidAndFocus();
      if (errText == null) {
        this.store(boundObject);
      }
    }
    return errText;
  }
  public List<IDelegateChange> collectDelegateChanges() {
    return delegateChanges;
  }
  public void forceNotEditable() {
    this.readOnly = true;
    for (IDataUxDelegate dlgt : boundDelegates) {
      dlgt.setDisableFORCE();
    }
    if (dataUxElementHook != null) {
      dataUxElementHook.forceNotEditable();
    }
  }

  public void clear() {
    // clear delegate form, i.e. remove all content ...
    loadObjectToForm(null);
  }

  public void setBoundDelegates(IDataUxDelegate... delegates) {
    boundDelegates = delegates;
  }

  public void installDataUxDelegateHook(IToolkit_UiFactory factory, String fqName) {
    dataUxElementHook = ((IDataUxElementHook) factory.getNewClassInstanceByFQName(fqName));
    dataUxElementHook.initialize(selController, Arrays.<IDataUxDelegate>asList(boundDelegates));
  }

  public boolean selectionChanged(IOFXSelection selection, boolean doNotLoadReloadFollows) {

    if (boundWithProperty) {
      // ignore, when bound with a property Parent.childProperty, we should listen on Parent and then get the childProperty from there. NEW 2025. No cases known, when logic is contrary 

    } else if (selection.size() != 1) {
      clear();

    } else if (!(doNotLoadReloadFollows)) {
      // ? DEPRECATED if(boundObject != selection.getObject() ....... DAN WINTER 21
      // ? double selection of an object should not issue a ui load (update)
      // ? since for update purpose loadList() has to be used ... Dan Jan 2012

      // ok, it was a single object
      loadObjectToForm((T) selection.getObject());
    }

    return true;
  }

  public void loadList(List<T> objects, IOFXSelection selection) {

    // if (selection != null) removed, 2025 - complete block below 

    // loadList could be called, when reload() is executed .. update form..
    // therefore always execute loadList ...
    if (selection.size() == 1) {
      loadObjectToForm((T) selection.getObject());

    } else {
      // check advanced binding! BoundType: Aufgabe / SelectedClass: Aufgabe
      // if we receive a list with one object but we do not have a selection right now. automatically select.

      if (ListSequence.fromList(objects).count() == 1) {
        if (boundWithProperty) {
          T objectToLoad = ListSequence.fromList(objects).getElement(0);
          loadObjectToForm(objectToLoad);
        }

        // in forms3 this features was only enabled, if a type and a selectedClass was specified
        // dataux always uses a selectedClass..
        selController.pushSelectionAbsolute(new Selection(ListSequence.fromList(objects).getElement(0)));

      } else {
        clear();
      }
    }
  }

  public void pushSelection(IOFXSelection selection) {
    selController.pushSelectionAbsolute(selection);
  }

  public IOFXSelection getSelection(Class clazz, boolean includingDerived) {
    return selController.getSelectionAbsolute(clazz, includingDerived);
  }

  public void gcClear(IDataUxDelegate... allDelegates) {
    if (dataUxElementHook != null) {
      dataUxElementHook.gcClear();
    }

    // gcClear() only called on boundDelegates, not on DummyDelegates!
    for (IDataUxDelegate dlgt : allDelegates) {
      dlgt.gcClear();
    }
    uiDelegateForm.gcClear();

    selController = null;
    boundObject = null;
    uiDelegateForm = null;
  }

}
