package org.modellwerkstatt.dataux.runtime.genspecifications;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TableForm;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.Selection;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellIntegerConverter;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellBigDecimalConverter;
import org.modellwerkstatt.dataux.runtime.extensions.ITableRowColor;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellStatusConverter;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellDateTimeConverter;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellLocalDateConverter;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellSimpleConverter;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;

public abstract class Table<T> implements IGenSelControlled<T> {

  protected IToolkit_TableForm uiTableForm;
  protected ISelectionController selcrtl;

  protected Class contentClass;
  protected boolean calcSelectionSummaryLine;
  protected boolean calcTableSummaryLine;
  protected boolean selectFirst;

  public Table(Class cls, boolean selFirst, boolean calcSelSummaryLine, boolean calcTblSummaryLine) {
    contentClass = cls;
    calcSelectionSummaryLine = calcSelSummaryLine;
    calcTableSummaryLine = calcTblSummaryLine;
    selectFirst = selFirst;
  }

  @Override
  public String saveAndValidate() {
    return null;
  }
  @Override
  public List<IDelegateChange> collectDelegateChanges() {
    return null;
  }
  @Override
  public void forceNotEditable() {
    uiTableForm.forceNotEditable();

  }
  @Override
  public IToolkit_Form getToolkitImplementation() {
    return uiTableForm;
  }
  @Override
  public void pushSelection(IOFXSelection selection) {
    selcrtl.pushSelectionAbsolute(selection);
  }
  @Override
  public IOFXSelection getSelection(Class clazz, boolean andDerived) {
    throw new RuntimeException("this.getSelection() deprecated ... ");
  }

  public String calcSelectionSummaryLineText(List<T> selectedObjects) {
    return "";
  }


  @Override
  public boolean selectionChanged(IOFXSelection selection, boolean doNotLoadReloadFollows) {
    if (calcSelectionSummaryLine) {
      try {
        if (selection.size() > 0) {
          List<T> selObjects = (List<T>) selection.getObjects();
          uiTableForm.setSelectionSummaryLineText(calcSelectionSummaryLineText(selObjects));
        } else {
          uiTableForm.setSelectionSummaryLineText("");
        }
      } catch (Exception e) {
        // to ignore for for visu
        uiTableForm.setSelectionSummaryLineText("");
      }
    }
    return uiTableForm.selectionChanged(selection);
  }

  public String calcTableSummaryLineText(List<T> allObjects) {
    return "";
  }
  @Override
  public void loadList(List<T> objects, IOFXSelection selection) {
    uiTableForm.loadList(objects, selection);

    if (selectFirst && ListSequence.fromList(objects).count() > 0 && selection.size() == 0) {
      // in order to allow for appropriate summary line calc.
      selection = new Selection(ListSequence.fromList(objects).getElement(0));
      this.pushSelection(selection);
    }


    if (calcSelectionSummaryLine) {
      try {
        if (selection.size() > 0) {
          List<T> selObjects = (List<T>) selection.getObjects();
          uiTableForm.setSelectionSummaryLineText(calcSelectionSummaryLineText(selObjects));
        } else {
          uiTableForm.setSelectionSummaryLineText("");
        }
      } catch (Exception e) {
        // to ignore for for visu
        uiTableForm.setSelectionSummaryLineText("");
      }
    }


    if (calcTableSummaryLine) {
      try {
        if (ListSequence.fromList(objects).count() > 0) {
          List<T> allObjects = objects;
          uiTableForm.setTableSummaryLineText(calcTableSummaryLineText(allObjects));
        } else {
          uiTableForm.setTableSummaryLineText("");
        }

      } catch (Exception ex) {
        uiTableForm.setTableSummaryLineText("");
      }
    }
  }


  public void addIntegerDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellIntegerConverter(tp.getIntegerFormatterOrNull(langIndex, format), MoWareFormattersFactory.containsNo0FormatStatment(format)), width, editable, folded, important);

  }
  public void addBigDecimalDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellBigDecimalConverter(tp.getDecimalFormatter(langIndex, format), MoWareFormattersFactory.containsNo0FormatStatment(format)), width, editable, folded, important);

  }
  public void addBigDecimalDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important, ITableRowColor<BigDecimal> conv) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellBigDecimalConverter(tp.getDecimalFormatter(langIndex, format), MoWareFormattersFactory.containsNo0FormatStatment(format), conv), width, editable, folded, important);

  }
  public void addStatusDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important, IOFXMetaStatus.IOFXStatusElement<? extends IOFXMetaStatus.IOFXStatusElement> statusElement, boolean longDesc) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellStatusConverter(statusElement, tp.getStatusTranslationMap(langIndex, statusElement, longDesc)), width, editable, folded, important);

  }
  public void addDateTimeDateOnlyDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellDateTimeConverter(tp.getLocalDateFormatter(langIndex, format)), width, editable, folded, important);

  }
  public void addDateTimeDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellDateTimeConverter(tp.getDelegateDateTimeEditorFormatter(langIndex, format)), width, editable, folded, important);

  }
  public void addLocalDateDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellLocalDateConverter(tp.getLocalDateFormatter(langIndex, format)), width, editable, folded, important);

  }
  public void addDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important, boolean rightAlign) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellSimpleConverter(rightAlign), width, editable, folded, important);

  }
  public void addDelegate(IOFXTranslationProvider tp, int langIndex, String propName, String label, String format, int width, boolean editable, boolean folded, boolean important, boolean rightAlign, ITableRowColor<Object> conv) {

    uiTableForm.addColumn(propName, tp.translateSingle(langIndex, label), new TableCellSimpleConverter(rightAlign, conv), width, editable, folded, important);

  }


  @Override
  public String convertAsCsv(List<T> allObjects, List<T> selectedObjects, List<IToolkit_TableForm.TableColumn> columns) {

    StringBuilder csv = new StringBuilder();
    List<T> objectsToExport = selectedObjects;

    for (int i = 0; i < columns.size(); i++) {
      IToolkit_TableForm.TableColumn col = columns.get(i);
      if (col.visible) {
        csv.append(col.headerName + "\t");
      }
    }
    csv.append("\n");

    for (T item : objectsToExport) {
      for (int i = 0; i < columns.size(); i++) {
        IToolkit_TableForm.TableColumn col = columns.get(i);

        if (col.visible) {
          String viewed = col.mowareConverter.convert(MoJSON.get(item, col.propertyName));
          csv.append(viewed + "\t");
        }
      }
      csv.append("\n");
    }
    return csv.toString();

  }

  public void preDelayedAfterFullUiInitialized() {
  }

  public void gcClear() {
    // Actions are gcCleared by pageCrtl
    selcrtl = null;
    uiTableForm.gcClear();
  }
}
