package org.modellwerkstatt.dataux.runtime.httpapi;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import java.util.HashMap;
import mjson.Json;

public class JSonApiErrorReporter implements IApiErrorReporter {
  private static final boolean PRETTY_PRINT = false;
  private static final int API_UNPROCESSABLE_CONTENT = 422;
  private JackyInfra infra;

  public JSonApiErrorReporter(JackyInfra jackyInfra) {
    infra = jackyInfra;
  }

  @Override
  public void reportApiExFieldNamesProblem(HttpServletResponse resp, ApiException ex) throws IOException {
    JsonGenerator gen = null;
    String result = "";


    try (StringWriter sw = new StringWriter()) {
      gen = infra.createGenerator(sw, PRETTY_PRINT);

      gen.writeStartObject();
      gen.writeNumberField("status", API_UNPROCESSABLE_CONTENT);
      gen.writeStringField("error", "UNPROCESSABLE_CONTENT");
      gen.writeStringField("desc", ex.getMessage());
      gen.writeNullField("data");
      gen.writeNullField("problems");

      gen.writeEndObject();

      // close is needed by gen
      gen.close();
      gen = null;
      result = sw.toString();

    } finally {
      ensureClosed(gen);
    }

    resp.setStatus(API_UNPROCESSABLE_CONTENT);
    resp.setContentType("application/json");
    resp.getWriter().write(result);
  }

  @Override
  public void reportSerdesProblem(HttpServletResponse resp, SerdesException ex) throws IOException {
    JsonGenerator gen = null;
    String result = "";


    try (StringWriter sw = new StringWriter()) {
      gen = infra.createGenerator(sw, PRETTY_PRINT);

      gen.writeStartObject();
      gen.writeNumberField("status", API_UNPROCESSABLE_CONTENT);
      gen.writeStringField("error", "UNPROCESSABLE_CONTENT");
      gen.writeStringField("desc", ex.getMessage());
      gen.writeNullField("data");
      gen.writeNullField("problems");

      gen.writeEndObject();

      // close is needed by gen
      gen.close();
      gen = null;
      result = sw.toString();

    } finally {
      ensureClosed(gen);
    }

    resp.setStatus(API_UNPROCESSABLE_CONTENT);
    resp.setContentType("application/json");
    resp.getWriter().write(result);
  }


  public static void writeProblems(JsonGenerator gen, List<IOFXProblem> problms) throws IOException {
    gen.writeArrayFieldStart("problems");
    for (IOFXProblem prbml : problms) {
      gen.writeStartObject();
      gen.writeStringField("desc", prbml.getProblemDescOrNull());
      gen.writeStringField("instance", prbml.getInstanceDescOrNull());
      gen.writeStringField("priority", "" + prbml.translatedLogPrio());

      gen.writeBooleanField("warningOnly", prbml.isWarningOnly());

      HashMap<String, Object> customMap = prbml.getPropMapOrNull();
      if (customMap != null) {
        for (String key : customMap.keySet()) {
          gen.writeStringField("_" + key, "" + customMap.get(key));

        }
      }
      gen.writeEndObject();
    }
    gen.writeEndArray();
  }

  @Override
  public void reportOfxProblems(HttpServletResponse resp, List<IOFXProblem> problms) throws IOException {
    JsonGenerator gen = null;
    String result = "";


    try (StringWriter sw = new StringWriter()) {
      gen = infra.createGenerator(sw, PRETTY_PRINT);

      gen.writeStartObject();
      gen.writeNumberField("status", HttpServletResponse.SC_ACCEPTED);
      gen.writeStringField("error", "ACCEPTED");
      gen.writeStringField("desc", "request accepted, processing not completed");
      gen.writeNullField("data");

      writeProblems(gen, problms);

      gen.writeEndObject();

      // close is needed by gen
      gen.close();
      gen = null;
      result = sw.toString();

    } finally {
      ensureClosed(gen);
    }

    resp.setStatus(HttpServletResponse.SC_ACCEPTED);
    resp.setContentType("application/json");
    resp.getWriter().write(result);
  }
  @Override
  public void reportInternalProblem(HttpServletResponse resp, Exception ex) throws IOException {
    JsonGenerator gen = null;
    String result = "";


    try (StringWriter sw = new StringWriter()) {
      gen = infra.createGenerator(sw, PRETTY_PRINT);

      gen.writeStartObject();
      gen.writeNumberField("status", HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
      gen.writeStringField("error", "INTERNAL_SERVER_ERROR");
      gen.writeStringField("desc", "internal server error");
      gen.writeNullField("data");
      gen.writeNullField("problems");
      gen.writeEndObject();

      // close is needed by gen
      gen.close();
      gen = null;
      result = sw.toString();

    } finally {
      ensureClosed(gen);
    }

    resp.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
    resp.setContentType("application/json");
    resp.getWriter().write(result);
  }
  @Override
  public void notFound(HttpServletResponse resp) throws IOException {
    JsonGenerator gen = null;
    String result = "";


    try (StringWriter sw = new StringWriter()) {
      gen = infra.createGenerator(sw, PRETTY_PRINT);

      gen.writeStartObject();
      gen.writeNumberField("status", HttpServletResponse.SC_NOT_FOUND);
      gen.writeStringField("error", "NOT_FOUND");
      gen.writeStringField("desc", "operation not found");
      gen.writeNullField("data");
      gen.writeNullField("problems");

      gen.writeEndObject();

      // close is needed by gen
      gen.close();
      gen = null;
      result = sw.toString();

    } finally {
      ensureClosed(gen);
    }

    resp.setStatus(HttpServletResponse.SC_NOT_FOUND);
    resp.setContentType("application/json");
    resp.getWriter().write(result);
  }


  private void ensureClosed(JsonGenerator gen) {
    if (gen != null) {
      try {
        gen.close();
      } catch (IOException e) {
      }
    }
  }




  public static Json convertResult(String st) {
    return Json.read(st);
  }




  public static void main(String[] args) {
    String precond = "{\"status\":202,\"error\":\"ACCEPTED\",\"desc\":\"request accepted, processing not completed\",\"problems\":[{\"desc\":\"precondition 1 - with props and instance\",\"instance\":\"instance4711\",\"priority\":\"ERROR\",\"_myprop2\":\"4712\",\"_myporp1\":\"4711\"},{\"desc\":\"precondition 2 - no props\",\"instance\":null,\"priority\":\"INFO\"},{\"desc\":\"precondition 3 - Warning hint\",\"instance\":null,\"priority\":\"INFO\",\"warningOnly\":true}]}\n    ";
    String notfound = "{\"status\":404,\"error\":\"NOT_FOUND\",\"desc\":\"operation not found\"}";

    Json res = convertResult(notfound);
    System.err.println(res.at("status").asInteger());
    System.err.println(res.at("error").asString());
    System.err.println(res.at("desc").asString());


    res = convertResult(precond);
    System.err.println(res.at("problems").asJsonList().get(0).at("desc"));
    System.err.println(res.at("problems").asJsonList().get(1).at("desc"));

  }
}
