package org.modellwerkstatt.dataux.runtime.httpapi;

/*Generated by MPS */

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class TextApiErrorReporter implements IApiErrorReporter {

  @Override
  public void reportApiExFieldNamesProblem(HttpServletResponse resp, ApiException apiEx) throws IOException {
    prepareErrorResponse(resp, HttpServletResponse.SC_BAD_REQUEST, apiEx.getErrorCode(), apiEx.getMessage(), apiEx);
  }

  @Override
  public void reportSerdesProblem(HttpServletResponse resp, SerdesException ex) throws IOException {
    prepareErrorResponse(resp, HttpServletResponse.SC_BAD_REQUEST, ApiException.Code.JSON_FORMAT_ERROR.intCode, ex.getMessage(), ex);
  }

  @Override
  public void reportOfxProblems(HttpServletResponse resp, List<IOFXProblem> problms) throws IOException {
    prepareErrorResponse(resp, HttpServletResponse.SC_ACCEPTED, 0, "Operation aborted.\n" + OFXConsoleHelper.asSimpleString(problms), null);
  }

  @Override
  public void reportInternalProblem(HttpServletResponse resp, Exception ex) throws IOException {
    prepareErrorResponse(resp, HttpServletResponse.SC_INTERNAL_SERVER_ERROR, 0, "internal server error", ex);
  }

  @Override
  public void notFound(HttpServletResponse resp) throws IOException {
    prepareErrorResponse(resp, HttpServletResponse.SC_NOT_FOUND, 0, "not found", null);
  }
  private static void prepareErrorResponse(HttpServletResponse resp, int httpCode, int subcode, String text, Throwable tToDebug) throws IOException {

    resp.resetBuffer();
    resp.setHeader("Content-Type", "text/plain");

    resp.setStatus(httpCode);

    String st = "" + httpCode;
    if (subcode > 0) {
      st += "." + subcode;
    }
    if (text != null) {
      st += " : " + text;
    }

    if (tToDebug != null) {
      st += "\n     \n" + OFXConsoleHelper.stackTrace2String(tToDebug);
    }
    resp.getWriter().print(st);


  }


}
