package org.modellwerkstatt.dataux.runtime.sdicore;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

public class LandingPageUrlItem {
  public String url;
  public String label;
  public String tooltip;
  public String icon;
  public String color;
  public String hotkey;
  public boolean enabled;
  public int actionHashcode;
  public List<LandingPageUrlItem> subItems;

  public LandingPageUrlItem(int hash, String aUrl, String aLabel, String aTooltip, String aIcon, String aColor, String aHotkey, boolean aEnabled) {
    url = aUrl;
    label = aLabel;
    tooltip = aTooltip;
    icon = aIcon;
    color = aColor;
    hotkey = aHotkey;
    enabled = aEnabled;
    actionHashcode = hash;
  }

  public LandingPageUrlItem(String aLabel) {
    label = aLabel;
    subItems = ListSequence.fromList(new ArrayList<LandingPageUrlItem>());
  }

  public boolean isSubMenu() {
    return subItems != null;
  }
  public boolean hasItemsInSubMenu() {
    return ListSequence.fromList(subItems).count() > 0;
  }
  public void addToSubMenu(LandingPageUrlItem itm) {
    ListSequence.fromList(subItems).addElement(itm);
  }
  public List<LandingPageUrlItem> getSubItems() {
    return subItems;
  }
  public boolean isSeperator() {
    return label == null;
  }



  @Override
  public String toString() {
    if (isSubMenu()) {
      return "SubMenu (" + ListSequence.fromList(subItems).count() + ")";
    }
    if (isSeperator()) {
      return "---";
    }
    return label;
  }
  public static String print(String ident, LandingPageUrlItem menu) {
    if (!(menu.isSubMenu())) {
      throw new RuntimeException("This can not happen.");
    }

    String st = "";
    for (LandingPageUrlItem item : menu.getSubItems()) {
      if (item.isSeperator()) {
        st += ident + "--- \n";
      } else if (item.isSubMenu()) {
        st += ident + "-- " + item.label + " -- " + "\n";
        st += print(ident + "     ", item) + "\n";
      } else {
        st += ident + item.label + "\n";
      }
    }
    return st;
  }
}
