package org.modellwerkstatt.dataux.runtime.telemetrics;

/*Generated by MPS */

import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.dataux.runtime.core.BaseUiFactory;
import org.modellwerkstatt.objectflow.runtime.StaticJmxAccess;
import org.modellwerkstatt.dataux.runtime.core.ApplicationReporter;

public class AppJmxRegistration {
  private static final String telemetricsServiceName = ":type=ApplicationTelemetrics";
  private static final String clientServiceName = ":type=ClientTelemetrics, name=";


  private String namePrefix;
  private ApplicationTelemetrics appTelemetrics;
  private String servletBasePath;
  private String homeScreenPath;
  private HashMap<String, Boolean> currentInstanceNames = new HashMap<String, Boolean>();
  private ParDeployAutoForwarder autoForwarder;

  public AppJmxRegistration(String appBehaviourFqName, String namePostFix, String servletPath, String homePath) {
    // Basically one could integrate that jmx stuff with IOFXCoreReporter. 

    if (appBehaviourFqName == null) {
      appBehaviourFqName = "unknown.unknown";
    }
    namePrefix = appBehaviourFqName + "_" + namePostFix;

    servletBasePath = servletPath;
    homeScreenPath = homePath;
  }

  public void registerAppTelemetrics(final IOFXApplicationFactory factory, String appFqName, String appName, String appVersion, String frameworkVersion, String guessedServerName) {
    // it is necessary to call registerAppTelemetrics

    autoForwarder = new ParDeployAutoForwarder(appName, appVersion);

    appTelemetrics = new ApplicationTelemetrics(appFqName, appName + " " + appVersion, servletBasePath, homeScreenPath, factory.getConnectionUrl(), frameworkVersion, guessedServerName, factory.getSettingsDescription(), "");

    appTelemetrics.setUiFactDynInfo(new ApplicationTelemetrics.DynamicInfo() {
      @Override
      public String getDescription() {
        return factory.getStatusDescription();
      }
    });
    appTelemetrics.setAutoParDeplyDynInfo(new ApplicationTelemetrics.DynamicInfo() {
      @Override
      public String getDescription() {
        return autoForwarder.getAutoParDeploySettings();
      }
    });

    appTelemetrics.setAutoParDeplyToCurrentVersion(new ApplicationTelemetrics.DynamicAction() {
      @Override
      public String execAction() {
        return autoForwarder.setToCurrentVersion();
      }
    });

    if (factory instanceof BaseUiFactory) {
      appTelemetrics.setResetEventBusAction(new ApplicationTelemetrics.DynamicAction() {
        @Override
        public String execAction() {
          return ((BaseUiFactory) factory).getEventBus().testReset();
        }
      });
    }

    String nameToRegister = namePrefix + telemetricsServiceName;
    StaticJmxAccess.register(appTelemetrics, nameToRegister);

  }

  public void enableAutoForwardGracefully() {
    autoForwarder.updateParDeployInfo();
  }

  public boolean checkMarkAsForwardGracyFully() {
    boolean oldVersion = autoForwarder.checkIsOldVersion();
    if (oldVersion && !(appTelemetrics.isParDeploymentForwardGracefully())) {
      appTelemetrics.parDeployForwardGracefully(true);
    }
    return oldVersion;
  }


  public void registerClient(ApplicationReporter clientTelemetrics) {

    synchronized (this) {
      String instName = clientTelemetrics.getuser_jmxInstanceName();
      String suggested = instName;
      String suffix = "";

      // we will get a JMX registration error instead of endless loop
      for (int i = 1; i < 1000; i++) {
        if (currentInstanceNames.containsKey(suggested)) {
          suffix = " " + i;
          suggested = instName + suffix;

        } else {
          currentInstanceNames.put(suggested, true);
          clientTelemetrics.setJmxUniqueNameSuffix(suffix);
          break;
        }
      }

    }

    String nameToReg = namePrefix + clientServiceName + clientTelemetrics.getuser_jmxInstanceName();

    StaticJmxAccess.register(clientTelemetrics, nameToReg);
    appTelemetrics.incClient();
  }


  public void unregisterClient(ApplicationReporter clientTelemetrics) {
    String instanceName = clientTelemetrics.getuser_jmxInstanceName();
    String nameToUnreg = namePrefix + clientServiceName + instanceName;

    StaticJmxAccess.unregister(nameToUnreg);
    // co modification shouldn t be a problem, since we are not using iterators etc.
    currentInstanceNames.remove(instanceName);
    appTelemetrics.decClient();
  }

  public boolean markedAsOld() {
    return appTelemetrics.isParDeploymentForwardGracefully() || appTelemetrics.isParDeploymentForwardImmediate();
  }

  public ApplicationTelemetrics getAppTelemetrics() {
    return appTelemetrics;
  }

  public void gcClean() {
    String nameToUnRegister = namePrefix + telemetricsServiceName;
    StaticJmxAccess.unregister(nameToUnRegister);
    appTelemetrics.gcClean();
    currentInstanceNames.clear();
    autoForwarder = null;
  }

  public static void main(String[] args) {
  }
}
