package org.modellwerkstatt.dataux.runtime.telemetrics;

/*Generated by MPS */

import javax.management.NotificationBroadcasterSupport;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicInteger;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongSampler;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongAbsoluter;
import org.joda.time.DateTime;
import javax.management.Notification;

public class ApplicationTelemetrics extends NotificationBroadcasterSupport implements ApplicationTelemetricsMBean {
  private static final long hour = 3600000;
  private static final long tenMinutes = 600000;

  private String settings;
  private boolean preventHtmlCache;
  private long sequence;


  private AtomicLong totalRequest;
  private AtomicLong totalCommands;
  private AtomicLong totalExceptions;
  private AtomicInteger totalClients;

  private AtomicInteger openCommands;

  private TelemetricsLongSampler durationSampler;
  private TelemetricsLongAbsoluter durationAbsolut;
  private TelemetricsLongSampler exceptionSampler;
  private TelemetricsLongSampler requestSampler;
  private TelemetricsLongSampler commandSampler;

  private String appFqName;
  private String apNamepVersion;
  private String frameworkVersion;
  private String guessedServerName;
  private String servletBasePath;
  private String homeScreenPath;
  private String connectionUrl;
  private String uiFactorySettings;
  private DynamicInfo uiFactoryDynInfo;
  private DynamicInfo parDeployAutoDynInfo;
  private DynamicAction parDeployAutoSetCurrentVersion;
  private DynamicAction resetEventBusConnection;


  private boolean parDeploymentForwardImmediate;
  private boolean parDeploymentForwardGracefully;

  private DateTime appLoadedAt;

  public ApplicationTelemetrics(String aFqNam, String aNameVers, String servletPath, String homePath, String connUrl, String frameVers, String guessedServName, String uiFactSettings, String aSettings) {
    sequence = 0;
    parDeploymentForwardImmediate = false;
    parDeploymentForwardGracefully = false;

    appFqName = aFqNam;
    apNamepVersion = aNameVers;
    connectionUrl = connUrl;
    frameworkVersion = frameVers;
    guessedServerName = guessedServName;
    servletBasePath = servletPath;
    homeScreenPath = homePath;
    appLoadedAt = new DateTime();
    uiFactorySettings = uiFactSettings;

    settings = aSettings;

    preventHtmlCache = false;

    totalRequest = new AtomicLong(0);

    totalCommands = new AtomicLong(0);

    totalExceptions = new AtomicLong(0);

    openCommands = new AtomicInteger(0);
    totalClients = new AtomicInteger(0);

    durationSampler = new TelemetricsLongSampler(10000);
    requestSampler = new TelemetricsLongSampler(100000);
    commandSampler = new TelemetricsLongSampler(10000);
    exceptionSampler = new TelemetricsLongSampler(10000);
    durationAbsolut = new TelemetricsLongAbsoluter();
  }
  public void setUiFactDynInfo(DynamicInfo info) {
    uiFactoryDynInfo = info;
  }
  public void setAutoParDeplyDynInfo(DynamicInfo info) {
    parDeployAutoDynInfo = info;
  }
  public void setAutoParDeplyToCurrentVersion(DynamicAction act) {
    parDeployAutoSetCurrentVersion = act;
  }

  public void applicationLog(String msg1, String msg) {
    Notification n = new Notification("application log", this, sequence++, msg);
    n.setUserData(msg1);
    sendNotification(n);
  }

  public String getapp_FramkworkVersion() {
    return frameworkVersion;
  }
  public String getapp_FqName() {
    return appFqName;
  }
  public String getapp_Application() {
    return apNamepVersion;
  }
  public String getapp_ServerName() {
    return guessedServerName;
  }
  public String getapp_ServletBasePath() {
    return servletBasePath;
  }
  public String getapp_HomeScreenPath() {
    return homeScreenPath;
  }
  public String getapp_ConnectionUrl() {
    return connectionUrl;
  }
  public String getapp_FactorySettings() {
    return uiFactorySettings;
  }
  @Override
  public String getapp_FactoryStatus() {
    return (uiFactoryDynInfo == null ? "null" : uiFactoryDynInfo.getDescription());
  }
  public String getapp_InitAndStartup() {
    return appLoadedAt.toString();
  }
  public int getclients_unique() {
    return totalClients.get();
  }
  public long getrequests_PerHour() {
    return requestSampler.getCount(System.currentTimeMillis() - ApplicationTelemetrics.hour);
  }
  public long getrequests_Per10Minutes() {
    return requestSampler.getCount(System.currentTimeMillis() - ApplicationTelemetrics.tenMinutes);
  }
  public long getrequests_Total() {
    return totalRequest.get();
  }
  public long getcommands_PerHour() {
    return commandSampler.getCount(System.currentTimeMillis() - ApplicationTelemetrics.hour);
  }
  public long getcommands_Per10Minutes() {
    return commandSampler.getCount(System.currentTimeMillis() - ApplicationTelemetrics.tenMinutes);
  }
  public long getcommands_Total() {
    return totalCommands.get();
  }
  public long getcommands_Open() {
    return openCommands.get();
  }
  public long getexceptions_PerHour() {
    return exceptionSampler.getCount(System.currentTimeMillis() - ApplicationTelemetrics.hour);
  }
  public long getexceptions_Per10Minutes() {
    return exceptionSampler.getCount(System.currentTimeMillis() - ApplicationTelemetrics.tenMinutes);
  }
  public long getexceptions_Total() {
    return totalExceptions.get();
  }
  public long getduration_AVG_Last10() {
    return durationSampler.getAverage(10);
  }
  public long getduration_AVG_Last100() {
    return durationSampler.getAverage(100);
  }
  public long getduration_AVG_Last1000() {
    return durationSampler.getAverage(1000);
  }
  public long getduration_AVG() {
    return durationAbsolut.getAverage();
  }
  public long getduration_MAX_Last10() {
    return durationSampler.getMax(10);
  }
  public long getduration_MAX_Last100() {
    return durationSampler.getMax(100);
  }
  public long getduration_MAX_Last1000() {
    return durationSampler.getMax(1000);
  }

  public long getduration_MAX() {
    return durationAbsolut.getMax();
  }
  public void incException() {
    totalExceptions.incrementAndGet();
    exceptionSampler.addSample(System.currentTimeMillis());

  }
  public void incCommands() {
    totalCommands.incrementAndGet();
    openCommands.incrementAndGet();
    commandSampler.addSample(System.currentTimeMillis());
  }
  public void decCommand() {
    openCommands.decrementAndGet();
  }
  public void incClient() {
    totalClients.incrementAndGet();
  }
  public void decClient() {
    totalClients.decrementAndGet();
  }

  public void servedRequest(String remoteAddr, String userName, String execCommand, long startTime) {
    // check callers, refactor 
    if (startTime == -1) {
      this.applicationLog(remoteAddr, userName + ": " + execCommand);

    } else {
      long now = System.currentTimeMillis();
      long diff = now - startTime;
      totalRequest.incrementAndGet();
      requestSampler.addSample(now);
      durationSampler.addSample(diff);
      durationAbsolut.addSample(diff);

      if (diff > 1000) {
        this.applicationLog(remoteAddr + " (" + diff + "ms)", userName + ": " + execCommand);
      }
    }
  }

  public String getapp_Settings() {
    return settings;
  }

  public String preventHtmlCaching(boolean status) {
    preventHtmlCache = status;
    return "Prevent html cache is " + preventHtmlCache;
  }
  public boolean isPreventHtmlCaching() {
    return preventHtmlCache;
  }


  @Override
  public String getapp_parDeploymentStatus() {
    return "parDeploymentForwardGracefully is " + parDeploymentForwardGracefully + ", parDeplyomentForwardImmediate is " + parDeploymentForwardImmediate;
  }
  @Override
  public String parDeployForwardImmediate(boolean status) {
    parDeploymentForwardImmediate = status;
    return "parDeploymentForwardImmediate is now " + parDeploymentForwardImmediate;
  }
  public boolean isParDeploymentForwardImmediate() {
    return parDeploymentForwardImmediate;
  }
  @Override
  public String parDeployForwardGracefully(boolean status) {
    parDeploymentForwardGracefully = status;
    return "parDeploymentForwardGracefully is now " + parDeploymentForwardGracefully;
  }
  public boolean isParDeploymentForwardGracefully() {
    return parDeploymentForwardGracefully;
  }

  public String getapp_PreventHtmlCaching() {
    return "" + preventHtmlCache;
  }
  @Override
  public String getapp_AutoDeployForward() {
    return (parDeployAutoDynInfo == null ? "null" : parDeployAutoDynInfo.getDescription());
  }
  @Override
  public String setAutoDeployForwardToCurrentVersion() {
    if (parDeployAutoSetCurrentVersion == null) {
      return "null - frmwk error?";

    } else {
      parDeploymentForwardGracefully = false;
      parDeploymentForwardImmediate = false;
      return parDeployAutoSetCurrentVersion.execAction();

    }
  }

  public void setResetEventBusAction(DynamicAction act) {
    resetEventBusConnection = act;
  }
  @Override
  public String tryResetEventBusConnection() {
    if (resetEventBusConnection != null) {
      return resetEventBusConnection.execAction();
    }
    return "no reset action set :/";
  }

  public void gcClean() {
    // nothing to to here. allow to report jmx related problems
    // ..
    uiFactoryDynInfo = null;
    parDeployAutoDynInfo = null;
  }


  public interface DynamicInfo {
    String getDescription();
  }
  public interface DynamicAction {
    String execAction();
  }


}
