package org.modellwerkstatt.dataux.runtime.telemetrics;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.Properties;
import java.util.Set;

public class ParDeployAutoForwarder {
  private final String PREFIX = "modellwerkstatt.pardeploy.";
  private String propKey;
  private String ownVersion;
  private boolean iAmOldVersion;
  private boolean enabled;

  public ParDeployAutoForwarder(String appShortName, String version) {
    propKey = PREFIX + appShortName.replace(' ', '_').toLowerCase();
    ownVersion = version;
    iAmOldVersion = false;
    enabled = false;
  }

  public void updateParDeployInfo() {
    // no issues with thread safety, since we deploy only one app at a time?
    enabled = true;
    String existing = System.getProperty(propKey);
    if (existing == null) {
      System.setProperty(propKey, ownVersion);

    } else {
      if (ownVersion.compareTo(existing) > 0) {
        System.setProperty(propKey, ownVersion);

      } else {
        // strange, a newer version is deployed?
        OFXLogger.log(ParDeployAutoForwarder.class, IOFXCoreReporter.LogPriority.ERROR, "Strange, probably an error: deployed " + propKey + " with '" + ownVersion + "' but found '" + existing + "' which is the same or a lower version?", null);
      }
    }
  }

  public boolean checkIsOldVersion() {
    if (!(enabled)) {
      return false;

    } else if (iAmOldVersion) {
      return true;

    } else {
      String existing = System.getProperty(propKey);
      if (ownVersion.compareTo(existing) < 0) {
        iAmOldVersion = true;
        return true;
      }
    }

    return false;
  }

  public String getAutoParDeploySettings() {
    StringBuilder sb = new StringBuilder();
    sb.append(propKey + " - " + enabled);
    Properties sysProps = System.getProperties();
    Set<String> keys = sysProps.stringPropertyNames();

    for (String key : keys) {
      if (key.startsWith(PREFIX)) {
        sb.append(" , " + key + ": " + sysProps.getProperty(key));
      }
    }

    return sb.toString();
  }

  public String setToCurrentVersion() {
    // enabled not changed
    iAmOldVersion = false;
    System.setProperty(propKey, ownVersion);
    return "set " + propKey + " to " + ownVersion;
  }

  public static void main(String[] args) {
    System.err.println("> " + "6.28.2.3".compareTo("6.3.2.3"));
    System.err.println("> " + "1.0.0".compareTo("0.1.9"));
    System.err.println("> " + "02".compareTo("11"));
    System.err.println("> " + "0.9".compareTo("0.9"));

  }
}
