package org.modellwerkstatt.dataux.runtime.utils;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class LayoutConstraint {
  private int pxl;
  private boolean isPxl;
  private boolean minimal;
  private int percent;
  public LayoutConstraint(String cfg) {
    isPxl = false;
    minimal = false;
    percent = 0;

    try {
      pxl = Integer.parseInt(cfg);
      if (pxl < 0) {
        minimal = true;
      } else {
        isPxl = true;
      }
    } catch (NumberFormatException ex) {
    }

    if (!(isPxl) && cfg.contains("*")) {
      percent = Integer.parseInt(cfg.replace("*", ""));
    }

  }
  public int getInPercent() {
    return this.percent;
  }
  public int getPixl() {
    return this.pxl;
  }
  public boolean isPxl() {
    return this.isPxl;
  }
  public boolean isMinimal() {
    return this.minimal;
  }
  public void setTotalWeight(int totalweight) {
    if (!(isPxl) && totalweight > 0) {
      percent = (100 * percent) / totalweight;
    }
  }
  public static int calcTotalWeight(List<LayoutConstraint> lc) {
    final Wrappers._int totalWeight = new Wrappers._int(0);
    ListSequence.fromList(lc).where((it) -> !(it.isPxl() || it.isMinimal())).visitAll((it) -> totalWeight.value += it.getInPercent());
    return totalWeight.value;
  }


  @Override
  public String toString() {
    StringBuilder b = new StringBuilder();
    b.append("(pxl?" + isPxl + "  minimal?" + minimal + "  percent?" + percent + ")");

    return b.toString();
  }
}
