package org.modellwerkstatt.dataux.runtime.utils;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.MoVersion;

public class MoWareTranslations {
  private TranslationSelection translationSelection;

  public MoWareTranslations(TranslationSelection sys) {
    translationSelection = sys;
  }

  public String t(Key keyToTranslate) {
    // a speed optimized version

    if (translationSelection == TranslationSelection.MAIN_TRANSLATIONS) {
      return keyToTranslate.getLangDefault();

    } else if (translationSelection == TranslationSelection.V_TRANSLATIONS) {
      String trans = keyToTranslate.getLangVaadinAdopt();
      if (trans == null) {
        return keyToTranslate.getLangDefault();
      }
      return trans;

    } else if (translationSelection == TranslationSelection.H1_TRANSLATIONS) {
      String trans = keyToTranslate.getLangH1Adopt();
      if (trans == null) {
        return keyToTranslate.getLangDefault();
      }
      return trans;

    } else if (translationSelection == TranslationSelection.EN_DEFAULT_TRANS) {
      String trans = keyToTranslate.getLangEN();
      if (trans == null) {
        return keyToTranslate.getLangDefault();
      }
      return trans;
    }

    throw new RuntimeException("This can not happen.");
  }




  public enum TranslationSelection {
    MAIN_TRANSLATIONS(),
    H1_TRANSLATIONS(),
    V_TRANSLATIONS(),
    EN_DEFAULT_TRANS()
  }

  public enum Key {
    CLOSE_APP("Vorsicht: Es sind Belege/Dokumente offen, die noch NICHT gespeichert sind!\nWenn Sie die Applikation jetzt schließen werden alle laufenden Kommandos\nabgebrochen und deren Daten NICHT gespeichert!\n\nWollen Sie die Applikation ohne zu speichern schließen?", null, null, "Do you really want to close the app?\nAll running commands will be terminated."),
    CLOS_APP_SHORT("Applikation schließen?", null, null, "Close app?"),
    START("START", "START", null, "START"),
    EDIT("Bearbeiten", null, null, "Edit"),
    CUT("Ausschneiden", null, null, "Cut"),
    COPY("Kopieren", null, null, "Copy"),
    PASTE("Einfügen", null, null, "Paste"),
    EXTRA("Extras", "Extras", null, "Extras"),
    HELP("Hilfe", "Hilfe", null, "Help"),
    VERSION("Version", "Version", null, "Version"),
    ABOUT("Über", null, null, "About"),
    QUIT("Beenden", "Beenden", null, "Quit"),
    OK_BUTTON("Ok", null, "Ok", "Ok"),
    ESC_BUTTON("Abbrechen", null, "", "Cancel"),
    CLOSE_BUTTON("Schließen", null, "Abbr", "Close"),
    NO_BUTTON("Nein", null, "Nein", "No"),
    DISCARD_BUTTON("Nicht speichern", null, "Nicht speichern", "Discard changes"),
    HELP_BUTTON("?", null, null, "?"),
    ERROR("Fehler", null, null, "Error"),
    INFORMATION("Information", null, null, "Information"),
    QUESTION("Frage", null, null, "Question"),
    TEC_USER_ERROR("Ein Fehler ist aufgetreten. Ihre Bearbeitung wurde abgebrochen\nund beendet.", null, "Ein technisches Problem ist aufgetreten. Das Kommando wurde beendet!", "An Error has occurred! The command was canceled."),
    LOST_CONN_USER_ERROR("Die Datenbank-Verbindung wurde geschlossen! Ihre Bearbeitung wurde abgebrochen\nund beendet.", null, "Die Datenbank-Verbindung wurde geschlossen. Das Kommando wurde beendet!", "The database connection was closed! The command was canceled."),
    SF_TEC_USER_ERROR_("Das Kommando '%s' konnte am System nicht erfolgreich ausgeführt werden.\nEin Fehler ist aufgetreten. Das Kommando wurde beendet.", null, "Ein technisches Problem ist aufgetreten. Das Kommando '%s' wurde beendet!", "A technical problem has occurred. The command '%s' was canceled!"),
    TEC_ERROR("Technischer Ausnahme-Fehler ", null, null, "Technical exception"),
    CRTL_SPACE_PRESS("<crtl-space> oder <mouse-click> ", null, null, "<crtl-space> or <mouse-click>"),
    REF_VALIDATION_OPTIONAL_ERR("Eine gültige Auswahl (oder keine Auswahl) muss getroffen werden.", null, null, "A valid choice (or no choice) has to be made."),
    REF_VALIDATION_ERR("Eine gültige Auswahl muss getroffen werden.", null, null, "A valid choice has to be made."),
    REF_NO_OPTION_ERR("Sie müssen an dieser Stelle eine Auswahl treffen.", null, null, "You have to choose an option."),
    DATE_VALIDATION_ERR("Ungültiges Datum bzw. Datum muss im Format %s eingegeben werden.", null, null, "Invalid date. You have to specify the date as %s."),
    DATETIME_VALIDATION_ERR("Ungültiges Datum / Uhrzeit. Muss im Format %s eingegeben werden.", "", null, "Invalid date/time. You have to specify the date/time as %s."),
    DECIMAL_VALIDATION_ERR("Zahl muss im Format %s eingegeben werden, nicht '%s'.", null, null, "You have to specify the number in %s format, not '%s'."),
    DECIMAL_BETWEEN_ERR("Zahl muss zwischen %s und %s eingegeben werden.", null, null, "The number has to be between %s and %s."),
    DECIMAL_MINIMUM_ERR("Zahl muss größer als %s eingegeben werden.", null, null, "The number has to be larger then %s."),
    DECIMAL_MAXIMUM_ERR("Zahl muss kleiner als %s eingegeben werden.", null, null, "The number has to be smaller then %s."),
    DECIMAL_SCALE_ERR("Zahl darf nur %s Nachkommastellen aufweisen.", null, null, "The number is allowed to contain only %s decimals."),
    NOT_TAKEN_OVER_ADDON("Die Änderung wurde nicht übernommen!", null, null, "The changes were not applied."),
    INTEGER_VALIDATION_ERR("Eine Ganz-Zahl muss eingegeben werden.", null, null, "You have to specify an integer number."),
    STATUS_VALIDATION_ERR("Ein Status muss gewählt werden.", null, null, "You have to select a status."),
    STRING_MAX_ERR("Es dürfen nicht mehr als %s Zeichen eingegeben werden.", null, null, "You are not allowed to enter more then %s characters."),
    STRING_MIN_ERR("Es müssen mehr als %s Zeichen eingegeben werden.", null, null, "You have to enter more then %s characters."),
    UPLOAD_CONTENT_ERR("Es muss eine Datei / Bild angegeben werden.", null, null, "You have to provide a File / Image."),
    UPLOAD_SUCCESS("Der upload von %s war erfolgreich!", null, null, "Successfully uploaded %s !"),
    TCN_PROBLEM("Ein anderer Benutzer hat ihren Datensatz bearbeitet und bereits gespeichert. Sie müssen\nihren Datensatz daher verwerfen und den aktuellsten Datensatz laden.", null, null, "Another user has changed this record. You have to discard this record\nand re-run this command. "),
    INSERT_DELETE_RELOAD_PROBLEM("Ein Teil des Datensatzes konnte nicht gespeichert, gelöscht oder neu geladen werden.", null, null, "Part of this record could not be saved, deleted or reloaded."),
    GET_USER_PROBLEM("Ein notwendiger Datensatz wurde auf der Datenbank nicht gefunden.", null, null, "A necessary record was not found on the database."),
    GET_PROBLEM("Ein notwendiger Datensatz wurde auf der Datenbank nicht gefunden.", null, null, "A necessary record was not found on the database."),
    SESSION_DIRTY("Vorsicht: Veränderungen sind NICHT gespeichert!\nWollen Sie wirklich schließen OHNE zu speichern?\n", null, "Vorsicht: Veränderungen wurden NICHT gespeichert!\nWollen Sie wirklich schließen OHNE zu speichern?\n", "Data was changed but NOT saved yet. Do you want to proceed without saving?"),
    HELP_URL("https://connections.mpreis.co.at/wikis/home#!/wiki/W8f7f2eee57a3_4dee_9303_294af9992de5/page/", null, null, null),
    LOGIN_FIRST("System-Anmeldung", null, null, "System Login"),
    LOGIN_BUTTON("Anmelden", null, null, "Login"),
    RELOGIN_BUTTON("Erneut anmelden", null, null, "Login again"),
    LOGIN_EXTENDED_USERNAME("Benutzername z.B. martinm", null, null, "Username"),
    USERNAME("Benutzer", null, null, "User"),
    PASSWORD("Passwort", null, null, "Password"),
    LOGIN_FAILED("Sie konnten nicht am System angemeldet werden.\n(Keine/ unzureichend Rechte)", null, null, "You could not be logged on to the system.\n(None or inappropriate permissions)"),
    LOGIN_USER_FAILED("Der Benutzer '%s' konnten nicht am System angemeldet werden.\n(Keine/ unzureichend Rechte)", null, null, "The user '%s' could not be logged on to the system.\n(None or inappropriate permissions)"),
    WRONGUSER_PWD("Falscher Benutzername oder falsches Passwort.", null, null, "Wrong username and/ or password."),
    NO_PERMISSIONS_FOR_CMD("Sie haben nicht die notwendige Berechtiung um dieses Kommando auszuführen", null, null, "You do not have permissions to execute this command."),
    MOWARE_ABOUT("die modellwerkstatt", "die modellwerkstatt", null, null),
    MOWARE_HELP("Falls sie Hilfe mit dieser Applikation benötigen, wenden Sie sich an ... .", null, null, "If you need help with this app please consult ..."),
    COMMAND_IN_READONLY("Kommando im Lesemodus! Daten können nicht bearbeitet werden", null, null, "Command in read-only mode! Data can not be edited"),
    LOCK_NOT_GOT_READONLY("Kommando im Lesemodus! Benutzer '%s' bearbeitet geforderte Daten.", null, "Nur im Lesemodus! %s bearbeitet.", "Command in read-only mode! User %s is using ressources which are necessary ."),
    LOCK_NOT_GOT_CANCEL("'%s' verwendet Daten, die für die Ausführung des Kommandos notwendig sind.\nDas Kommando wurde abgebrochen.", null, null, "%s is using ressources neccessary for the execution of this command.\n Command canceled."),
    APPLICATION_LOCKED("Ihre App wird durch eine neuere Version ersetzt.\nSie werden zur neuen Version umgeleitet.", null, null, "Your app is replaced with a newer version.\nWe will redirect you to the new version now."),
    APPLICATION_REPLACED("Ihre App wurde soeben durch eine neuere Version ersetzt. Sie können weiterarbeiten!", null, null, "Your app has just been replaced by a newer version. You can proceed with your work!"),
    APPLICATION_RESTARTED("Ihr letztes Kommando wurde abgebrochen. Die Applikation wurde neu gestartet.", null, null, "Your last command was terminated. The Application was restarted."),
    APPLICATION_RUNNING_IN_BROWSER("Die Applikation wird bereits in einem anderen Fenster ausgeführt. Schließen sie dieses Fenster oder bestätigen Sie, um die andere Anwendung OHNE SPEICHERN zu schließen.", null, null, "The application is already running in a window. Close this window or confirm to close the other application without saving."),
    MOWARE_VERSION("die modellwerkstatt.org App Framework " + MoVersion.MOWARE_PLUGIN_VERSION, null, null, null),
    CMD_OPENED_IN_OTHER_TAB("Das Kommando wird in einem anderen Browser-Tab bereits ausgeführt!", null, null, "The command is already running in another browser tab."),
    CMD_CLOSED_IN_TAB("Das Kommando in diesem Browser-Tab wurde beendet.", null, null, "The command in this tab was canceled."),
    APP_IN_MODAL_NO_CMD_START("Das Kommando '%s' wird in einem anderen Browser-Tab modal ausgeführt. Es muss erst beendet werden!", null, null, "The command '%s' is running in a modal Browser-Tab. You have to end that one first."),
    NETWORK_PROBLEMS("Die Netzwerkverbindung / Empfang wurde unterbrochen oder schwer beeinträchtigt. (Verbindung sicherstellen!)", null, null, "Serious network problems or low wifi reception."),
    FATA_APPFRMWRK_PROBLEM("Ein schwerwiegender Systemfehler ist aufgetreten!! Das System ist nicht einsatzbereit!!", null, null, "A serious error occurred. System is not ready!"),
    CMD_NOT_AVAILABLE("Kein Kommando zu dieser Url (mit angegebenen Parametern). Verfügbar sind bspw. %s", null, null, "No command for this url (with provided parameters). Available are for example %s"),
    CMD_NOT_ENABLED("Das Kommando '%s' konnte nicht angewendet werden. Wesentliche Bedingung zur Ausführung nicht erfüllt.", null, null, "Can not execute the command '%s' since critical conditions are not fullfilled."),
    INNER_CMD_WRONG_STATE("Das Kommando '%s' kann im Zustand '%s' nicht angewendet werden.", null, null, "Command '%s' can not be applied in this state."),
    INNER_CMD_NO_PERM("Sie haben keine Berechtigung für das Kommando '%s'.", null, null, "You do not have permissions for the command '%s'"),
    GUARD_MSG("Guard nicht erfuellt!", null, null, "Guard not fulfilled."),
    COPY_CSV_FROM_TABLE("CSV aus Tabellen-Selektion erzeugen", null, null, "Create CSV from table selection"),
    LOGOUT_SUCCESS("Sie wurden abgemeldet.", null, null, "You have been logged out."),
    LOGOUT_OTHERS_OPEN("Es sind noch andere Fenster mit ihrem Benutzer geöffnet.", null, null, "Other windows for your user are still open."),
    LOGIN_NOT_POSSIBLE("Anmeldung nicht möglich. Sind andere Browser-Tabs offen?", null, null, "Login not possible. Are there other browser-tabs open?");




    private String langDefault;
    private String langVaadinAdopt;
    private String langH1Adopt;
    private String enDefault;



    Key(String l1, String l2, String l3, String l4) {
      this.langDefault = l1;
      this.langVaadinAdopt = l2;
      this.langH1Adopt = l3;
      this.enDefault = l4;
    }
    public String getLangDefault() {
      return this.langDefault;
    }
    public String getLangVaadinAdopt() {
      return this.langVaadinAdopt;
    }
    public String getLangH1Adopt() {
      return this.langH1Adopt;
    }
    public String getLangEN() {
      return this.enDefault;
    }
  }

  public static void main(String[] args) {
    Object[] enumValue = Key.class.getEnumConstants();
    for (Object constant : enumValue) {
      System.err.println("\"" + constant + "\", \"MoWare System Text\", \"0\", ");

    }
  }
}
