package org.modellwerkstatt.dataux.runtime.utils;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

public class ValueObjectReplacementFacility {
  public static IOFXValueObject getValueObjectOrNull(Object obj, String propertyName) {
    Object valueObject = MoJSON.get(obj, propertyName);
    if (valueObject instanceof IOFXValueObject) {
      return ((IOFXValueObject) valueObject);
    }
    return null;
  }
  public static Object execWithMethod(Object obj, String propertyName, Object param1) {
    Method method = null;
    String withMethod = "with" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    try {
      if (param1 instanceof Integer) {
        // reverse autoboxing of integer.
        method = obj.getClass().getMethod(withMethod, int.class);
        return method.invoke(obj, param1);

      } else if (param1 == null) {
        // quite a complecated case, we need to find the correct method, user wants to set null
        Method[] allMethods = obj.getClass().getMethods();
        for (Method m : allMethods) {
          if (m.getName().equals(withMethod)) {
            if (method != null) {
              throw new RuntimeException("ValueObjectReplacementFacility - Looking for '" + withMethod + "' with <unknown> parameter (for setting null), but multiple methods with same name found.");
            }
            method = m;
          }
        }
        if (method == null) {
          throw new RuntimeException("ValueObjectReplacementFacility - Looking for '" + withMethod + "' with <unknown> parameter (for setting null), but none found.");
        }

        // null is not working, convert it .
        return method.invoke(obj, new Object[]{null});

      } else {
        method = obj.getClass().getMethod(withMethod, param1.getClass());
        return method.invoke(obj, param1);
      }


    } catch (SecurityException e) {
      throw new RuntimeException("ValueObjectReplacementFacility - SecurityException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
    } catch (NoSuchMethodException e) {
      throw new RuntimeException("ValueObjectReplacementFacility - NoSuchMethodException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
    } catch (IllegalArgumentException e) {
      throw new RuntimeException("ValueObjectReplacementFacility - IllegalArgumentException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
    } catch (IllegalAccessException e) {
      throw new RuntimeException("ValueObjectReplacementFacility - IllegalAccessException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
    } catch (InvocationTargetException e) {
      throw new RuntimeException("ValueObjectReplacementFacility - InvocationTargetException - " + e.getMessage() + " / " + propertyName + " to '" + param1 + "'");
    }
  }
  public static void put(Object rootObj, String propPath, Object value) {
    // necessary to change at all ?
    Object currentValue = MoJSON.get(rootObj, propPath);
    if (currentValue == null) {
      // can not use equals ..
      if (currentValue == value) {
        return;
      }
    } else {
      if (currentValue.equals(value)) {
        return;
      }
    }

    // okay, we have to change ... do we have to check for valueObject?
    if (rootObj instanceof IOFXValueObject) {
      throw new RuntimeException("ValueObjectReplacementFacility - ValueObject directly bound to Delegates - thus no exchange of ValueObjects possible. Programming Error!");
    }
    if (propPath.contains(".")) {
      // yes check ...
      String remainingPath = propPath.substring(0, propPath.lastIndexOf("."));
      String fieldName = propPath.substring(propPath.lastIndexOf(".") + 1);
      IOFXValueObject valueObj = ValueObjectReplacementFacility.getValueObjectOrNull(rootObj, remainingPath);
      if (valueObj != null) {
        Object newValueObject = ValueObjectReplacementFacility.execWithMethod(valueObj, fieldName, value);
        // okay ... then replace the valueObject now ...
        ValueObjectReplacementFacility.put(rootObj, remainingPath, newValueObject);
        return;
      }
      // okay, this is not a value object.. simply replace prop
    }
    // path does not contain a .
    MoJSON.put(rootObj, propPath, value);
  }
}
