package org.modellwerkstatt.h2forms.core;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import org.modellwerkstatt.dataux.runtime.core.ApplicationMDI;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import java.util.Enumeration;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.dataux.runtime.core.FlagOnUiEvent;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import javax.servlet.http.HttpSessionBindingEvent;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;

public class H2Application implements IH2Controller, IToolkit_MainWindow {
  public static final String MESSAGE_GENERAL_ID = "message_";
  public static final String MESSAGE_ESC_CRTL_CODE = "message_esc";
  public static final String MESSAGE_OK_CRTL_CODE = "message_ok";
  private OFXUrlParams lastUrl;

  public static final String LOGIN_CODE = "login";
  public static final String LOGOUT_CODE = "logout";
  public static final String LOGGEDOUT_CODE = "loggedout";
  public static final String FROMVERSION_CODE = "fromversion";
  public static final String APPSTART_CODE = "appstart";
  public static final String REROUTE_CODE = "reroute";


  protected IH2UiFactory uiFactory;
  protected ApplicationMDI appController;
  protected ContextClient ctxCli;

  private List<H2Menu> currentTileMenu;
  private List<H2Menu> currentStartMenu;

  protected long currentAppFormSequence;
  protected String origHttpSessionId;
  protected String debugMessage;

  protected IToolkit_CommandContainerUi currentCommandUI;
  protected H2Dialog latestDialog;

  protected boolean initiallyExecutedStartupCmd;
  protected boolean removeFromSessionAndClose;
  protected boolean logoutRequested;

  protected String parDeployForwardUrl;
  protected String applicationStateText;
  protected String rerouteUrl;

  public H2Application(IH2UiFactory factory, IGenAppUiModule genApplication, AppJmxRegistration reghelper, ContextClient cli) {
    // no code is executed. Just setting references in constructors
    uiFactory = factory;

    ctxCli = cli;
    currentCommandUI = null;
    latestDialog = null;

    origHttpSessionId = null;
    rerouteUrl = null;
    removeFromSessionAndClose = false;
    appController = new ApplicationMDI(uiFactory, this, genApplication, reghelper, uiFactory.getContextStatics().getMowarePlatform());

    currentAppFormSequence = 0;
    logoutRequested = false;
    parDeployForwardUrl = null;
    debugMessage = "";
    applicationStateText = null;
  }


  public void initializeAndLogin(HttpServletRequest request, IOFXUserEnvironment userEnv, String startupInfo) {
    OFXUrlParams url = new OFXUrlParams();
    url.parse(request.getPathInfo());
    initiallyExecutedStartupCmd = appController.initializeApplication(url, uiFactory.getContextStatics().getGuessedServerName(), userEnv, ctxCli.getRemoteAddr(), startupInfo);

    // okay, logged in
    ctxCli.setUsername(userEnv.getUserName());
    ctxCli.setUserid(userEnv.getUserId());
    ctxCli.setLangIndex(userEnv.getLangIndex());

    ctxCli.setDynamicStatusInfo(appController.getDynamicStatusInfoOrSD());
    ctxCli.setNETWORK_PROBLEMS(uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.NETWORK_PROBLEMS));

    boolean useDebugPerDefault = uiFactory.isDebugUsers(userEnv.getUserName());
    appController.setDebug(useDebugPerDefault);
  }


  public void handleRequest(HttpServletRequest request, String cookieInfo) {
    String naviCrtl = request.getParameter("NaviCrtl");


    // Not provided in http GET, what is okay. 
    String formSequenceIdSt = request.getParameter("SequenceId");
    long recvformSequenceId = currentAppFormSequence;
    if (formSequenceIdSt != null) {
      recvformSequenceId = Long.valueOf(formSequenceIdSt);
    }

    String progressor = request.getParameter("Progressor");
    String devicesId = request.getParameter("DeviceId");
    String lastRequestLog = request.getParameter("LastRequestLog");
    if (lastRequestLog == null) {
      lastRequestLog = "";
    }
    long lastRequestDiffMillis = zeroOrReqParam(request, "LastRequestDiffMillis");
    long lastRequestDiffMillis2 = zeroOrReqParam(request, "LastRequestDiffMillis2");
    long lastRequestDiffMillis3 = zeroOrReqParam(request, "LastRequestDiffMillis3");
    appController.setuser_lastRequestDiffMillis(lastRequestDiffMillis, lastRequestDiffMillis2, lastRequestDiffMillis3, lastRequestLog);
    appController.setuser_progressor("" + progressor);
    appController.setuser_formseqId("frm " + request.getParameter("SequenceId") + " / cur " + currentAppFormSequence);
    ctxCli.setDeviceId(devicesId);
    appController.adjustDeviceID(ctxCli.getDeviceId());


    rerouteUrl = request.getParameter(REROUTE_CODE);
    if (rerouteUrl != null) {
      rerouteUrl += "?" + APPSTART_CODE + "=true";
    }

    lastUrl = new OFXUrlParams();
    lastUrl.parse(request.getPathInfo());
    applicationStateText = null;
    logoutRequested = LOGOUT_CODE.equals(lastUrl.getFirstOrEmpty()) || request.getParameter(LOGOUT_CODE) != null || LOGOUT_CODE.equals(naviCrtl);


    boolean initialRequest = currentAppFormSequence == 0;
    boolean appstartPresent = request.getParameter(APPSTART_CODE) != null;

    if (initialRequest && request.getParameter(FROMVERSION_CODE) != null) {
      // might be a POST from a killed session, which was a par dpl forwarded but not heavily used. 
      // fromVersion still present, but actually not a new version
      String fromVersion = request.getParameter(FROMVERSION_CODE);
      if (!(appController.getEscSwAppVersion().equals(fromVersion))) {
        applicationStateText = uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.APPLICATION_REPLACED);
      }
      naviCrtl = null;

    } else if (initialRequest && LOGIN_CODE.equals(naviCrtl)) {
      naviCrtl = null;

    } else if (initialRequest && !(noNaviCrtl_Get(naviCrtl))) {
      naviCrtl = null;
      applicationStateText = uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.APPLICATION_RESTARTED);
      // still wrong url, possibly

    }

    // process message of startup cmd if terminated in warning, precond o
    if (initiallyExecutedStartupCmd && initialRequest && latestDialog != null) {
      processNoneModalDialog();
    }

    Dux.hl("STATE - urlParams " + lastUrl.asUrl() + ", naviCrtl '" + naviCrtl + "', ui " + currentCommandUI);
    Dux.hl("        dialog " + latestDialog);
    Dux.hl("        seq " + currentAppFormSequence + ", startup " + appController.isStartupCmdRunning() + ", cmd " + appController.isCommandRunning());

    // decide now, might be resetted.  
    boolean noNavCrtl = noNaviCrtl_Get(naviCrtl);

    if (logoutRequested) {
      removeFromSessionAndClose = true;

    } else if (recvformSequenceId < currentAppFormSequence) {
      // This happens with browser refresh, sending the same post request again
      String msg = "App comm out of sync, request not handled, since currentAppFromSequence " + currentAppFormSequence + " not in sync with formSequenceId " + recvformSequenceId;
      internalHtmlProblemPrevented(request, msg);
      Dux.hl(msg);

    } else if (initialRequest && (initiallyExecutedStartupCmd || appController.isStartupCmdRunning())) {
      // if url is startup cmd itself, we end up with a get for the url. 
      Dux.hl("STRTUP - Initial request with startup cmd! Install cmd to start? " + lastUrl.hasCmdName());

      if (lastUrl.hasCmdName()) {
        // a warning dialog (cmd terminated then) might be open for startup cmd
        final OFXUrlParams toStartParam = lastUrl;
        appController.execAfterStartupOrNow(new Runnable() {
          @Override
          public void run() {
            Dux.hl("execAfterStartupOrNow() startup done, need to start url");
            // url has to be the same registration & execution
            hack_cmdInitDoneForwardUrlAdjustDlg(toStartParam);
          }
        });
      }

    } else if (noNavCrtl && appController.isStartupCmdRunning()) {
      Dux.hl("GET - Request, startup command not done yet, take as reload.");

    } else if (noNavCrtl && appController.isCommandRunning() && appstartPresent) {
      // browser (re) start (no login) and some cmd, or startup cmd still running
      // currentCommandUI might be null when latestDialog (with closing) is open
      Dux.hl("GET - Request, appstart true and some cmds running.");


    } else if (noNavCrtl) {
      // some GET, might be overwritten startup also or startup already processed

      Dux.hl("GET - killing dialog (and running cmds - " + appController.isCommandRunning() + ") start " + lastUrl.asUrl());

      latestDialog = null;
      if (appController.isCommandRunning()) {
        appController.logMowareTracing("", "", IOFXCoreReporter.RT, "Got a HTTP_GET/noNaviCrtlGiven and killing running cmds.", appController.fullApplicationCrtlState());
        // might lead to ex when latestDialog was show some close container runnable
        appController.internal_closeAllRunningCmds();
      }

      if (lastUrl.hasCmdName()) {
        startByParam(lastUrl);
        processNoneModalDialog();
      }

    } else {
      // - - - - STANDARD - - - - - - - 
      Dux.hl("POST - handle cmd or dialog... ");

      processDialogOrCommand(request, naviCrtl);

    }
  }


  public void processNoneModalDialog() {
    Dux.hl("latestDialog is " + latestDialog);
    // execute message handler immediately, this might also close down app crtl (e.g.par deploy) 
    if (latestDialog != null && !(latestDialog.isModalWithButtons()) && latestDialog.getRunnable() != null) {
      Dux.hl("RUNNING runnable");
      try {
        latestDialog.getRunnable().run(true);
        latestDialog.clearRunnable();

      } catch (Throwable t) {
        t.printStackTrace();
      } finally {
        Dux.hl("RUNNING runnable done... ");
      }

    }
  }

  public void processDialogOrCommand(HttpServletRequest request, String naviCrtl) {

    if (latestDialog == null && currentCommandUI == null) {
      internalHtmlProblemPrevented(request, "This can not happen - no dlg, no cmd. [" + latestDialog + " / " + currentCommandUI + "] with naviCrtl " + naviCrtl);

      throw new RuntimeException("This can not happen - no dlg, no cmd. [" + latestDialog + " / " + currentCommandUI + "]");
    }
    if (naviCrtl == null) {
      throw new RuntimeException("This can not happen - naviCrtl is null.");
    }


    if (latestDialog != null) {
      // Process dialog, or process command - not both.

      if (!(naviCrtl.startsWith(MESSAGE_GENERAL_ID))) {
        throw new RuntimeException("This can not happen.");

      } else {
        Dux.hl("Processing " + naviCrtl + " for Dialog [" + latestDialog.getText() + "]");

        IApplication.DlgRunnable runbl = latestDialog.getRunnable();
        boolean wasOk = (latestDialog.isCloseQuestion() ? MESSAGE_OK_CRTL_CODE.equals(naviCrtl) : true);
        latestDialog = null;
        if (runbl != null) {
          runbl.run(wasOk);
        }

      }

    } else {

      try {
        uiFactory.getRenderer().handleRequest(request, naviCrtl, currentCommandUI);

      } catch (H2FormRequestStateException ex) {
        String msg = ex.getMessage() + " in " + currentCommandUI + " (currentAppFormSequence " + currentAppFormSequence + ")\n" + appController.fullApplicationCrtlState();
        internalHtmlProblemPrevented(request, msg + "\n\n" + OFXConsoleHelper.stackTrace2String(ex));
      }

      processNoneModalDialog();

    }
  }


  public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
    currentAppFormSequence++;

    Dux.hl("RESPONSE - commandUi " + currentCommandUI + ", latestDialog " + latestDialog + " parDeployForwardUrl is " + parDeployForwardUrl);

    if (logoutRequested) {
      String url = uiFactory.getContextStatics().getServletPath() + "/?" + LOGGEDOUT_CODE + "=true";
      uiFactory.execLocationRedirect(response, url);


    } else if (parDeployForwardUrl != null) {
      // the appCrtl is already gone (is null)
      // remove from session is set. no need to reset rerouteUrl
      if (rerouteUrl == null) {
        uiFactory.execLocationRedirect(response, parDeployForwardUrl);
      } else {
        // do not route to this app, but to the caller.
        uiFactory.execLocationRedirect(response, rerouteUrl);
      }

    } else {
      // adjust debug modes
      ctxCli.setDebug(appController.isDebug());
      ctxCli.setBrandingId(appController.getUserEnvironment().getBrandingId());
      ctxCli.setDynamicStatusInfo(appController.getDynamicStatusInfoOrSD());

      // create page ...
      long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();
      ContextPage ctxPage = new ContextPage(currentAppFormSequence, xmlHttpReq, millis);
      ctxPage.setIsPreventHtmlCaching(H2ApplicationLoader.H2_INTERNAL_DEBUG || appController.getAppTelemetrics().isPreventHtmlCaching());
      ctxPage.setDebugMessage(debugMessage);
      ctxPage.setMainLandingMenu(currentTileMenu);
      ctxPage.setStartMenu(currentStartMenu);
      ctxPage.setAppStateText(applicationStateText);

      String redirectRequestedByUserService = appController.getLastRequestedRedirectAndReset();

      if (redirectRequestedByUserService != null) {
        // leave app... 
        uiFactory.execLocationRedirect(response, redirectRequestedByUserService);

      } else if (currentCommandUI != null) {
        // there is something to do in this app instance right now; we will render latestDialog also
        uiFactory.getRenderer().handleResponse(response, uiFactory.getContextStatics(), ctxCli, ctxPage, latestDialog, currentCommandUI);

      } else if (latestDialog == null && rerouteUrl == null && !(appController.isCommandRunning()) && lastUrl.hasCmdName()) {
        // in case no dialog, no reroute (typically), do the reset to home .. (prevent a redirect by adding /)
        uiFactory.execLocationRedirect(response, uiFactory.getContextStatics().getServletPath() + "/");

      } else if (rerouteUrl != null) {
        // instead of showing homescreen ... 
        if (latestDialog == null || latestDialog.isToast()) {
          // leave app... 
          uiFactory.execLocationRedirect(response, rerouteUrl);
          rerouteUrl = null;

        } else {
          if (!(latestDialog.isModalWithButtons())) {
            latestDialog.addButton(new H2Dialog.DialogButton(uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.OK_BUTTON), MESSAGE_OK_CRTL_CODE));
          }
          uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, uiFactory.getContextStatics(), ctxCli, ctxPage, latestDialog);
        }

      } else {
        // ok, default is landing page, might contain a dialog or not ...
        uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, uiFactory.getContextStatics(), ctxCli, ctxPage, latestDialog);

      }

      // redirects will also clear dlg.
      if (latestDialog != null && !(latestDialog.isModalWithButtons())) {
        // without buttons, do not show msg again..
        latestDialog = null;
      }

    }
  }

  public void hack_cmdInitDoneForwardUrlAdjustDlg(final OFXUrlParams toStart) {
    Dux.hl("toStart " + toStart.asUrl() + " - latestDlg " + latestDialog);
    if (!(toStart.hasCmdName())) {
      throw new RuntimeException("This can not happen. ToStart is " + toStart.asUrl());
    }

    // some important message first? If no buttons present, runnable slot should be available
    if (latestDialog != null && !(latestDialog.isModalWithButtons())) {
      if (latestDialog.getRunnable() != null) {
        throw new RuntimeException("This can not happen. Rnbl not null in " + latestDialog);
      }

      latestDialog.runnable = new IApplication.DlgRunnable() {
        @Override
        public void run(boolean confirmed) {
          startByParam(toStart);
          processNoneModalDialog();
        }
      };
      latestDialog.addButton(new H2Dialog.DialogButton(uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.OK_BUTTON), MESSAGE_OK_CRTL_CODE));




    } else if (latestDialog != null) {
      //  more complex dialog, for now - do not start consecutive cmd afterwards ...  



    } else {
      startByParam(toStart);
      processNoneModalDialog();

    }
  }

  public boolean noNaviCrtl_Get(String naviCrtl) {
    return naviCrtl == null || naviCrtl.trim().equals("");
  }

  public void internalHtmlProblemPrevented(HttpServletRequest request, String msg) {
    Enumeration<String> keyEnumeration = request.getParameterNames();
    String requestDump = "\n Current url path is " + request.getMethod() + " '" + request.getPathInfo() + "'\n";
    requestDump += "\nParameters:\n";

    while (keyEnumeration.hasMoreElements()) {
      String key = keyEnumeration.nextElement();
      requestDump += key + ": " + request.getParameter(key) + "\n";
    }

    keyEnumeration = request.getHeaderNames();
    requestDump += "\nHeaders:\n";
    while (keyEnumeration.hasMoreElements()) {
      String key = keyEnumeration.nextElement();
      requestDump += key + ": " + request.getHeader(key) + "\n";
    }

    keyEnumeration = request.getAttributeNames();
    requestDump += "\nAttributes:\n";
    while (keyEnumeration.hasMoreElements()) {
      String key = keyEnumeration.nextElement();
      requestDump += key + ": " + request.getAttribute(key) + "\n";
    }

    if (appController != null) {
      appController.logFrmwrkProblem("", "", IOFXCoreReporter.RT, msg, requestDump);

    } else {
      OFXLogger.log(H2Application.class, IOFXCoreReporter.LogPriority.ERROR, "[no app crtl available, not using logProblem()] " + msg + requestDump, null);

    }

  }

  public void closeApplicationAndExit() {
    removeFromSessionAndClose = true;
    currentCommandUI = null;
    // do not set appCrtl to null here !
  }

  public void showDialog(IToolkit_MainWindow.DlgType type, String text, IApplication.DlgRunnable callback) {

    if (latestDialog != null) {
      throw new RuntimeException("This can not happen. Dialog is " + latestDialog + " but overwritten by '" + text + "'");
    }

    if (type.equals(IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL)) {
      latestDialog = new H2Dialog(type, uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.QUESTION), text, callback);
      latestDialog.addButton(new H2Dialog.DialogButton(uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.NO_BUTTON), MESSAGE_ESC_CRTL_CODE));
      latestDialog.addButton(new H2Dialog.DialogButton(uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.DISCARD_BUTTON), MESSAGE_OK_CRTL_CODE));

    } else if (type.equals(IToolkit_MainWindow.DlgType.ERROR_LARGE) || type.equals(IToolkit_MainWindow.DlgType.ERROR_SMALL)) {
      latestDialog = new H2Dialog(type, uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.ERROR), text, callback);
      latestDialog.addButton(new H2Dialog.DialogButton(uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.OK_BUTTON), MESSAGE_OK_CRTL_CODE));

    } else {
      latestDialog = new H2Dialog(type, uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.INFORMATION), text, callback);

    }
  }

  public void showProblemsDialog(List<IOFXProblem> problems, IApplication.DlgRunnable callback) {
    if (latestDialog != null) {
      throw new RuntimeException("This can not happen. Dialog is " + latestDialog + " but overwritten by " + FlagOnUiEvent.asSimpleString(problems));
    }
    latestDialog = new H2Dialog(problems, callback);
  }


  public void showGraphDebugger(List<Object> graph, String controllerInfo) {
    // not implemented yet
  }

  public void addStatusInformation(String info) {
  }
  public void setToastMessage(String info) {
    // only info large will be gray - other infos handled as errors.
    latestDialog = new H2Dialog(true, IToolkit_MainWindow.DlgType.INFO_SMALL, uiFactory.getSystemLabel(ctxCli.getLangIndex(), MoWareTranslations.Key.INFORMATION), info, null);
  }

  @Override
  public void setAppInfo(String appName, String version, String dynTitle, int brandingId) {
    // not implemented; taken from ctxStatics
  }
  public void setMenuAndInit(int langIndex, Menu startMenu, Menu extrasMenu, Menu helpMenu) {
    currentStartMenu = ListSequence.fromList(new ArrayList<H2Menu>());
    int i = 0;
    for (CmdAction item : startMenu.getAllCmdActionsOfMenu()) {
      boolean enabled = item.reevalEnabled();
      H2Menu m = new H2Menu("_startmenu" + i, item, (item.hideWhenDisabled ? enabled : true), enabled, null, null);
      ListSequence.fromList(currentStartMenu).addElement(m);
      i++;
    }
    if (ListSequence.fromList(currentStartMenu).count() == 0) {
      currentStartMenu = null;
    }
  }
  public void showTiles(List<TileAction> tiles) {
    // this is the main menu...
    currentTileMenu = ListSequence.fromList(new ArrayList<H2Menu>());
    int i = 0;
    for (TileAction item : tiles) {
      boolean enabled = item.getAction().reevalEnabled();
      H2Menu m = new H2Menu("_tilemenu" + i, item.getAction(), (item.getAction().hideWhenDisabled ? enabled : true), enabled, item.getColor(), null);
      ListSequence.fromList(currentTileMenu).addElement(m);
      i++;
    }
    if (ListSequence.fromList(currentTileMenu).count() == 0) {
      currentTileMenu = null;
    }
  }
  public void addTab(IToolkit_CommandContainerUi ui) {
    currentCommandUI = ui;
  }
  public void focusTab(IToolkit_CommandContainerUi ui) {
    currentCommandUI = ui;
    // Do not adjust currenTab, since focussing on not top level tab should no be possible
  }
  public void ensureTabClosed(IToolkit_CommandContainerUi ui) {
    // we will receive a focusTab event for the next correct container ui
    currentCommandUI = null;
  }
  public void ensureHotkeyAvailable(List<String> hotkeys) {
  }
  public void execEventInBackground(ICommandContainer sender, Runnable r) {
    throw new RuntimeException("Background processing not supported in this implementation.");
  }
  public void execEventInForeground(ICommandContainer sender, UxEvent event) {
    throw new RuntimeException("Not supported in h2forms, you should already be in an foreground thread?");
  }
  public boolean inUiThread() {
    // ignore thread name nio / exec etc. on undeploy, closing aps is also done from 'containerbackgroundprocessor' 
    return true;
  }
  public void valueBound(HttpSessionBindingEvent event) {
    if (origHttpSessionId == null) {
      origHttpSessionId = event.getSession().getId();
    }
  }
  public void valueUnbound(HttpSessionBindingEvent event) {
    externalCloseApplicationWithSessionId(event.getSession().getId());
  }

  public void externalCloseApplicationWithSessionId(String sessionId) {
    if (appController != null && !(appController.inShutdownMode())) {
      appController.internal_immediatelyShutdown();
    }
  }

  public IH2Controller swapToNextController() {
    return null;
  }

  public boolean isRemoveFromSessionAndClose() {
    return removeFromSessionAndClose;
  }
  public boolean hasCommitableSessionRunning() {
    return !(appController.noGraphsToCommit());
  }

  public void setCurrentTabModal(boolean lock) {
  }
  @Override
  public void parDeploymentForwardNow() {
    Dux.hl("parallel deployment, forward to next version. lastUrl: " + lastUrl);

    parDeployForwardUrl = uiFactory.getContextStatics().getServletPath();
    if (lastUrl != null) {
      parDeployForwardUrl += lastUrl.asUrl();
    }
    // prevent redirections.
    if (!(parDeployForwardUrl.endsWith("/"))) {
      parDeployForwardUrl += "/";
    }
    parDeployForwardUrl += "?" + FROMVERSION_CODE + "=" + appController.getEscSwAppVersion();

    removeFromSessionAndClose = true;
  }
  @Override
  public String toString() {
    return (currentCommandUI == null ? "currentUi null" : currentCommandUI.toString());
  }

  public String getShortUserInfo() {
    return (appController == null ? "appController null" : appController.getUserName());
  }
  public long zeroOrReqParam(HttpServletRequest req, String paramName) {
    String paramValue = req.getParameter(paramName);
    long ret = 0;
    if (paramValue != null && !("".equals(paramValue.trim()))) {
      ret = Long.parseLong(paramValue.trim());
    }
    return ret;
  }

  public void startByParam(final OFXUrlParams param) {
    boolean found = false;

    IOFXCmdModule.CmdUrlDefaults def = appController.getUrlDefaultFor(uiFactory.getAllCmdUrlDefaults(), param);

    if (def != null) {
      found = true;
      BasisCmdStart start = appController.cmdStartForUrlDefault(def, param, appController.getMainWindowEvalSession());

      if (start == null) {
        showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, String.format(uiFactory.getSystemLabel(appController.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_NOT_ENABLED), def.url), null);

      } else {
        appController.receiveAndProcess(start);
      }


    } else if (param.numParams() == 0) {
      H2Menu item = ListSequence.fromList(currentTileMenu).findFirst((it) -> it.isUri(param.getCmdName()));
      if (item == null) {
        item = ListSequence.fromList(currentStartMenu).findFirst((it) -> it.isUri(param.getCmdName()));
      }
      if (item != null) {
        found = true;
        boolean enabled = item.getAction().reevalEnabled();
        if (!(enabled)) {
          showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, String.format(uiFactory.getSystemLabel(appController.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_NOT_ENABLED), item.label), null);
        } else {
          item.getAction().startCommand();

        }
      }
    }

    if (!(found)) {
      String someCmds = "".join(", ", ListSequence.fromList(currentTileMenu).select((it) -> it.uri));
      showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, String.format(uiFactory.getSystemLabel(appController.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_NOT_AVAILABLE), someCmds), null);

    }
  }

  public static class H2Menu {
    public String label;
    public String uri;
    public CmdAction actionToCall;
    public String cntNumStr;
    public String[] splittedLabel;
    public boolean enabled;
    public boolean visible;

    public String color;
    public String materialImgName;

    public CmdAction getAction() {
      return this.actionToCall;
    }
    public String getUri() {
      return this.uri;
    }
    public boolean isUri(String uri) {
      return this.uri.equals(uri);
    }
    /**
     * 
     * @deprecated 
     */
    @Deprecated
    public String uriFromAction(CmdAction act) {
      return "_" + act.labelText.toLowerCase().replaceAll("\\W", "");
    }
    public H2Menu(String aUri, CmdAction act, boolean visible, boolean enabled, String color, String matImg) {
      this.actionToCall = act;
      this.label = act.labelText;
      this.uri = aUri;
      this.cntNumStr = null;
      this.splittedLabel = act.labelText.split("\\r?\\n");

      // replace () brackets, in case we have an integer in between
      for (int i = 0; i < this.splittedLabel.length; i++) {
        String lab = this.splittedLabel[i];
        if (lab.contains("(") && lab.contains(")")) {
          int openIndex = lab.indexOf("(");
          int closeIndex = lab.indexOf(")");
          String num = lab.substring(openIndex + 1, closeIndex);
          String cutted = lab.substring(0, openIndex - 1) + lab.substring(closeIndex + 1, lab.length());
          if (num.matches("-?\\d+")) {
            this.splittedLabel[i] = cutted;
            this.cntNumStr = num;
          }

        }
      }
      this.visible = visible;
      this.enabled = enabled;
      this.color = color;
      this.materialImgName = matImg;
    }
  }
}
