package org.modellwerkstatt.h2forms.core;

/*Generated by MPS */

import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.core.FlagOnUiEvent;

public class H2Dialog {
  protected String text;
  protected boolean toastMessageOnly;
  protected List<DialogButton> buttons;
  protected String heading;
  protected IApplication.DlgRunnable runnable;
  protected IToolkit_MainWindow.DlgType type;
  protected List<IOFXProblem> listOfProblems;
  protected boolean reloadEnabled;

  public H2Dialog(IToolkit_MainWindow.DlgType t, String head, String msg, IApplication.DlgRunnable run) {
    heading = head;
    text = msg;
    runnable = run;
    buttons = ListSequence.fromList(new ArrayList<DialogButton>());
    toastMessageOnly = false;
    type = t;
    reloadEnabled = false;
  }

  public H2Dialog(boolean toastMsg, IToolkit_MainWindow.DlgType t, String head, String msg, IApplication.DlgRunnable run) {
    this(t, head, msg, run);
    toastMessageOnly = toastMsg;
  }

  public H2Dialog(List<IOFXProblem> problems, IApplication.DlgRunnable run) {
    this(null, null, null, run);
    listOfProblems = problems;
  }

  public String getText() {
    return text;
  }
  public String getTextBr() {
    return text.replace("\n", "<br/>");
  }
  public String getHeading() {
    return heading;
  }
  public List<DialogButton> getButtons() {
    return buttons;
  }
  public List<IOFXProblem> getProblems() {
    return listOfProblems;
  }
  public boolean isModalWithButtons() {
    return ListSequence.fromList(buttons).count() > 0;
  }
  public boolean isReloadEnabled() {
    return reloadEnabled;
  }
  public IToolkit_MainWindow.DlgType getType() {
    return type;
  }
  public IApplication.DlgRunnable getRunnable() {
    return runnable;
  }
  public void clearRunnable() {
    runnable = null;
  }
  public boolean isCloseQuestion() {
    return IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL.equals(type);
  }
  public boolean isErrorLarge() {
    return IToolkit_MainWindow.DlgType.ERROR_LARGE.equals(type);
  }
  public boolean isErrorSmall() {
    return IToolkit_MainWindow.DlgType.ERROR_SMALL.equals(type);
  }
  public boolean isInfoLargeOrSmall() {
    return IToolkit_MainWindow.DlgType.INFO_LARGE.equals(type) || IToolkit_MainWindow.DlgType.INFO_SMALL.equals(type);
  }
  public boolean isToast() {
    return IToolkit_MainWindow.DlgType.INFO_SMALL.equals(type) && toastMessageOnly;
  }
  public boolean isInfoSmall() {
    return IToolkit_MainWindow.DlgType.INFO_SMALL.equals(type);
  }
  public boolean isInfoLarge() {
    return IToolkit_MainWindow.DlgType.INFO_LARGE.equals(type);
  }
  public boolean isListOfProblems() {
    return listOfProblems != null && ListSequence.fromList(listOfProblems).count() > 0;
  }
  public void addButton(DialogButton btn) {
    ListSequence.fromList(buttons).addElement(btn);
  }
  public H2Dialog withReload() {
    reloadEnabled = true;
    return this;
  }
  public static class DialogButton {
    public String label;
    public String buttonCode;

    public DialogButton(String label, String code) {
      this.label = label;
      this.buttonCode = code;
    }
  }



  @Override
  public String toString() {
    String result = (text == null ? "" : text);
    if (listOfProblems != null) {
      result += " " + FlagOnUiEvent.asSimpleString(listOfProblems);
    }
    result = ((result == null ? null : result.trim()));


    int maxLength = ((result.length() < 30) ? result.length() : 30);
    String trimmedText = result.substring(0, maxLength);

    return "[H2Dlg " + type + ": " + trimmedText + "....  (rnbl=" + (runnable != null) + " modal=" + isModalWithButtons() + ")]";
  }
}
