package org.modellwerkstatt.h2forms.mdeauth;

/*Generated by MPS */

import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.h2forms.core.H2Application;
import org.modellwerkstatt.h2forms.core.ContextClient;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import javax.servlet.http.HttpSession;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.ContextPage;
import javax.servlet.http.HttpSessionBindingEvent;

public class H2MpreisNoLoginAuth implements IH2Controller {

  protected IH2UiFactory uiFactory;
  protected IGenAppUiModule appMod;
  protected AppJmxRegistration jmxHelper;

  protected H2Application application;
  protected ContextClient client;

  protected String errorMessage;


  public H2MpreisNoLoginAuth(IH2UiFactory factory, IGenAppUiModule app, AppJmxRegistration jmx, ContextClient cli) {
    uiFactory = factory;
    appMod = app;
    jmxHelper = jmx;
    client = cli;
  }

  public static void setSessionUserName(IH2UiFactory factory, HttpServletRequest req, IOFXUserEnvironment userEnv) {
    HttpSession session = req.getSession();

    session.setAttribute("userName", userEnv.getUserName() + " - " + userEnv.getDeviceName() + "/" + userEnv.getDeviceSwName() + " " + factory.getRemoteAddr(req));
  }

  public static void detectAndSetClient(HttpServletRequest request, ContextClient client) {
    String userAgent = "";

    if (request.getHeader("user-agent") != null) {
      userAgent = request.getHeader("user-agent");
    }

    // Zebra Enterprise Browser?
    String requestedWith = request.getHeader("x-requested-with");
    Dux.hl("UserAgen is '" + userAgent + "' and requested-with '" + requestedWith + "'");

    ContextClient.DevicesSw deviceSwDetected = ContextClient.DevicesSw.STRICH;
    if (userAgent.contains("EB5")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_50;

    } else if (userAgent.contains("EB35") || userAgent.contains("EB37")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_35;

    } else if (userAgent.contains("EB32") || userAgent.contains("EB3")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_32;

    } else if (userAgent.contains("EB2")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;

    } else if (userAgent.contains("EB18")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_18;
      throw new RuntimeException("Zebra EB 18 is no longer supported. (Sep 23)");

    } else if (userAgent.contains("TC25")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;

    } else if (userAgent.contains("TC26")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_32;

    } else if (userAgent.contains("TC56")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;

    } else if (userAgent.contains("TC57")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_35;

    } else if (userAgent.contains("TC27")) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_50;

    } else if ("com.symbol.enterprisebrowser".equals(requestedWith) || "com.zebra.mdna.enterprisebrowser".equals(requestedWith)) {
      deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;

    }

    // default client not interresting
    client.setDevice("");
    if (userAgent.contains("TC")) {
      int firstIndex = userAgent.indexOf("TC");
      if (firstIndex >= 0 && userAgent.length() > firstIndex + 5) {
        client.setDevice(userAgent.substring(firstIndex, firstIndex + 4));
      }
    }

    // typicall, this is not a POST, DeviceId not present
    client.setDeviceId(request.getParameter("DeviceId"));
    if (client.getDeviceId() == null || "".equals(client.getDeviceId().trim())) {
      // try esn in user agent? maybe the field is present
      client.setDeviceId(getESN(userAgent));
    }

    client.setDeviceSw(deviceSwDetected);
  }


  public void handleRequest(HttpServletRequest request, String cookieInfo) {

    application = null;

    detectAndSetClient(request, client);

    LoginController loginCrtl = new LoginController(uiFactory, uiFactory.getContextStatics().getMowarePlatform(), uiFactory.getContextStatics().getGuessedServerName(), client.getRemoteAddr());

    loginCrtl.logOnCoreReporter("", "", "org.modellwerkstatt.h2forms.mdeauth.H2Login", IOFXCoreReporter.LogPriority.INFO, "While login: [" + client + "] from '" + request.getHeader("user-agent") + "'", null);

    // Exceptions handled internally
    UserEnvironmentInformation env = new UserEnvironmentInformation();
    env.setDevice(client.getDevice(), "" + client.getDeviceSw(), client.getDeviceId());



    String loginUserParamName = request.getParameter("username");
    if (loginUserParamName == null) {
      loginUserParamName = client.getRemoteAddr();
    }
    errorMessage = loginCrtl.checkLoginPrepareUserEnv(loginUserParamName, "", env, appMod);
    Dux.hl("");
    Dux.hl("- - - - - - - - - checkLoginPrepareUserEnv for " + loginUserParamName + " -> " + errorMessage);

    if (errorMessage == null) {
      setSessionUserName(uiFactory, request, env);

      // successfully logged in
      application = new H2Application(uiFactory, appMod, jmxHelper, client);
      application.initializeAndLogin(request, env, cookieInfo);
    }

  }
  public String getShortUserInfo() {
    return client.getRemoteAddr();
  }

  public IH2Controller swapToNextController() {
    return application;
  }
  public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
    // if we r called, we were not able to log in.

    H2Dialog h2msg = new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, uiFactory.getSystemLabel(-1, MoWareTranslations.Key.ERROR), errorMessage, null);
    long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();

    // just display error msg, no login, no app tiles
    uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, uiFactory.getContextStatics(), client, new ContextPage(0, xmlHttpReq, millis), h2msg);
  }
  public boolean isRemoveFromSessionAndClose() {
    // always true, remove it quickly.
    return true;
  }
  public boolean hasCommitableSessionRunning() {
    return false;
  }
  public void valueBound(HttpSessionBindingEvent event) {
  }
  public void valueUnbound(HttpSessionBindingEvent event) {
    // we are stateless anyway
    externalCloseApplicationWithSessionId("null");
  }
  public void externalCloseApplicationWithSessionId(String sessionId) {
    uiFactory = null;
    appMod = null;
    jmxHelper = null;
  }


  private static String getESN(String userAgent) {
    String ESN_IDENTIFIER = "esn=";
    String esn = "";

    if (userAgent != null && userAgent.toLowerCase().contains(ESN_IDENTIFIER)) {
      String agent = userAgent.toLowerCase();
      int start = agent.indexOf(ESN_IDENTIFIER) + ESN_IDENTIFIER.length();
      while (start < agent.length() && Character.isDigit(agent.charAt(start))) {
        esn += agent.charAt(start);
        start++;
      }
    }
    return esn;
  }

  public static void main(String[] args) {
    String st = "Mozilla/5.0 (Linux; Android 7.1.2; ESNX=1234TC56 Build/02-07-08.00-NN-U00-STD; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/73.0.3683.90 Mobile Safari/537.36 MAC=40:83:DE:E1:32:01 ESN=17080522506316";

    System.err.println("> " + getESN(st));

  }
}
