package org.modellwerkstatt.h2forms.mdeauth;

/*Generated by MPS */

import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.h2forms.core.H2Application;
import org.modellwerkstatt.h2forms.core.ContextClient;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.ContextPage;
import javax.servlet.http.HttpSessionBindingEvent;

public class H2MpreisTrialFirstAuth implements IH2Controller {
  protected static final String USERNAME = "loginUserName";
  protected static final String PASSWORD = "password";
  protected static final String ERRORMESSAGE = "message";

  protected IH2UiFactory uiFactory;
  protected IGenAppUiModule appMod;
  protected AppJmxRegistration jmxHelper;

  protected H2Application application;
  protected ContextClient client;

  protected String errorMessage;
  protected boolean tryAutoIpLogin;
  protected boolean execCleanRedirectToHome;
  protected String lastUrlLocation;


  public H2MpreisTrialFirstAuth(IH2UiFactory factory, IGenAppUiModule app, AppJmxRegistration jmx, ContextClient cli) {
    uiFactory = factory;
    appMod = app;
    jmxHelper = jmx;
    client = cli;
    tryAutoIpLogin = true;
    lastUrlLocation = factory.getContextStatics().getServletPath();
    if (!(lastUrlLocation.endsWith("/"))) {
      lastUrlLocation += "/";
    }
  }


  public void handleRequest(HttpServletRequest request, String cookieInfo) {
    application = null;
    lastUrlLocation = request.getRequestURL().toString();

    H2MpreisNoLoginAuth.detectAndSetClient(request, client);

    LoginController loginCrtl = new LoginController(uiFactory, uiFactory.getContextStatics().getMowarePlatform(), uiFactory.getContextStatics().getGuessedServerName(), client.getRemoteAddr());

    loginCrtl.logOnCoreReporter("", "", "org.modellwerkstatt.h2forms.mdeauth.H2Login", IOFXCoreReporter.LogPriority.INFO, "While login: [" + client + "] from '" + request.getHeader("user-agent") + "'", null);

    // Exceptions handled internally
    UserEnvironmentInformation env = new UserEnvironmentInformation();
    env.setDevice(client.getDevice(), "" + client.getDeviceSw(), client.getDeviceId());


    String loginUserParamName = request.getParameter(USERNAME);
    String password = request.getParameter(PASSWORD);


    execCleanRedirectToHome = request.getParameter(H2Application.LOGGEDOUT_CODE) != null;

    if (execCleanRedirectToHome) {
      tryAutoIpLogin = false;
    }

    if (tryAutoIpLogin) {
      String userName = client.getRemoteAddr();
      if (loginUserParamName != null) {
        userName = loginUserParamName;
      }

      errorMessage = loginCrtl.checkLoginPrepareUserEnv(userName, "", env, appMod);
      tryAutoIpLogin = false;

      if (errorMessage == null) {
        H2MpreisNoLoginAuth.setSessionUserName(uiFactory, request, env);
        // successfully logged in
        application = new H2Application(uiFactory, appMod, jmxHelper, client);
        application.initializeAndLogin(request, env, cookieInfo);
      }
      // do not show any initial error msg
      errorMessage = null;

    } else if (execCleanRedirectToHome) {
      // do nothing, just wait to get the login page rendered


    } else {
      // pos login, try it
      if (loginUserParamName != null) {
        errorMessage = loginCrtl.checkLoginPrepareUserEnv(loginUserParamName, password, env, appMod);

        if (errorMessage == null) {
          Dux.hl("- - - - - - - logging in user " + env.getUserName() + ", creating H2Application");
          H2MpreisNoLoginAuth.setSessionUserName(uiFactory, request, env);

          // successfully logged in
          application = new H2Application(uiFactory, appMod, jmxHelper, client);
          application.initializeAndLogin(request, env, cookieInfo);
        }

      }

    }


  }
  public String getShortUserInfo() {
    return client.getRemoteAddr();
  }

  public IH2Controller swapToNextController() {
    return application;
  }
  public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
    if (execCleanRedirectToHome) {
      execCleanRedirectToHome = false;
      uiFactory.execLocationRedirect(response, lastUrlLocation);
      return;
    }


    // if we r called, we were not able to log in.
    H2Dialog h2msg = null;
    if (errorMessage != null) {
      h2msg = new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, uiFactory.getSystemLabel(-1, MoWareTranslations.Key.ERROR), errorMessage, null);
    }
    long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();

    uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LOGIN_PAGE, response, uiFactory.getContextStatics(), client, new ContextPage(0, xmlHttpReq, millis), h2msg);
  }

  public boolean isRemoveFromSessionAndClose() {
    // always true, remove it quickly.
    if (application != null) {
      return true;
    }
    return false;
  }
  public boolean hasCommitableSessionRunning() {
    return false;
  }
  public void valueBound(HttpSessionBindingEvent event) {
  }
  public void valueUnbound(HttpSessionBindingEvent event) {
    // we are stateless anyway
    externalCloseApplicationWithSessionId("null");
  }
  public void externalCloseApplicationWithSessionId(String sessionId) {
    uiFactory = null;
    appMod = null;
    jmxHelper = null;
  }


}
