package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import java.io.Writer;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractForm {
  public static final String TITLE_TEXT = "titleText";
  public static final String LIST_OF_PROBLEMS = "listOfProblems";
  public static final String CHILDREN = "children";
  public static final String DELEGATES = "delegates";
  public static final String ACTIONS = "actions";
  public static final String TOPBAR_ACTIONS = "topBarActions";
  public static final String DROPDOWN_ACTIONS = "dropDownActions";
  public static final String HAS_VISIBLE_ACTIONS = "hasVisibleActions";
  public static final String ACCORDION_ID = "accordionId";

  public static final String FOOTER = "footer";
  public static final String TABLE_ROWS = "tableRows";
  public static final String TABLE_COLUMNS = "tableColumns";
  public static final String CURRENT_SELECTION = "currentSelection";

  public static final String STATICS_CTX = "statics";
  public static final String CLIENT_CTX = "client";
  public static final String PAGE_CTX = "page";
  public static final String FORM = "form";
  public static final String WINDOW_TITLE = "windowTitle";
  public static final String NOTIFICATION_TEXT = "notificationText";
  public static final String SPLITTED_PAGE_TITLE = "splittedPageTitleText";
  public static final String DIALOG = "dialog";
  public static final String KEYBOARD = "keyboard";
  public static final String CONCLUSIONS = "conclusions";
  public static final String ESC_CONCLUSION = "escConclusion";
  public static final String SCAN_CONCLUSION = "scanConclusion";
  public static final String GO_CONCLUSION = "goConclusion";
  public static final String DEFAULT_CONCLUSION = "defaultConclusion";
  public static final String FORM_ID = "formId";
  public static final String SCROLL_ENABLED = "scroll";
  public static final String OPTIM_KEYBAORD = "optimKeyboard";


  private boolean initBeforeRenderDone;
  private List<IOFXProblem> listOfProblems;
  private String titleText;
  private String[] splittedtitleText;
  private int formId;
  private boolean scrollEnabled;


  protected Writer writerToUse;
  protected ContextStatics statics;
  protected ContextClient client;
  protected ContextPage page;
  protected PebbleTemplate compiledTextEditorTemplate;

  public AbstractForm(PebbleTemplate template) {
    compiledTextEditorTemplate = template;
    initBeforeRenderDone = false;
    titleText = null;
    splittedtitleText = null;
    listOfProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());
  }

  public void initBeforeRender(int id, Writer writer, ContextStatics stat, ContextClient clnt, ContextPage pg) {
    writerToUse = writer;
    statics = stat;
    client = clnt;
    page = pg;
    initBeforeRenderDone = true;
    formId = id;
    scrollEnabled = stat.isScroll();
  }
  public Map<String, Object> initAndGetRenderMap() {
    if (!(initBeforeRenderDone)) {
      throw new IllegalStateException("Programming error - initBeforeRender() not called.");
    }

    // initial size is 16, can hold 12 elements before resize
    Map<String, Object> renderMap = MapSequence.fromMap(new HashMap<String, Object>());
    initBeforeRenderDone = false;
    MapSequence.fromMap(renderMap).put(TITLE_TEXT, titleText);
    MapSequence.fromMap(renderMap).put(LIST_OF_PROBLEMS, listOfProblems);
    MapSequence.fromMap(renderMap).put(SPLITTED_PAGE_TITLE, splittedtitleText);

    MapSequence.fromMap(renderMap).put(STATICS_CTX, statics);
    MapSequence.fromMap(renderMap).put(CLIENT_CTX, client);
    MapSequence.fromMap(renderMap).put(PAGE_CTX, page);
    MapSequence.fromMap(renderMap).put(FORM_ID, formId);
    MapSequence.fromMap(renderMap).put(SCROLL_ENABLED, scrollEnabled);

    return renderMap;
  }
  public void setTitleText(String text) {
    if (text != null && !(text.trim().equals(""))) {
      titleText = text;
      splittedtitleText = titleText.split("\\r?\\n");

    } else {
      titleText = null;
      splittedtitleText = null;

    }
  }

  public void setProblems(List<IOFXProblem> lop) {
    listOfProblems = lop;
  }

  public List<IOFXProblem> getProblems() {
    return listOfProblems;
  }

  public IOFXSession.IUxEventActionable getResolveActionToTrigger(String trigger) {
    int id = Integer.valueOf(trigger.split("_")[1]);
    for (IOFXProblem prblm : listOfProblems) {
      IOFXSession.IUxEventActionable action = prblm.getResolveActionOrNull();
      if (action != null) {
        if (action.getTriggerCode() == id) {
          return action;
        }
      }
    }
    return null;
  }

  public String[] getSplittedPageTitleText() {
    return splittedtitleText;
  }

  public abstract void toHtml() throws IOException;

  public abstract boolean actionInForm(int formId, int selectionNum, int actionId);

  public abstract void delegateDataInForm(HttpServletRequest request);

  public abstract Object myRequestFocus();

  public abstract boolean delegatesNeedKeyboard();

  public abstract AbstractEditor firstEditorFocused();

  public abstract String debugInfo();

  public void afterFullUiInitialized() {
  }
  public static class PebAction {
    public String label;
    public String[] splittedLabel;
    public boolean enabled;
    public boolean hideOnDisabled;
    public boolean visible;

    public String origImgName;
    public String materialImgName;
    public String hotKey;

    public int popupMenuId;
    public int triggerCode;

    public PebAction(String label, boolean hideOnDisabled, String img1, String imgConv, int popMenuId, int triggerCode, String hk) {
      this.label = label;
      this.splittedLabel = label.split("\\r?\\n");
      this.hideOnDisabled = hideOnDisabled;
      this.enabled = false;
      this.visible = false;

      this.origImgName = img1;
      this.materialImgName = imgConv;
      this.hotKey = hk;

      this.popupMenuId = popMenuId;
      this.triggerCode = triggerCode;
    }

    public boolean hasText() {
      return this.label != null && !("".equals(this.label));
    }
    public boolean hasImage() {
      return this.origImgName != null && !("".equals(this.origImgName));
    }

    public void adjustEnabled(boolean enbld) {
      this.enabled = enbld;
      this.visible = true;
      if (this.hideOnDisabled && !(enbld)) {
        this.visible = false;
      }
    }

  }
}
