package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.objectflow.runtime.OFXConclusionInformation;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.dataux.runtime.core.CommandContainer;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import java.util.Map;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.h2forms.core.H2ColorUtil;

public class CommandContainerUi implements IToolkit_CommandContainerUi {
  private ICommandContainer cmdContainer;

  private AbstractForm form;
  private PebbleTemplate template;

  private String windowTitle;
  private String uiColor;
  private String notificationText;

  private int lastScrollTopPosition;
  private boolean scrollAdjustEnabled;
  private boolean optimKeyboard;



  private List<AbstractForm.PebAction> conclusions;

  public CommandContainerUi(PebbleTemplate commandUiTemplate, boolean scrollAdjustEnbld, boolean keyboardOptim) {
    template = commandUiTemplate;
    notificationText = null;
    lastScrollTopPosition = 0;
    scrollAdjustEnabled = scrollAdjustEnbld;
    optimKeyboard = keyboardOptim;
  }

  public void setCommandContainer(ICommandContainer container) {
    cmdContainer = container;
  }

  public void show(String wd, IToolkit_Form content) {
    windowTitle = wd;
    form = ((AbstractForm) content);
  }


  public void setContent(IToolkit_Form content) {
    if (form != content) {
      form = ((AbstractForm) content);
      lastScrollTopPosition = 0;
    }
  }
  @Override
  public void adjustWindowTitle(String title) {
    windowTitle = title;
  }

  public void setNotification(String notificat) {
    notificationText = notificat;
  }

  public void setConclusions(List<OFXConclusionInformation> concInfos, List<String> additionalHotkeys) {
    conclusions = ListSequence.fromList(new ArrayList<AbstractForm.PebAction>());
    for (OFXConclusionInformation con : concInfos) {
      // material icon font bug on old browsers
      AbstractForm.PebAction ac = new AbstractForm.PebAction(con.buttonTitle, con.hideWhenDisabled, con.iconName, MaterialIconsConverter.codeFor(con.iconName), con.conclusionHashCode, con.conclusionHashCode, con.hotkey);
      ac.adjustEnabled(con.enabled);
      ListSequence.fromList(conclusions).addElement(ac);
    }
  }

  public void reevalConclusions(List<OFXConclusionInformation> conclusionsToCheck) {
    for (int i = 0; i < ListSequence.fromList(conclusions).count(); i++) {
      OFXConclusionInformation aToCheck = conclusionsToCheck.get(i);
      AbstractForm.PebAction aExisting = ListSequence.fromList(conclusions).getElement(i);
      if (aExisting.triggerCode != aToCheck.conclusionHashCode) {
        throw new IllegalStateException("Conclusions out of sync between set() and reeval() ?? " + conclusions + " vs " + conclusionsToCheck);
      }

      aExisting.adjustEnabled(aToCheck.enabled);
    }
  }

  public void delayedRequestFocus() {
    form.myRequestFocus();
  }

  public void delayedAfterFullUiInitialized() {
  }

  public void close() {
  }

  public void handleRequest(HttpServletRequest request, String naviCrtl) {
    String selectionId = request.getParameter("SelectionId");

    Dux.hl("CommandContainerUI " + cmdContainer + " taking over, lastScrollTopPosition is " + lastScrollTopPosition + " vs. from request " + request.getParameter("ScrollPosition"));

    String scrollPosString = request.getParameter("ScrollPosition");
    if (scrollPosString != null && scrollAdjustEnabled) {
      int scrollPos = Integer.parseInt(scrollPosString);
      if (scrollPos >= 0) {
        lastScrollTopPosition = scrollPos;
      }
    }


    if (naviCrtl == null || selectionId == null) {
      // okay, this is simply a page refresh. do not change current state just render
      // html again.

    } else if (naviCrtl.startsWith("resolve_")) {
      IOFXSession.IUxEventActionable action = form.getResolveActionToTrigger(naviCrtl);
      if (action == null) {
        throw new RuntimeException("This can not happen: While looking for " + naviCrtl + " in " + form + " action not found.");
      } else {
        action.performAction();

      }

    } else if (naviCrtl.startsWith("conclusion_")) {
      // evaluate question !
      int buttonHashCode = Integer.valueOf(naviCrtl.split("_")[1]);
      if (buttonHashCode != CommandContainer.ESC_CONCLUSION_CODE) {
        // process form content
        form.delegateDataInForm(request);
      }

      // do conclusion
      cmdContainer.receiveAndProcess(new ConclusionEvent(buttonHashCode, findTitleOfFirstHashConclusion(buttonHashCode)));

    } else if (naviCrtl.startsWith("trigger_")) {
      // this is a request for a trigger start.
      // distribute it to forms.
      String[] selString = selectionId.split("_");
      int formId = Integer.valueOf(selString[1]);
      int selectionNum = Integer.valueOf(selString[2]);
      int actionId = Integer.valueOf(naviCrtl.split("_")[1]);

      if (!(form.actionInForm(formId, selectionNum, actionId))) {
        // A reload of the html page / resend POST data
        // leads to such a triggers problem, since old trigers will not be
        // available in current state! SHOULD WE IGNORE IT?
        throw new H2FormRequestStateException("The action " + formId + " / " + selectionNum + " / " + actionId + " was not evaluated by the form.");
      }
    }

  }

  public void setColor(String color) {
    uiColor = color;
  }


  public static Map<String, Object> createDefaultMapForCommandUI(ContextStatics statics, ContextClient client, ContextPage page, H2Dialog dlg) {
    Map<String, Object> renderMap = MapSequence.fromMap(new HashMap<String, Object>());
    MapSequence.fromMap(renderMap).put(AbstractForm.STATICS_CTX, statics);
    MapSequence.fromMap(renderMap).put(AbstractForm.CLIENT_CTX, client);
    MapSequence.fromMap(renderMap).put(AbstractForm.PAGE_CTX, page);

    MapSequence.fromMap(renderMap).put(AbstractForm.FORM, null);
    MapSequence.fromMap(renderMap).put(AbstractForm.DIALOG, dlg);
    MapSequence.fromMap(renderMap).put(AbstractForm.WINDOW_TITLE, statics.getApplicationName());

    // legacy zebra enterprise-browser support
    MapSequence.fromMap(renderMap).put(AbstractForm.KEYBOARD, false);
    MapSequence.fromMap(renderMap).put(AbstractForm.OPTIM_KEYBAORD, false);

    MapSequence.fromMap(renderMap).put(AbstractForm.CONCLUSIONS, null);

    MapSequence.fromMap(renderMap).put(AbstractForm.ESC_CONCLUSION, null);
    MapSequence.fromMap(renderMap).put(AbstractForm.SCAN_CONCLUSION, null);
    MapSequence.fromMap(renderMap).put(AbstractForm.GO_CONCLUSION, null);
    MapSequence.fromMap(renderMap).put(AbstractForm.DEFAULT_CONCLUSION, null);


    return renderMap;
  }

  public void handleResponse(HttpServletResponse response, ContextStatics statics, ContextClient client, ContextPage page, H2Dialog msg) throws IOException {
    page.setColor(uiColor);
    page.setColorD3(H2ColorUtil.calcD3Color(uiColor));
    page.setHasSessionToCommit(cmdContainer.hasRwSessionToCommit());
    page.setIsReadOnly(cmdContainer.isReadOnly());
    page.setIsDocumentSearch(cmdContainer.isDocumentSearch());

    if (msg != null && msg.isCloseQuestion()) {
      page.setScrollPosition(-1);

    } else {
      page.setScrollPosition(lastScrollTopPosition);
    }

    // set changes first .. then create default map ..
    Map<String, Object> renderMap = createDefaultMapForCommandUI(statics, client, page, msg);

    // distribute writer instance accross forms...
    int id = 1;
    form.initBeforeRender(id, response.getWriter(), statics, client, page);

    MapSequence.fromMap(renderMap).put(AbstractForm.FORM, form);
    MapSequence.fromMap(renderMap).put(AbstractForm.WINDOW_TITLE, windowTitle);
    MapSequence.fromMap(renderMap).put(AbstractForm.SPLITTED_PAGE_TITLE, form.getSplittedPageTitleText());
    MapSequence.fromMap(renderMap).put(AbstractForm.LIST_OF_PROBLEMS, form.getProblems());
    MapSequence.fromMap(renderMap).put(AbstractForm.NOTIFICATION_TEXT, notificationText);


    // have to reeval conclusions before renering
    // legacy zebra enterprise-browser support, determine conclusions etc..
    MapSequence.fromMap(renderMap).put(AbstractForm.ESC_CONCLUSION, ListSequence.fromList(conclusions).findFirst((it) -> it.triggerCode == 0));
    MapSequence.fromMap(renderMap).put(AbstractForm.SCAN_CONCLUSION, ListSequence.fromList(conclusions).findFirst((it) -> "UPD".equals(it.hotKey)));
    MapSequence.fromMap(renderMap).put(AbstractForm.GO_CONCLUSION, ListSequence.fromList(conclusions).findFirst((it) -> "GO".equals(it.hotKey)));
    MapSequence.fromMap(renderMap).put(AbstractForm.DEFAULT_CONCLUSION, ListSequence.fromList(conclusions).findLast((it) -> it.enabled));


    AbstractEditor edtr = form.firstEditorFocused();
    boolean supportsCustomKeyboard = client.getDeviceSw() != ContextClient.DevicesSw.STANDARD && client.getDeviceSw() != ContextClient.DevicesSw.STRICH && client.getDeviceSw() != ContextClient.DevicesSw.SCANDIT;

    MapSequence.fromMap(renderMap).put(AbstractForm.OPTIM_KEYBAORD, optimKeyboard && MapSequence.fromMap(renderMap).get(AbstractForm.SCAN_CONCLUSION) != null && edtr != null && edtr.scanable && supportsCustomKeyboard);

    if (form.delegatesNeedKeyboard()) {
      MapSequence.fromMap(renderMap).put(AbstractForm.KEYBOARD, supportsCustomKeyboard);
    }

    MapSequence.fromMap(renderMap).put(AbstractForm.CONCLUSIONS, conclusions);

    template.evaluate(response.getWriter(), renderMap);
  }


  public String findTitleOfFirstHashConclusion(int hashCode) {
    for (AbstractForm.PebAction action : conclusions) {
      if (action.triggerCode == hashCode) {
        return "HK_" + action.hotKey + " " + action.label;
      }
    }
    return null;
  }
  public boolean isTabWindow() {
    // allways start this tab, even if it is used as prompt window.
    return true;
  }
  public boolean isModalTabWindow() {
    return false;
  }
  @Override
  public String toString() {
    return "" + cmdContainer;
  }

  public String debugInfo() {
    String s = "CommandContainerUI.debugInfo()" + windowTitle + "\n" + form.debugInfo();
    return s;
  }
}
