package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;

public class FormContainer<T> extends HasChildForms<T> implements IToolkit_FormContainer<T> {
  private List<CmdAction> dataUXmenuActions;
  private List<AbstractForm.PebAction> actions;
  private List<AbstractForm.PebAction> topBarActions;
  private List<AbstractForm.PebAction> dropDownActions;
  private boolean hasActions;




  public FormContainer(PebbleTemplate template) {
    super(template);
    hasActions = false;
  }

  public void setLayoutConstraints(List<String> colConstraints, List<String> rowConstraints) {
  }
  @Override
  public void skipFocus(int cmptToStartWith) {
    focusController.skipFocus(cmptToStartWith);
  }

  public void addMenuAndSetButtons(Menu menu) {
    dataUXmenuActions = ListSequence.fromList(new ArrayList<CmdAction>());
    actions = ListSequence.fromList(new ArrayList<AbstractForm.PebAction>());
    topBarActions = ListSequence.fromList(new ArrayList<AbstractForm.PebAction>());
    dropDownActions = ListSequence.fromList(new ArrayList<AbstractForm.PebAction>());


    // top bar first ...
    for (CmdAction item : menu.getTopBarActions()) {
      String convertedImgName = MaterialIconsConverter.codeFor(item.image);
      AbstractForm.PebAction action = new AbstractForm.PebAction(item.labelText, item.hideWhenDisabled, item.image, convertedImgName, this.hashCode(), item.hashCode(), item.hotKey);

      ListSequence.fromList(dataUXmenuActions).addElement(item);
      ListSequence.fromList(actions).addElement(action);
      ListSequence.fromList(topBarActions).addElement(action);
    }

    // then drop down menu ...
    for (CmdAction item : menu.getDropDownActions()) {
      String convertedImgName = MaterialIconsConverter.codeFor(item.image);
      AbstractForm.PebAction action = new AbstractForm.PebAction(item.labelText, item.hideWhenDisabled, item.image, convertedImgName, this.hashCode(), item.hashCode(), item.hotKey);

      ListSequence.fromList(dataUXmenuActions).addElement(item);
      ListSequence.fromList(actions).addElement(action);
      ListSequence.fromList(dropDownActions).addElement(action);
    }

    // Fx8 positions triggers the other way round...
    dataUXmenuActions = ListSequence.fromList(dataUXmenuActions).reversedList();
    actions = ListSequence.fromList(actions).reversedList();
    topBarActions = ListSequence.fromList(topBarActions).reversedList();

    hasActions = true;
  }
  public void dispatchTopLevelHotKey(String modifier, String hk) {
  }

  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();

    MapSequence.fromMap(renderMap).put(ACTIONS, null);
    MapSequence.fromMap(renderMap).put(TOPBAR_ACTIONS, null);
    MapSequence.fromMap(renderMap).put(DROPDOWN_ACTIONS, null);
    MapSequence.fromMap(renderMap).put(CHILDREN, children);
    MapSequence.fromMap(renderMap).put(HAS_VISIBLE_ACTIONS, false);
    if (hasActions) {
      // do we have a titleText ?
      if (MapSequence.fromMap(renderMap).get(TITLE_TEXT) == null) {
        MapSequence.fromMap(renderMap).put(TITLE_TEXT, "");
      }

      for (int i = 0; i < ListSequence.fromList(dataUXmenuActions).count(); i++) {
        CmdAction mae = ListSequence.fromList(dataUXmenuActions).getElement(i);
        ListSequence.fromList(actions).getElement(i).adjustEnabled(mae.reevalEnabled());
      }

      MapSequence.fromMap(renderMap).put(ACTIONS, actions);
      if (ListSequence.fromList(topBarActions).count() > 0) {
        MapSequence.fromMap(renderMap).put(TOPBAR_ACTIONS, topBarActions);
      }
      if (ListSequence.fromList(dropDownActions).count() > 0) {
        MapSequence.fromMap(renderMap).put(DROPDOWN_ACTIONS, dropDownActions);
      }
      MapSequence.fromMap(renderMap).put(HAS_VISIBLE_ACTIONS, ListSequence.fromList(actions).any((it) -> it.visible));
    }

    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
  }

  public boolean actionInForm(int formId, int selectionNum, int actionId) {

    if (hasActions && formId == this.hashCode()) {
      // start trigger ? triggedId should be the hashCode of respective trigger
      for (CmdAction t : dataUXmenuActions) {
        if (t.hashCode() == actionId) {
          if (t.reevalEnabled()) {
            t.startCommand();
          } else {
            // set error text
            throw new H2FormRequestStateException("This can not be true: " + t.labelText + " is disabled for this selection.");
          }
        }
      }

      return true;
    }

    return super.actionInForm(formId, selectionNum, actionId);
  }

  public String debugInfo() {
    final Wrappers._T<String> s = new Wrappers._T<String>("FormContainer.debugInfo()\n");
    ListSequence.fromList(dataUXmenuActions).visitAll((it) -> s.value += it.commandFqName + " : " + it.hashCode() + "\n");
    s.value += super.debugInfo();
    return s.value;
  }


  @Override
  public void gcClear() {
    super.gcClear();
  }

}
